/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.award.amntinfo;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.dc.award.amntinfo.AwardAmountInfoDuplicatesDao;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;

public class AwardAmountInfoDuplicatesDaoImpl
implements AwardAmountInfoDuplicatesDao {
    private static final String DELETE_AMOUNT_INFO = "delete from award_amount_info where award_amount_info_id = ?";
    private static final String SELECT_AMOUNT_INFOS = "select award_amount_info_id, award_id, award_number, sequence_number, tnm_document_number, anticipated_change_direct, anticipated_change_indirect, anticipated_total_direct, anticipated_total_indirect, anticipated_total_amount, ant_distributable_amount, anticipated_change, obligated_total_direct, obligated_total_indirect, amount_obligated_to_date, obli_distributable_amount, obligated_change, obligated_change_direct, obligated_change_indirect, final_expiration_date, current_fund_effective_date, obligation_expiration_date, transaction_id, entry_type, eom_process_flag from award_amount_info where award_number = ? and transaction_id is not null and tnm_document_number is not null order by transaction_id desc, sequence_number desc";
    private static final String UPDATE_AWARD_AMOUNT_INFO_DATES = "update award_amount_info set final_expiration_date = ?, current_fund_effective_date = ?, obligation_expiration_date = ?  where award_amount_info_id = ?";
    private static final String UPDATE_AWARD_AMOUNT_INFO_CHANGE = "update award_amount_info set ANTICIPATED_CHANGE = ?, ANTICIPATED_CHANGE_DIRECT = ?, ANTICIPATED_CHANGE_INDIRECT = ?,  OBLIGATED_CHANGE = ?, OBLIGATED_CHANGE_DIRECT = ?, OBLIGATED_CHANGE_INDIRECT = ?, ANT_DISTRIBUTABLE_AMOUNT = ?, OBLI_DISTRIBUTABLE_AMOUNT = ? where award_amount_info_id = ?";
    private static final String SELECT_AWARD_NUMBERS = "select distinct award_number from award_amount_info";
    private static final String QUERY_DUPED_TABLE = "select count(*) from award_amount_info_dups";
    private static final String CREATE_DUPED_TABLE = "create table award_amount_info_dups as select * from award_amount_info where 1 = 0";
    private static final String QUERY_MOD_TABLE = "select count(*) from award_amount_info_dup_mods";
    private static final String CREATE_MOD_TABLE = "create table award_amount_info_dup_mods as select * from award_amount_info where 1 = 0";
    private static final String INSERT_DUP_RECORD = "insert into award_amount_info_dups select * from award_amount_info where award_amount_info_id = ?";
    private static final String INSERT_MOD_RECORD = "insert into award_amount_info_dup_mods select * from award_amount_info where award_amount_info_id = ?";
    private static final String SELECT_AWARD_DOC_NBR = "select document_number from award where award_id = ?";
    private static final String VALIDATE_DOCUMENT_STATUS = "select doc_hdr_stat_cd from krew_doc_hdr_t where doc_hdr_id = ?";
    private static final List<String> UNSUCCESSFUL_STATUSES = Arrays.asList("D", "X", "C");
    private static final List<String> PENDING_STATUSES = Arrays.asList("I", "S", "R", "E");
    private static final Logger LOG = LogManager.getLogger(AwardAmountInfoDuplicatesDaoImpl.class.getName());
    private ConnectionDaoService connectionDaoService;

    /*
     * Unable to fully structure code
     */
    @Override
    public void fixAwardAmountInfoDuplicates() {
        numberOfDupsRemoved = 0;
        dupsNotEqual = new ArrayList<AmountInfo>();
        totalsNotEqual = new ArrayList<AmountInfo>();
        amountInfosAffected = new ArrayList<AmountInfo>();
        conn = this.connectionDaoService.getCoeusConnection();
        riceConn = this.connectionDaoService.getRiceConnection();
        try {
            deleteAmountInfo = conn.prepareStatement("delete from award_amount_info where award_amount_info_id = ?");
            try {
                selectAmountInfos = conn.prepareStatement("select award_amount_info_id, award_id, award_number, sequence_number, tnm_document_number, anticipated_change_direct, anticipated_change_indirect, anticipated_total_direct, anticipated_total_indirect, anticipated_total_amount, ant_distributable_amount, anticipated_change, obligated_total_direct, obligated_total_indirect, amount_obligated_to_date, obli_distributable_amount, obligated_change, obligated_change_direct, obligated_change_indirect, final_expiration_date, current_fund_effective_date, obligation_expiration_date, transaction_id, entry_type, eom_process_flag from award_amount_info where award_number = ? and transaction_id is not null and tnm_document_number is not null order by transaction_id desc, sequence_number desc");
                try {
                    selectAwardNumbers = conn.prepareStatement("select distinct award_number from award_amount_info");
                    try {
                        queryForDupTable = conn.prepareStatement("select count(*) from award_amount_info_dups");
                        try {
                            createDupedTable = conn.prepareStatement("create table award_amount_info_dups as select * from award_amount_info where 1 = 0");
                            try {
                                insertDupedRecord = conn.prepareStatement("insert into award_amount_info_dups select * from award_amount_info where award_amount_info_id = ?");
                                try {
                                    selectAwardDocumentNumber = conn.prepareStatement("select document_number from award where award_id = ?");
                                    try {
                                        validateDocumentStatus = riceConn.prepareStatement("select doc_hdr_stat_cd from krew_doc_hdr_t where doc_hdr_id = ?");
                                        try {
                                            updateAwardAmountInfoDates = conn.prepareStatement("update award_amount_info set final_expiration_date = ?, current_fund_effective_date = ?, obligation_expiration_date = ?  where award_amount_info_id = ?");
                                            try {
                                                updateAwardAmountInfoChangeAmnts = conn.prepareStatement("update award_amount_info set ANTICIPATED_CHANGE = ?, ANTICIPATED_CHANGE_DIRECT = ?, ANTICIPATED_CHANGE_INDIRECT = ?,  OBLIGATED_CHANGE = ?, OBLIGATED_CHANGE_DIRECT = ?, OBLIGATED_CHANGE_INDIRECT = ?, ANT_DISTRIBUTABLE_AMOUNT = ?, OBLI_DISTRIBUTABLE_AMOUNT = ? where award_amount_info_id = ?");
                                                try {
                                                    queryForModTable = conn.prepareStatement("select count(*) from award_amount_info_dup_mods");
                                                    try {
                                                        createModTable = conn.prepareStatement("create table award_amount_info_dup_mods as select * from award_amount_info where 1 = 0");
                                                        try {
                                                            insertModRecord = conn.prepareStatement("insert into award_amount_info_dup_mods select * from award_amount_info where award_amount_info_id = ?");
                                                            try {
                                                                try {
                                                                    rs = queryForDupTable.executeQuery();
                                                                    if (rs != null) {
                                                                        rs.close();
                                                                    }
                                                                }
                                                                catch (SQLException e) {
                                                                    createDupedTable.execute();
                                                                }
                                                                try {
                                                                    rs = queryForModTable.executeQuery();
                                                                    if (rs != null) {
                                                                        rs.close();
                                                                    }
                                                                }
                                                                catch (SQLException e) {
                                                                    createModTable.execute();
                                                                }
                                                                awardNumbersRs = selectAwardNumbers.executeQuery();
lbl51:
                                                                // 2 sources

                                                                try {
                                                                    while (awardNumbersRs.next()) {
                                                                        amountInfos = new HashMap<Long, AmountInfo>();
                                                                        awardNumber = awardNumbersRs.getString(1);
                                                                        selectAmountInfos.setString(1, awardNumber);
                                                                        amountInfosRs = selectAmountInfos.executeQuery();
                                                                        try {
                                                                            while (amountInfosRs.next()) {
                                                                                currentAmountInfo = new AmountInfo(amountInfosRs);
                                                                                if (amountInfos.containsKey(currentAmountInfo.transactionId) && ((AmountInfo)amountInfos.get(currentAmountInfo.transactionId)).createdBySameTMDoc(currentAmountInfo)) {
                                                                                    newerAmountInfo = (AmountInfo)amountInfos.get(currentAmountInfo.transactionId);
                                                                                    if (!newerAmountInfo.equals(currentAmountInfo)) {
                                                                                        dupsNotEqual.add(currentAmountInfo);
                                                                                        insertModRecord.setLong(1, newerAmountInfo.awardAmountInfoId);
                                                                                        insertModRecord.execute();
                                                                                        AwardAmountInfoDuplicatesDaoImpl.LOG.warn("Deleting duplicate award_amount_infos with transaction id = " + currentAmountInfo.transactionId + " but it is not equal to later amount info. award_amount_info_ids(" + currentAmountInfo.awardAmountInfoId + ", " + newerAmountInfo.awardAmountInfoId + "). ");
                                                                                        this.updateNewerAmountInfoDates(newerAmountInfo, currentAmountInfo, updateAwardAmountInfoDates);
                                                                                        if (newerAmountInfo.totalAmountsEqual(currentAmountInfo)) {
                                                                                            this.updateNewerAmountInfoChangeAmnts(newerAmountInfo, currentAmountInfo, updateAwardAmountInfoChangeAmnts);
                                                                                        } else {
                                                                                            totalsNotEqual.add(currentAmountInfo);
                                                                                        }
                                                                                    } else if (AwardAmountInfoDuplicatesDaoImpl.PENDING_STATUSES.contains(newerAmountInfo.docStatus)) {
                                                                                        AwardAmountInfoDuplicatesDaoImpl.LOG.warn("Deleting duplicate award_amount_info for PENDING award with transaction id = " + currentAmountInfo.transactionId + " and award_amount_info_id = " + currentAmountInfo.awardAmountInfoId);
                                                                                    } else {
                                                                                        AwardAmountInfoDuplicatesDaoImpl.LOG.debug("Deleting duplicate award_amount_info with transaction id = " + currentAmountInfo.transactionId + " and award_amount_info_id = " + currentAmountInfo.awardAmountInfoId);
                                                                                    }
                                                                                    this.deleteAmountInfo(currentAmountInfo, deleteAmountInfo, insertDupedRecord);
                                                                                    ++numberOfDupsRemoved;
                                                                                    amountInfosAffected.add(currentAmountInfo);
                                                                                }
                                                                                if ((docHeaderStatusCode = this.getAwardDocumentStatus(currentAmountInfo.awardId, selectAwardDocumentNumber, validateDocumentStatus)) == null) {
                                                                                    AwardAmountInfoDuplicatesDaoImpl.LOG.error("Unable to find award record associated with award_id " + currentAmountInfo.awardId + " refusing to consider the award_amount_info_id=" + currentAmountInfo.awardAmountInfoId + " for dups status");
                                                                                    continue;
                                                                                }
                                                                                if (AwardAmountInfoDuplicatesDaoImpl.UNSUCCESSFUL_STATUSES.contains(docHeaderStatusCode)) {
                                                                                    AwardAmountInfoDuplicatesDaoImpl.LOG.info("Document status for award_id " + currentAmountInfo.awardId + " indicates it was canceled. Ignoring award_amount_info records.");
                                                                                    continue;
                                                                                }
                                                                                currentAmountInfo.docStatus = docHeaderStatusCode;
                                                                                amountInfos.put(currentAmountInfo.transactionId, currentAmountInfo);
                                                                            }
                                                                        }
                                                                        finally {
                                                                            if (amountInfosRs == null) ** GOTO lbl51
                                                                            amountInfosRs.close();
                                                                        }
                                                                    }
                                                                }
                                                                finally {
                                                                    if (awardNumbersRs != null) {
                                                                        awardNumbersRs.close();
                                                                    }
                                                                }
                                                            }
                                                            finally {
                                                                if (insertModRecord != null) {
                                                                    insertModRecord.close();
                                                                }
                                                            }
                                                        }
                                                        finally {
                                                            if (createModTable != null) {
                                                                createModTable.close();
                                                            }
                                                        }
                                                    }
                                                    finally {
                                                        if (queryForModTable != null) {
                                                            queryForModTable.close();
                                                        }
                                                    }
                                                }
                                                finally {
                                                    if (updateAwardAmountInfoChangeAmnts != null) {
                                                        updateAwardAmountInfoChangeAmnts.close();
                                                    }
                                                }
                                            }
                                            finally {
                                                if (updateAwardAmountInfoDates != null) {
                                                    updateAwardAmountInfoDates.close();
                                                }
                                            }
                                        }
                                        finally {
                                            if (validateDocumentStatus != null) {
                                                validateDocumentStatus.close();
                                            }
                                        }
                                    }
                                    finally {
                                        if (selectAwardDocumentNumber != null) {
                                            selectAwardDocumentNumber.close();
                                        }
                                    }
                                }
                                finally {
                                    if (insertDupedRecord != null) {
                                        insertDupedRecord.close();
                                    }
                                }
                            }
                            finally {
                                if (createDupedTable != null) {
                                    createDupedTable.close();
                                }
                            }
                        }
                        finally {
                            if (queryForDupTable != null) {
                                queryForDupTable.close();
                            }
                        }
                    }
                    finally {
                        if (selectAwardNumbers != null) {
                            selectAwardNumbers.close();
                        }
                    }
                }
                finally {
                    if (selectAmountInfos != null) {
                        selectAmountInfos.close();
                    }
                }
            }
            finally {
                if (deleteAmountInfo != null) {
                    deleteAmountInfo.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        AwardAmountInfoDuplicatesDaoImpl.LOG.info("Removed " + numberOfDupsRemoved + " duplicate award_amount_info transactions removed from previous award versions.");
        if (!dupsNotEqual.isEmpty()) {
            potentialAwardsChanged = dupsNotEqual.stream().map((Function<AmountInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$fixAwardAmountInfoDuplicates$0(org.kuali.coeus.dc.award.amntinfo.AwardAmountInfoDuplicatesDaoImpl$AmountInfo ), (Lorg/kuali/coeus/dc/award/amntinfo/AwardAmountInfoDuplicatesDaoImpl$AmountInfo;)Ljava/lang/String;)()).distinct().sorted().collect(Collectors.toList());
            AwardAmountInfoDuplicatesDaoImpl.LOG.warn("The following " + dupsNotEqual.size() + " transaction ids had duplicates that were not equal. These have still been removed as they were likely modified in the award after the T&M doc finalization, but confirm that these records still reflect correct amounts. " + dupsNotEqual.stream().map((Function<AmountInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$fixAwardAmountInfoDuplicates$1(org.kuali.coeus.dc.award.amntinfo.AwardAmountInfoDuplicatesDaoImpl$AmountInfo ), (Lorg/kuali/coeus/dc/award/amntinfo/AwardAmountInfoDuplicatesDaoImpl$AmountInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", ")));
            AwardAmountInfoDuplicatesDaoImpl.LOG.warn("The following " + potentialAwardsChanged.size() + " awards had transactions removed that were different. Verify they are still correct. (" + potentialAwardsChanged.stream().collect(Collectors.joining(", ")) + ")");
        }
        if (!totalsNotEqual.isEmpty()) {
            potentialAwardsChanged = totalsNotEqual.stream().map((Function<AmountInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$fixAwardAmountInfoDuplicates$2(org.kuali.coeus.dc.award.amntinfo.AwardAmountInfoDuplicatesDaoImpl$AmountInfo ), (Lorg/kuali/coeus/dc/award/amntinfo/AwardAmountInfoDuplicatesDaoImpl$AmountInfo;)Ljava/lang/String;)()).distinct().sorted().collect(Collectors.toList());
            AwardAmountInfoDuplicatesDaoImpl.LOG.warn("The following " + totalsNotEqual.size() + " transaction ids had duplicates where the total amounts were not equal. These have still been removed as they were likely modified in the award after the T&M doc finalization, but confirm that these records still reflect correct amounts. " + totalsNotEqual.stream().map((Function<AmountInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$fixAwardAmountInfoDuplicates$3(org.kuali.coeus.dc.award.amntinfo.AwardAmountInfoDuplicatesDaoImpl$AmountInfo ), (Lorg/kuali/coeus/dc/award/amntinfo/AwardAmountInfoDuplicatesDaoImpl$AmountInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", ")));
            AwardAmountInfoDuplicatesDaoImpl.LOG.warn("The following " + potentialAwardsChanged.size() + " awards had transactions removed where the totals were not equal. Verify they are still correct. (" + potentialAwardsChanged.stream().collect(Collectors.joining(", ")) + ")");
        }
        if (!amountInfosAffected.isEmpty()) {
            AwardAmountInfoDuplicatesDaoImpl.LOG.warn("The following awards were affected by duplicate transactions. (" + amountInfosAffected.stream().map((Function<AmountInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$fixAwardAmountInfoDuplicates$4(org.kuali.coeus.dc.award.amntinfo.AwardAmountInfoDuplicatesDaoImpl$AmountInfo ), (Lorg/kuali/coeus/dc/award/amntinfo/AwardAmountInfoDuplicatesDaoImpl$AmountInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", ")) + ")");
        }
    }

    protected void updateNewerAmountInfoChangeAmnts(AmountInfo newerAmountInfo, AmountInfo currentAmountInfo, PreparedStatement updateAwardAmountInfoChangeAmnts) throws SQLException {
        updateAwardAmountInfoChangeAmnts.setBigDecimal(1, currentAmountInfo.anticipatedChange);
        updateAwardAmountInfoChangeAmnts.setBigDecimal(2, currentAmountInfo.anticipatedChangeDirect);
        updateAwardAmountInfoChangeAmnts.setBigDecimal(3, currentAmountInfo.anticipatedChangeIndirect);
        updateAwardAmountInfoChangeAmnts.setBigDecimal(4, currentAmountInfo.obligatedChange);
        updateAwardAmountInfoChangeAmnts.setBigDecimal(5, currentAmountInfo.obligatedChangeDirect);
        updateAwardAmountInfoChangeAmnts.setBigDecimal(6, currentAmountInfo.obligatedChangeIndirect);
        updateAwardAmountInfoChangeAmnts.setBigDecimal(7, currentAmountInfo.anticipatedDistributableAmount);
        updateAwardAmountInfoChangeAmnts.setBigDecimal(8, currentAmountInfo.obligatedDistributableAmount);
        updateAwardAmountInfoChangeAmnts.setLong(9, newerAmountInfo.awardAmountInfoId);
        updateAwardAmountInfoChangeAmnts.execute();
    }

    protected void deleteAmountInfo(AmountInfo currentAmountInfo, PreparedStatement deleteAmountInfo, PreparedStatement insertDupedRecord) throws SQLException {
        insertDupedRecord.setLong(1, currentAmountInfo.awardAmountInfoId);
        insertDupedRecord.executeUpdate();
        deleteAmountInfo.setLong(1, currentAmountInfo.awardAmountInfoId);
        deleteAmountInfo.executeUpdate();
    }

    protected void updateNewerAmountInfoDates(AmountInfo newerAmountInfo, AmountInfo olderAmountInfo, PreparedStatement updateAwardAmountInfoDates) throws SQLException {
        updateAwardAmountInfoDates.setDate(1, olderAmountInfo.finalExpirationDate);
        updateAwardAmountInfoDates.setDate(2, olderAmountInfo.currentFundEffectiveDate);
        updateAwardAmountInfoDates.setDate(3, olderAmountInfo.obligationExpirationDate);
        updateAwardAmountInfoDates.setLong(4, newerAmountInfo.awardAmountInfoId);
        updateAwardAmountInfoDates.execute();
    }

    String getAwardDocumentStatus(Long awardId, PreparedStatement selectAwardDocumentNumber, PreparedStatement validateDocumentStatus) throws SQLException {
        selectAwardDocumentNumber.setLong(1, awardId);
        String documentNumber = null;
        String docHeaderStatusCode = null;
        try (ResultSet rs = selectAwardDocumentNumber.executeQuery();){
            if (rs.next()) {
                documentNumber = rs.getString(1);
            }
        }
        if (documentNumber != null) {
            validateDocumentStatus.setString(1, documentNumber);
            rs = validateDocumentStatus.executeQuery();
            try {
                if (rs.next()) {
                    docHeaderStatusCode = rs.getString(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        return docHeaderStatusCode;
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }

    private static /* synthetic */ String lambda$fixAwardAmountInfoDuplicates$4(AmountInfo amountInfo) {
        return amountInfo.awardNumber;
    }

    private static /* synthetic */ String lambda$fixAwardAmountInfoDuplicates$3(AmountInfo amountInfo) {
        return String.valueOf(amountInfo.transactionId);
    }

    private static /* synthetic */ String lambda$fixAwardAmountInfoDuplicates$2(AmountInfo amountInfo) {
        return amountInfo.awardNumber;
    }

    private static /* synthetic */ String lambda$fixAwardAmountInfoDuplicates$1(AmountInfo amountInfo) {
        return String.valueOf(amountInfo.transactionId);
    }

    private static /* synthetic */ String lambda$fixAwardAmountInfoDuplicates$0(AmountInfo amountInfo) {
        return amountInfo.awardNumber;
    }

    static class AmountInfo {
        Long awardAmountInfoId;
        Long awardId;
        String awardNumber;
        Integer sequenceNumber;
        String tnmDocumentNumber;
        BigDecimal anticipatedChangeDirect;
        BigDecimal anticipatedChangeIndirect;
        BigDecimal anticipatedTotalDirect;
        BigDecimal anticipatedTotalIndirect;
        BigDecimal anticipatedTotalAmount;
        BigDecimal anticipatedDistributableAmount;
        BigDecimal anticipatedChange;
        BigDecimal obligatedTotalDirect;
        BigDecimal obligatedTotalIndirect;
        BigDecimal amountObligatedToDate;
        BigDecimal obligatedDistributableAmount;
        BigDecimal obligatedChange;
        BigDecimal obligatedChangeDirect;
        BigDecimal obligatedChangeIndirect;
        Date finalExpirationDate;
        Date currentFundEffectiveDate;
        Date obligationExpirationDate;
        Long transactionId;
        String entryType;
        String eomProcessFlag;
        String docStatus;

        public AmountInfo(ResultSet rs) throws SQLException {
            this.awardAmountInfoId = rs.getLong(1);
            this.awardId = rs.getLong(2);
            this.awardNumber = rs.getString(3);
            this.sequenceNumber = rs.getInt(4);
            this.tnmDocumentNumber = rs.getString(5);
            this.anticipatedChangeDirect = rs.getBigDecimal(6);
            this.anticipatedChangeIndirect = rs.getBigDecimal(7);
            this.anticipatedTotalDirect = rs.getBigDecimal(8);
            this.anticipatedTotalIndirect = rs.getBigDecimal(9);
            this.anticipatedTotalAmount = rs.getBigDecimal(10);
            this.anticipatedDistributableAmount = rs.getBigDecimal(11);
            this.anticipatedChange = rs.getBigDecimal(12);
            this.obligatedTotalDirect = rs.getBigDecimal(13);
            this.obligatedTotalIndirect = rs.getBigDecimal(14);
            this.amountObligatedToDate = rs.getBigDecimal(15);
            this.obligatedDistributableAmount = rs.getBigDecimal(16);
            this.obligatedChange = rs.getBigDecimal(17);
            this.obligatedChangeDirect = rs.getBigDecimal(18);
            this.obligatedChangeIndirect = rs.getBigDecimal(19);
            this.finalExpirationDate = rs.getDate(20);
            this.currentFundEffectiveDate = rs.getDate(21);
            this.obligationExpirationDate = rs.getDate(22);
            this.transactionId = rs.getLong(23);
            this.entryType = rs.getString(24);
            this.eomProcessFlag = rs.getString(25);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.amountObligatedToDate == null ? 0 : this.amountObligatedToDate.hashCode());
            result = 31 * result + (this.anticipatedChange == null ? 0 : this.anticipatedChange.hashCode());
            result = 31 * result + (this.anticipatedChangeDirect == null ? 0 : this.anticipatedChangeDirect.hashCode());
            result = 31 * result + (this.anticipatedChangeIndirect == null ? 0 : this.anticipatedChangeIndirect.hashCode());
            result = 31 * result + (this.anticipatedDistributableAmount == null ? 0 : this.anticipatedDistributableAmount.hashCode());
            result = 31 * result + (this.anticipatedTotalAmount == null ? 0 : this.anticipatedTotalAmount.hashCode());
            result = 31 * result + (this.anticipatedTotalDirect == null ? 0 : this.anticipatedTotalDirect.hashCode());
            result = 31 * result + (this.anticipatedTotalIndirect == null ? 0 : this.anticipatedTotalIndirect.hashCode());
            result = 31 * result + (this.awardAmountInfoId == null ? 0 : this.awardAmountInfoId.hashCode());
            result = 31 * result + (this.currentFundEffectiveDate == null ? 0 : this.currentFundEffectiveDate.hashCode());
            result = 31 * result + (this.entryType == null ? 0 : this.entryType.hashCode());
            result = 31 * result + (this.eomProcessFlag == null ? 0 : this.eomProcessFlag.hashCode());
            result = 31 * result + (this.finalExpirationDate == null ? 0 : this.finalExpirationDate.hashCode());
            result = 31 * result + (this.obligatedChange == null ? 0 : this.obligatedChange.hashCode());
            result = 31 * result + (this.obligatedChangeDirect == null ? 0 : this.obligatedChangeDirect.hashCode());
            result = 31 * result + (this.obligatedChangeIndirect == null ? 0 : this.obligatedChangeIndirect.hashCode());
            result = 31 * result + (this.obligatedDistributableAmount == null ? 0 : this.obligatedDistributableAmount.hashCode());
            result = 31 * result + (this.obligatedTotalDirect == null ? 0 : this.obligatedTotalDirect.hashCode());
            result = 31 * result + (this.obligatedTotalIndirect == null ? 0 : this.obligatedTotalIndirect.hashCode());
            result = 31 * result + (this.obligationExpirationDate == null ? 0 : this.obligationExpirationDate.hashCode());
            result = 31 * result + (this.tnmDocumentNumber == null ? 0 : this.tnmDocumentNumber.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AmountInfo other = (AmountInfo)obj;
            if (this.amountObligatedToDate == null ? other.amountObligatedToDate != null : !this.amountObligatedToDate.equals(other.amountObligatedToDate)) {
                return false;
            }
            if (this.anticipatedChange == null ? other.anticipatedChange != null : !this.anticipatedChange.equals(other.anticipatedChange)) {
                return false;
            }
            if (this.anticipatedChangeDirect == null ? other.anticipatedChangeDirect != null : !this.anticipatedChangeDirect.equals(other.anticipatedChangeDirect)) {
                return false;
            }
            if (this.anticipatedChangeIndirect == null ? other.anticipatedChangeIndirect != null : !this.anticipatedChangeIndirect.equals(other.anticipatedChangeIndirect)) {
                return false;
            }
            if (this.anticipatedDistributableAmount == null ? other.anticipatedDistributableAmount != null : !this.anticipatedDistributableAmount.equals(other.anticipatedDistributableAmount)) {
                return false;
            }
            if (this.anticipatedTotalAmount == null ? other.anticipatedTotalAmount != null : !this.anticipatedTotalAmount.equals(other.anticipatedTotalAmount)) {
                return false;
            }
            if (this.anticipatedTotalDirect == null ? other.anticipatedTotalDirect != null : !this.anticipatedTotalDirect.equals(other.anticipatedTotalDirect)) {
                return false;
            }
            if (this.anticipatedTotalIndirect == null ? other.anticipatedTotalIndirect != null : !this.anticipatedTotalIndirect.equals(other.anticipatedTotalIndirect)) {
                return false;
            }
            if (this.currentFundEffectiveDate == null ? other.currentFundEffectiveDate != null : !this.currentFundEffectiveDate.equals(other.currentFundEffectiveDate)) {
                return false;
            }
            if (this.entryType == null ? other.entryType != null : !this.entryType.equals(other.entryType)) {
                return false;
            }
            if (this.eomProcessFlag == null ? other.eomProcessFlag != null : !this.eomProcessFlag.equals(other.eomProcessFlag)) {
                return false;
            }
            if (this.finalExpirationDate == null ? other.finalExpirationDate != null : !this.finalExpirationDate.equals(other.finalExpirationDate)) {
                return false;
            }
            if (this.obligatedChange == null ? other.obligatedChange != null : !this.obligatedChange.equals(other.obligatedChange)) {
                return false;
            }
            if (this.obligatedChangeDirect == null ? other.obligatedChangeDirect != null : !this.obligatedChangeDirect.equals(other.obligatedChangeDirect)) {
                return false;
            }
            if (this.obligatedChangeIndirect == null ? other.obligatedChangeIndirect != null : !this.obligatedChangeIndirect.equals(other.obligatedChangeIndirect)) {
                return false;
            }
            if (this.obligatedDistributableAmount == null ? other.obligatedDistributableAmount != null : !this.obligatedDistributableAmount.equals(other.obligatedDistributableAmount)) {
                return false;
            }
            if (this.obligatedTotalDirect == null ? other.obligatedTotalDirect != null : !this.obligatedTotalDirect.equals(other.obligatedTotalDirect)) {
                return false;
            }
            if (this.obligatedTotalIndirect == null ? other.obligatedTotalIndirect != null : !this.obligatedTotalIndirect.equals(other.obligatedTotalIndirect)) {
                return false;
            }
            if (this.obligationExpirationDate == null ? other.obligationExpirationDate != null : !this.obligationExpirationDate.equals(other.obligationExpirationDate)) {
                return false;
            }
            return !(this.tnmDocumentNumber == null ? other.tnmDocumentNumber != null : !this.tnmDocumentNumber.equals(other.tnmDocumentNumber));
        }

        public boolean createdBySameTMDoc(AmountInfo other) {
            return !(this.tnmDocumentNumber == null ? other.tnmDocumentNumber != null : !this.tnmDocumentNumber.equals(other.tnmDocumentNumber));
        }

        public boolean totalAmountsEqual(AmountInfo other) {
            if (this.amountObligatedToDate == null ? other.amountObligatedToDate != null : !this.amountObligatedToDate.equals(other.amountObligatedToDate)) {
                return false;
            }
            if (this.anticipatedTotalAmount == null ? other.anticipatedTotalAmount != null : !this.anticipatedTotalAmount.equals(other.anticipatedTotalAmount)) {
                return false;
            }
            if (this.anticipatedTotalDirect == null ? other.anticipatedTotalDirect != null : !this.anticipatedTotalDirect.equals(other.anticipatedTotalDirect)) {
                return false;
            }
            if (this.anticipatedTotalIndirect == null ? other.anticipatedTotalIndirect != null : !this.anticipatedTotalIndirect.equals(other.anticipatedTotalIndirect)) {
                return false;
            }
            if (this.obligatedTotalDirect == null ? other.obligatedTotalDirect != null : !this.obligatedTotalDirect.equals(other.obligatedTotalDirect)) {
                return false;
            }
            return !(this.obligatedTotalIndirect == null ? other.obligatedTotalIndirect != null : !this.obligatedTotalIndirect.equals(other.obligatedTotalIndirect));
        }
    }
}

