/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import com.fasterxml.jackson.databind.json.JsonMapper;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.ProgressModel;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;

public class ProgressLoggerJson
implements ProgressLogger {
    private static final Log LOG = LogFactory.getLog(ProgressLoggerJson.class);
    private final ProgressModel progressModel = new ProgressModel();
    private final JsonMapper jsonMapper = new JsonMapper();

    @Override
    public ProgressLogger subTask(String operationName) {
        return new ProgressLoggerJson(this.progressModel.getOperation() + "." + operationName);
    }

    public ProgressLoggerJson(String operationName) {
        this.progressModel.setOperation(operationName);
    }

    @Override
    public void log(String message) {
        this.progressModel.setMessage(message);
        System.err.println(this.jsonMapper.writeValueAsString(this.progressModel));
        this.progressModel.setStepAndTotal(this.progressModel.getStep() + 1);
    }

    @Override
    public void log(String message, int step) {
        this.progressModel.setMessage(message);
        this.progressModel.setStepAndTotal(step);
        System.err.println(this.jsonMapper.writeValueAsString(this.progressModel));
    }

    @Override
    public ProgressLogger pushSteps(int steps) {
        this.progressModel.setTotalSteps(this.progressModel.getTotalSteps() == null ? steps : steps + this.progressModel.getTotalSteps());
        return this;
    }
}

