/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.mariadb.jdbc.BasePreparedStatement;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.ParameterMetaData;
import org.mariadb.jdbc.SimpleParameterMetaData;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.result.CompleteResult;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.result.ResultSetMetaData;
import org.mariadb.jdbc.client.util.ClosableLock;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.PreparePacket;
import org.mariadb.jdbc.message.client.QueryWithParametersPacket;
import org.mariadb.jdbc.message.server.OkPacket;
import org.mariadb.jdbc.util.ClientParser;
import org.mariadb.jdbc.util.ParameterList;
import org.mariadb.jdbc.util.timeout.QueryTimeoutHandler;

public class ClientPreparedStatement
extends BasePreparedStatement {
    private final ClientParser parser;

    public ClientPreparedStatement(String sql, Connection con, ClosableLock lock, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) {
        super(sql, con, lock, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        boolean noBackslashEscapes = (con.getContext().getServerStatus() & 0x200) > 0;
        this.parser = ClientParser.parameterParts(sql, noBackslashEscapes);
        this.parameters = new ParameterList(this.parser.getParamCount());
    }

    protected String preSqlCmd() {
        if (this.queryTimeout != 0 && this.con.useServerTimeout()) {
            if (this.con.useServerMaxRows() && this.maxRows > 0L) {
                return "SET STATEMENT max_statement_time=" + this.queryTimeout + ", SQL_SELECT_LIMIT=" + this.maxRows + " FOR ";
            }
            return "SET STATEMENT max_statement_time=" + this.queryTimeout + " FOR ";
        }
        if (this.con.useServerMaxRows() && this.maxRows > 0L) {
            return "SET STATEMENT SQL_SELECT_LIMIT=" + this.maxRows + " FOR ";
        }
        return null;
    }

    private void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.validParameters();
        try (ClosableLock ignore = this.lock.closeableLock();
             QueryTimeoutHandler ignore2 = this.con.handleTimeout(this.queryTimeout);){
            QueryWithParametersPacket query = new QueryWithParametersPacket(this.preSqlCmd(), this.parser, this.parameters, this.localInfileInputStream);
            this.results = this.con.getClient().execute(query, this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.localInfileInputStream = null;
        }
    }

    @Override
    protected boolean executeInternalPreparedBatch() throws SQLException {
        this.checkNotClosed();
        this.parseCommandIfNeeded(this.sql);
        Configuration conf = this.con.getContext().getConf();
        boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
        if (possibleLoadLocal) {
            String sqlUpper = this.sql.toUpperCase(Locale.ROOT);
            boolean bl = possibleLoadLocal = sqlUpper.contains(" LOCAL ") && sqlUpper.contains("LOAD") && sqlUpper.contains(" INFILE");
        }
        if (possibleLoadLocal) {
            this.executeBatchStd();
        } else {
            boolean canUseBulk;
            boolean bl = canUseBulk = !(!this.con.getContext().hasServerCapability(0x400000000L) || (!this.clientParser.isInsert() || !conf.useBulkStmts() && !conf.useBulkStmtsForInserts() || !this.con.getContext().hasClientCapability(0x2000000000L) && this.clientParser.isInsertDuplicate()) && (this.clientParser.isInsert() || !conf.useBulkStmts()) || !this.con.getContext().hasClientCapability(0x2000000000L) && this.autoGeneratedKeys == 1);
            if (canUseBulk && this.batchParameters.size() > 1 && !this.clientParser.isMultiQuery() && ((Parameters)this.batchParameters.get(0)).size() > 0) {
                this.executeBatchBulk(this.escapeTimeout(this.sql));
                return true;
            }
            this.executeBatchPipeline();
        }
        return false;
    }

    private void executeBatchPipeline() throws SQLException {
        ClientMessage[] packets = new ClientMessage[this.batchParameters.size()];
        for (int i = 0; i < this.batchParameters.size(); ++i) {
            packets[i] = new QueryWithParametersPacket(this.preSqlCmd(), this.parser, (Parameters)this.batchParameters.get(i), null);
        }
        try {
            this.results = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
        }
        catch (SQLException bue) {
            this.results = null;
            throw bue;
        }
    }

    private void executeBatchStd() throws SQLException {
        try {
            this.results = new ArrayList();
            for (int i = 0; i < this.batchParameters.size(); ++i) {
                this.results.addAll(this.con.getClient().execute(new QueryWithParametersPacket(this.preSqlCmd(), this.parser, (Parameters)this.batchParameters.get(i), this.localInfileInputStream), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false));
            }
        }
        catch (SQLException bue) {
            BatchUpdateException exception = this.exceptionFactory().createBatchUpdate(this.results, this.batchParameters.size(), bue);
            this.results = null;
            this.localInfileInputStream = null;
            throw exception;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        return this.currResult instanceof Result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        if (this.con.getContext().getConf().permitNoResults()) {
            return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext(), this.resultSetType);
        }
        throw new SQLException("PrepareStatement.executeQuery() command does NOT return a result-set as expected. Either use PrepareStatement.execute(), PrepareStatement.executeUpdate(), or correct command");
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.parameters);
        this.parameters = this.parameters.clone();
    }

    protected void validParameters() throws SQLException {
        for (int i = 0; i < this.parser.getParamCount(); ++i) {
            if (this.parameters.containsKey(i)) continue;
            throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        super.setQueryTimeout(seconds);
        if (this.con.useServerTimeout() && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        super.setMaxRows(max);
        if (this.con.useServerMaxRows() && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        super.setLargeMaxRows(max);
        if (this.con.useServerMaxRows() && this.prepareResult != null) {
            this.prepareResult.close(this.con.getClient());
            this.prepareResult = null;
        }
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ResultSetMetaData(this.exceptionFactory(), this.prepareResult.getColumns(), this.con.getContext().getConf(), false);
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.prepareResult == null) {
            try {
                this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
            }
            catch (SQLException e) {
                return new SimpleParameterMetaData(this.exceptionFactory(), this.parser.getParamCount());
            }
        }
        return new ParameterMetaData(this.exceptionFactory(), this.prepareResult.getParameters());
    }

    @Override
    public void close() throws SQLException {
        if (this.prepareResult != null) {
            try (ClosableLock ignore = this.lock.closeableLock();){
                this.prepareResult.close(this.con.getClient());
            }
        }
        this.con.fireStatementClosed(this);
        super.close();
    }

    @Override
    public String toString() {
        return "ClientPreparedStatement{" + super.toString() + '}';
    }
}

