/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.exception;

import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlErrorCode;
import org.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlNoDriversForInteractiveAuthException;
import org.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlNoIntegratedAuthException;
import org.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlServerUntrustedCertificateSqlException;
import org.flywaydb.core.internal.jdbc.DriverDataSource;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class FlywaySqlException
extends FlywayException {
    private final FlywaySqlErrorCode subErrorCode;
    private final String sqlState;
    private final int sqlErrorCode;
    private final Throwable innerCause;

    private static List<Class<? extends FlywaySqlException>> getSpecificFlywaySqlExceptionClasses() {
        return List.of(FlywaySqlServerUntrustedCertificateSqlException.class, FlywaySqlNoIntegratedAuthException.class, FlywaySqlNoDriversForInteractiveAuthException.class);
    }

    public FlywaySqlException(String message, SQLException sqlException) {
        this(message, sqlException, null);
    }

    public FlywaySqlException(String message, SQLException sqlException, FlywaySqlErrorCode subErrorCode) {
        super(message, sqlException, CoreErrorCode.DB_CONNECTION);
        this.subErrorCode = subErrorCode;
        this.sqlState = sqlException.getSQLState();
        this.sqlErrorCode = sqlException.getErrorCode();
        this.innerCause = sqlException.getCause();
    }

    @Override
    public String getMessage() {
        String title = super.getMessage();
        String underline = StringUtils.trimOrPad("", title.length(), '-');
        return title + "\n" + underline + "\n" + ExceptionUtils.toMessage((SQLException)this.getCause());
    }

    public static void throwFlywayExceptionIfPossible(SQLException sqlException, DataSource dataSource) {
        for (Class<? extends FlywaySqlException> x : FlywaySqlException.getSpecificFlywaySqlExceptionClasses()) {
            if (!((Boolean)x.getMethod("isFlywaySpecificVersionOf", SQLException.class).invoke(null, sqlException)).booleanValue()) continue;
            throw x.getDeclaredConstructor(SQLException.class, DataSource.class).newInstance(sqlException, dataSource);
        }
    }

    protected static String getDataSourceInfo(DataSource dataSource, boolean suppressNullUserMessage) {
        if (!(dataSource instanceof DriverDataSource)) {
            return "";
        }
        DriverDataSource driverDataSource = (DriverDataSource)dataSource;
        String user = driverDataSource.getUser();
        String info = " (" + DatabaseTypeRegister.redactJdbcUrl(driverDataSource.getUrl()) + ")";
        if (user != null || !suppressNullUserMessage) {
            info = info + " for user '" + user + "'";
        }
        return info;
    }

    public FlywaySqlErrorCode getSubErrorCode() {
        return this.subErrorCode;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public int getSqlErrorCode() {
        return this.sqlErrorCode;
    }

    public Throwable getInnerCause() {
        return this.innerCause;
    }
}

