-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

drop procedure if exists duplicate_ip_sequence_numbers;

DELIMITER /
CREATE PROCEDURE duplicate_ip_sequence_numbers()
  BEGIN
    DECLARE DONE INT DEFAULT FALSE;
    DECLARE tmp_proposal_number varchar(8);

    DECLARE CUR CURSOR FOR SELECT proposal_number FROM proposal GROUP BY proposal_number, sequence_number HAVING COUNT(*) > 1;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET DONE = TRUE;

    OPEN CUR;

    read_loop: LOOP
      FETCH CUR INTO tmp_proposal_number;
      IF DONE THEN
        LEAVE read_loop;
      END IF;

    SET @correct_seq=0;

    UPDATE proposal
    SET sequence_number = (
      SELECT c.correct_seq
      FROM (
        SELECT @correct_seq:=@correct_seq+1 AS correct_seq, proposal_id, proposal_number, sequence_number
        FROM proposal
        WHERE proposal_number = tmp_proposal_number
        ORDER BY proposal_id
      ) AS c WHERE proposal.proposal_id = c.proposal_id
    )
    WHERE proposal_number = tmp_proposal_number;

    END LOOP;

    CLOSE CUR;
  END
/
DELIMITER ;
CALL duplicate_ip_sequence_numbers();

drop procedure if exists duplicate_ip_sequence_numbers;
