-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
CREATE TABLE IACUC_PROTOCOL_SPECIES ( 
    IACUC_PROTOCOL_SPECIES_ID DECIMAL(12,0) NOT NULL, 
    PROTOCOL_ID DECIMAL(12,0) NOT NULL, 
    PROTOCOL_NUMBER VARCHAR(20) NOT NULL, 
    SEQUENCE_NUMBER DECIMAL(4,0) NOT NULL, 
    SPECIES_ID DECIMAL(3,0) NOT NULL, 
    SPECIES_CODE DECIMAL(4,0) NOT NULL, 
    SPECIES_GROUP VARCHAR(50) NOT NULL, 
    IS_USDA_COVERED VARCHAR(1) NOT NULL, 
    STRAIN VARCHAR(30), 
    SPECIES_COUNT DECIMAL(8,0), 
    PAIN_CATEGORY_CODE DECIMAL(3,0), 
    SPECIES_COUNT_CODE DECIMAL(3,0), 
    EXCEPTIONS_PRESENT VARCHAR(1) DEFAULT 'N', 
    PROCEDURE_SUMMARY VARCHAR(2000), 
    UPDATE_TIMESTAMP DATE NOT NULL, 
    UPDATE_USER VARCHAR(60) NOT NULL, 
    VER_NBR DECIMAL(8,0) DEFAULT 1 NOT NULL, 
    OBJ_ID VARCHAR(36) NOT NULL) ENGINE InnoDB CHARACTER SET utf8 COLLATE utf8_bin
/


ALTER TABLE IACUC_PROTOCOL_SPECIES 
ADD CONSTRAINT PK_IACUC_PROTOCOL_SPECIES 
PRIMARY KEY (IACUC_PROTOCOL_SPECIES_ID) 
/

DELIMITER ;
