/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.questseq;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.common.db.PreparedStatementUtils;
import org.kuali.coeus.dc.questseq.QuestSeqDao;

public class QuestSeqDaoImpl
implements QuestSeqDao {
    private static final String QUESTION_ID = "Question ID";
    private static final String QUESTION_REF_ID = "Question Ref ID";
    private static final String QUESTIONNAIRE_ID = "Questionnaire ID";
    private static final String QUESTIONNAIRE_REF_ID = "Questionnaire Ref ID";
    private static final String QUESTION_SEQ_ID = "Question Seq ID";
    private static final String QUESTIONNAIRE_SEQ_ID = "Questionnaire Seq ID";
    private ConnectionDaoService connectionDaoService;

    @Override
    public void convertQuestSeqKrmsValues() {
        Collection<TermParm> parmsQuestion = this.getTermParmWithName(QUESTION_ID);
        for (TermParm parm : parmsQuestion) {
            parm.name = QUESTION_SEQ_ID;
            parm.versionNumber = parm.versionNumber + 1L;
        }
        this.updateTermParms(parmsQuestion);
        this.updateTermResolverParamSpecName(QUESTION_ID, QUESTION_SEQ_ID);
        this.updateTermResolverParamSpecName(QUESTION_REF_ID, QUESTION_SEQ_ID);
        Collection<TermParm> parmsQuestionnaire = this.getTermParmWithName(QUESTIONNAIRE_ID);
        parmsQuestionnaire.addAll(this.getTermParmWithName(QUESTIONNAIRE_REF_ID));
        for (TermParm parm : parmsQuestionnaire) {
            parm.name = QUESTIONNAIRE_SEQ_ID;
            parm.value = this.getQuestionnaireSeqId(parm.value);
            parm.versionNumber = parm.versionNumber + 1L;
        }
        this.updateTermParms(parmsQuestionnaire);
        this.updateTermResolverParamSpecName(QUESTIONNAIRE_ID, QUESTIONNAIRE_SEQ_ID);
        this.updateTermResolverParamSpecName(QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_SEQ_ID);
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getQuestionnaireSeqId(String questionnaireId) {
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(1, questionnaireId, connection.prepareStatement("SELECT QUESTIONNAIRE_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_REF_ID = ?"));){
            String string;
            block18: {
                ResultSet result;
                block16: {
                    String string2;
                    block17: {
                        result = stmt.executeQuery();
                        try {
                            if (!result.next()) break block16;
                            string2 = result.getString(1);
                            if (result == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return string2;
                }
                string = null;
                if (result == null) break block18;
                result.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Collection<TermParm> getTermParmWithName(String name) {
        Connection connection = this.connectionDaoService.getRiceConnection();
        ArrayList<TermParm> parms = new ArrayList<TermParm>();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(1, name, connection.prepareStatement("SELECT term_parm_id, term_id, nm, val, ver_nbr FROM krms_term_parm_t WHERE nm = ?"));){
            ArrayList<TermParm> arrayList;
            block15: {
                ResultSet result = stmt.executeQuery();
                try {
                    while (result.next()) {
                        parms.add(new TermParm(result.getString(1), result.getString(2), result.getString(3), result.getString(4), result.getLong(5)));
                    }
                    arrayList = parms;
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateTermParms(Collection<TermParm> parms) {
        for (TermParm parm : parms) {
            Connection connection = this.connectionDaoService.getRiceConnection();
            try {
                PreparedStatement stmt = PreparedStatementUtils.setString(4, parm.id, PreparedStatementUtils.setLong(3, parm.versionNumber, PreparedStatementUtils.setString(2, parm.value, PreparedStatementUtils.setString(1, parm.name, connection.prepareStatement("UPDATE krms_term_parm_t SET nm = ?, val = ?, ver_nbr = ? WHERE term_parm_id = ?")))));
                try {
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateTermResolverParamSpecName(String oldName, String newName) {
        Connection connection = this.connectionDaoService.getRiceConnection();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(2, oldName, PreparedStatementUtils.setString(1, newName, connection.prepareStatement("update KRMS_TERM_RSLVR_PARM_SPEC_T set nm = ? where nm = ?")));){
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static class TermParm {
        private String id;
        private String termId;
        private String name;
        private String value;
        private Long versionNumber;

        public TermParm(String id, String termId, String name, String value, Long versionNumber) {
            this.id = id;
            this.termId = termId;
            this.name = name;
            this.value = value;
            this.versionNumber = versionNumber;
        }
    }
}

