-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

-- Broken data cleanup PROPOSAL_PERS_UNIT_CRED_SPLITS
DROP TABLE IF EXISTS PROP_PERS_UNIT_CRED_SPLITS_v2007_007;
CREATE TABLE PROP_PERS_UNIT_CRED_SPLITS_v2007_007 AS
SELECT *
FROM PROPOSAL_PERS_UNIT_CRED_SPLITS
WHERE PROPOSAL_PERSON_UNIT_ID IN (
    SELECT PROPOSAL_PERSON_UNIT_ID
    FROM PROPOSAL_PERSON_UNITS
    WHERE NOT EXISTS(
            SELECT PROPOSAL_PERSON_ID
            FROM PROPOSAL_PERSONS
            WHERE PROPOSAL_PERSON_ID = PROPOSAL_PERSON_UNITS.PROPOSAL_PERSON_ID
        )
       OR NOT EXISTS(
            SELECT UNIT_NUMBER
            FROM UNIT
            WHERE UNIT_NUMBER = PROPOSAL_PERSON_UNITS.UNIT_NUMBER
        )
       OR UNIT_NUMBER IS NULL
)
   OR NOT EXISTS(
        SELECT PROPOSAL_PERSON_UNIT_ID
        FROM PROPOSAL_PERSON_UNITS
        WHERE PROPOSAL_PERSON_UNIT_ID = PROPOSAL_PERS_UNIT_CRED_SPLITS.PROPOSAL_PERSON_UNIT_ID
    )
   OR NOT EXISTS(
        SELECT INV_CREDIT_TYPE_CODE
        FROM INV_CREDIT_TYPE
        WHERE INV_CREDIT_TYPE_CODE = PROPOSAL_PERS_UNIT_CRED_SPLITS.INV_CREDIT_TYPE_CODE
    );
DELETE FROM PROPOSAL_PERS_UNIT_CRED_SPLITS
WHERE PROPOSAL_PERSON_UNIT_ID IN (
    SELECT PROPOSAL_PERSON_UNIT_ID
    FROM PROPOSAL_PERSON_UNITS
    WHERE NOT EXISTS(
            SELECT PROPOSAL_PERSON_ID
            FROM PROPOSAL_PERSONS
            WHERE PROPOSAL_PERSON_ID = PROPOSAL_PERSON_UNITS.PROPOSAL_PERSON_ID
        )
       OR NOT EXISTS(
            SELECT UNIT_NUMBER
            FROM UNIT
            WHERE UNIT_NUMBER = PROPOSAL_PERSON_UNITS.UNIT_NUMBER
        )
       OR UNIT_NUMBER IS NULL
)
   OR NOT EXISTS(
        SELECT PROPOSAL_PERSON_UNIT_ID
        FROM PROPOSAL_PERSON_UNITS
        WHERE PROPOSAL_PERSON_UNIT_ID = PROPOSAL_PERS_UNIT_CRED_SPLITS.PROPOSAL_PERSON_UNIT_ID
    )
   OR NOT EXISTS(
        SELECT INV_CREDIT_TYPE_CODE
        FROM INV_CREDIT_TYPE
        WHERE INV_CREDIT_TYPE_CODE = PROPOSAL_PERS_UNIT_CRED_SPLITS.INV_CREDIT_TYPE_CODE
    );

-- Broken data cleanup PROPOSAL_PERSON_UNITS
DROP TABLE IF EXISTS PROPOSAL_PERSON_UNITS_v2007_007;
CREATE TABLE PROPOSAL_PERSON_UNITS_v2007_007 AS
SELECT *
FROM PROPOSAL_PERSON_UNITS
WHERE NOT EXISTS(
        SELECT PROPOSAL_PERSON_ID
        FROM PROPOSAL_PERSONS
        WHERE PROPOSAL_PERSON_ID = PROPOSAL_PERSON_UNITS.PROPOSAL_PERSON_ID
    )
   OR NOT EXISTS(
        SELECT UNIT_NUMBER
        FROM UNIT
        WHERE UNIT_NUMBER = PROPOSAL_PERSON_UNITS.UNIT_NUMBER
    )
   OR UNIT_NUMBER IS NULL;
DELETE FROM PROPOSAL_PERSON_UNITS
WHERE NOT EXISTS(
        SELECT PROPOSAL_PERSON_ID
        FROM PROPOSAL_PERSONS
        WHERE PROPOSAL_PERSON_ID = PROPOSAL_PERSON_UNITS.PROPOSAL_PERSON_ID
    )
   OR UNIT_NUMBER IS NULL
   OR NOT EXISTS(
        SELECT UNIT_NUMBER
        FROM UNIT
        WHERE UNIT_NUMBER = PROPOSAL_PERSON_UNITS.UNIT_NUMBER
    );

-- Broken data cleanup EPS_PROP_PERSON_UNITS
DROP TABLE IF EXISTS EPS_PROPOSAL_PERSON_UNITS_v2007_007;
CREATE TABLE EPS_PROPOSAL_PERSON_UNITS_v2007_007 AS
SELECT *
FROM EPS_PROP_PERSON_UNITS
WHERE NOT EXISTS(
        SELECT PROPOSAL_NUMBER
        FROM EPS_PROP_PERSON
        WHERE PROPOSAL_NUMBER = EPS_PROP_PERSON_UNITS.PROPOSAL_NUMBER
          AND PROP_PERSON_NUMBER = EPS_PROP_PERSON_UNITS.PROP_PERSON_NUMBER
    )
   OR NOT EXISTS(
        SELECT UNIT_NUMBER FROM UNIT WHERE UNIT_NUMBER = EPS_PROP_PERSON_UNITS.UNIT_NUMBER
    );
DELETE FROM EPS_PROP_PERSON_UNITS
WHERE NOT EXISTS(
        SELECT PROPOSAL_NUMBER
        FROM EPS_PROP_PERSON
        WHERE PROPOSAL_NUMBER = EPS_PROP_PERSON_UNITS.PROPOSAL_NUMBER
          AND PROP_PERSON_NUMBER = EPS_PROP_PERSON_UNITS.PROP_PERSON_NUMBER
    )
   OR NOT EXISTS(
        SELECT UNIT_NUMBER FROM UNIT WHERE UNIT_NUMBER = EPS_PROP_PERSON_UNITS.UNIT_NUMBER
    );

-- New constraints and foreign keys for performance
ALTER TABLE PROPOSAL_PERS_UNIT_CRED_SPLITS ADD FOREIGN KEY FK_PERSON_UNIT_ID (PROPOSAL_PERSON_UNIT_ID) REFERENCES PROPOSAL_PERSON_UNITS(PROPOSAL_PERSON_UNIT_ID);
ALTER TABLE PROPOSAL_PERS_UNIT_CRED_SPLITS ADD FOREIGN KEY FK_INV_CREDIT_TYPE (INV_CREDIT_TYPE_CODE) REFERENCES INV_CREDIT_TYPE(INV_CREDIT_TYPE_CODE);

ALTER TABLE PROPOSAL_PERSON_UNITS ADD FOREIGN KEY FK_PROPOSAL_PERSON (PROPOSAL_PERSON_ID) REFERENCES PROPOSAL_PERSONS (PROPOSAL_PERSON_ID);
ALTER TABLE PROPOSAL_PERSON_UNITS ADD FOREIGN KEY FK_UNIT (UNIT_NUMBER) REFERENCES UNIT (UNIT_NUMBER);

ALTER TABLE EPS_PROP_PERSON_UNITS ADD FOREIGN KEY FK_EPS_PROP_PERSON (PROPOSAL_NUMBER, PROP_PERSON_NUMBER) REFERENCES EPS_PROP_PERSON (PROPOSAL_NUMBER, PROP_PERSON_NUMBER);
ALTER TABLE EPS_PROP_PERSON_UNITS ADD FOREIGN KEY FK_UNIT (UNIT_NUMBER) REFERENCES UNIT (UNIT_NUMBER);
