-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

alter table subaward_attachment_type MODIFY COLUMN ATTACHMENT_TYPE_CODE varchar(30) NOT NULL;
alter table subaward_attachment_type MODIFY COLUMN UPDATE_TIMESTAMP datetime NOT NULL;

ALTER TABLE subaward_attachment_type
    ADD CONSTRAINT UQ_subaward_attachment_type
        UNIQUE (OBJ_ID);

alter table subaward_attachments MODIFY COLUMN FILE_NAME varchar(150) NOT NULL;
alter table subaward_attachments MODIFY COLUMN DESCRIPTION varchar(200) NOT NULL;
alter table subaward_attachments MODIFY COLUMN UPDATE_TIMESTAMP datetime NOT NULL;

update subaward_attachments set LAST_UPDATE_USER = UPDATE_USER where LAST_UPDATE_USER is null;
update subaward_attachments set LAST_UPDATE_TIMESTAMP = UPDATE_TIMESTAMP where LAST_UPDATE_TIMESTAMP is null;

alter table subaward_attachments MODIFY COLUMN LAST_UPDATE_USER varchar(60) NOT NULL;
alter table subaward_attachments MODIFY COLUMN LAST_UPDATE_TIMESTAMP datetime NOT NULL;

alter table subaward_attachments MODIFY COLUMN FILE_DATA_ID varchar(36) NOT NULL;
alter table subaward_attachments MODIFY COLUMN MIME_TYPE varchar(255) NOT NULL;

ALTER TABLE subaward_attachments
    ADD CONSTRAINT FK_subaward_attachments
        FOREIGN KEY (SUBAWARD_ID) REFERENCES SUBAWARD (SUBAWARD_ID);

ALTER TABLE subaward_attachments
    ADD CONSTRAINT FK3_subaward_attachments
        FOREIGN KEY (ATTACHMENT_TYPE_CODE) REFERENCES subaward_attachment_type (ATTACHMENT_TYPE_CODE);

ALTER TABLE subaward_attachments
    ADD CONSTRAINT UQ_subaward_attachments
        UNIQUE (OBJ_ID);


CREATE TABLE SEQ_SUBAWARD_COMMENT_ID (
    id BIGINT(19) NOT NULL AUTO_INCREMENT,
    PRIMARY KEY (id)
) ENGINE MyISAM;

ALTER TABLE SEQ_SUBAWARD_COMMENT_ID
    AUTO_INCREMENT = 1;

CREATE TABLE SUBAWARD_COMMENT (
                                 SUBAWARD_COMMENT_ID decimal(8,0) NOT NULL,
                                 SUBAWARD_ID decimal(12,0) NOT NULL,
                                 SUBAWARD_CODE varchar(20) NOT NULL,
                                 SEQUENCE_NUMBER decimal(4,0) NOT NULL,
                                 COMMENT_TYPE_CODE varchar(3) NOT NULL,
                                 CHECKLIST_PRINT_FLAG varchar(1) NOT NULL,
                                 COMMENTS longtext,
                                 UPDATE_TIMESTAMP datetime NOT NULL,
                                 UPDATE_USER varchar(60) NOT NULL,
                                 VER_NBR decimal(8,0) NOT NULL DEFAULT '1',
                                 OBJ_ID varchar(36) NOT NULL
);

ALTER TABLE SUBAWARD_COMMENT
    ADD CONSTRAINT PK_SUBAWARD_COMMENT
        PRIMARY KEY (SUBAWARD_COMMENT_ID);

ALTER TABLE SUBAWARD_COMMENT
    ADD CONSTRAINT FK_SUBAWARD_COMMENT
        FOREIGN KEY (SUBAWARD_ID) REFERENCES SUBAWARD (SUBAWARD_ID);

ALTER TABLE SUBAWARD_COMMENT
    ADD CONSTRAINT FK2_SUBAWARD_COMMENT
        FOREIGN KEY (COMMENT_TYPE_CODE) REFERENCES comment_type (COMMENT_TYPE_CODE);

ALTER TABLE SUBAWARD_COMMENT
    ADD CONSTRAINT UQ_SUBAWARD_COMMENT
        UNIQUE (OBJ_ID);

ALTER TABLE COMMENT_TYPE ADD COLUMN SUBAWARD_COMMENT_SCREEN_FLAG VARCHAR(1) NOT NULL DEFAULT 'N';


CREATE TABLE SEQ_SUBAWARD_NOTEPAD_ID (
    id BIGINT(19) NOT NULL AUTO_INCREMENT,
    PRIMARY KEY (id)
) ENGINE MyISAM;

ALTER TABLE SEQ_SUBAWARD_NOTEPAD_ID
    AUTO_INCREMENT = 1;

CREATE TABLE SUBAWARD_NOTEPAD (
                                 SUBAWARD_NOTEPAD_ID decimal(12,0) NOT NULL,
                                 SUBAWARD_ID decimal(12,0) NOT NULL,
                                 SUBAWARD_CODE varchar(20) NOT NULL,
                                 ENTRY_NUMBER decimal(4,0) NOT NULL,
                                 COMMENTS longtext NOT NULL,
                                 RESTRICTED_VIEW char(1) NOT NULL,
                                 UPDATE_TIMESTAMP datetime NOT NULL,
                                 UPDATE_USER varchar(60) NOT NULL,
                                 VER_NBR decimal(8,0) NOT NULL DEFAULT '1',
                                 CREATE_TIMESTAMP datetime NOT NULL,
                                 NOTE_TOPIC varchar(60) NOT NULL,
                                 OBJ_ID varchar(36) NOT NULL,
                                 CREATE_USER varchar(60) NOT NULL
);

ALTER TABLE SUBAWARD_NOTEPAD
    ADD CONSTRAINT PK_SUBAWARD_NOTEPAD
        PRIMARY KEY (SUBAWARD_NOTEPAD_ID);

ALTER TABLE SUBAWARD_NOTEPAD
    ADD CONSTRAINT FK_SUBAWARD_NOTEPAD
        FOREIGN KEY (SUBAWARD_ID) REFERENCES SUBAWARD (SUBAWARD_ID);

ALTER TABLE SUBAWARD_NOTEPAD
    ADD CONSTRAINT UQ_SUBAWARD_NOTEPAD
        UNIQUE (OBJ_ID);

ALTER TABLE SUBAWARD_NOTEPAD
    ADD CONSTRAINT UQ2_SUBAWARD_NOTEPAD
        UNIQUE (SUBAWARD_CODE,ENTRY_NUMBER);

CREATE TABLE subaward_tmpl_attach_type (
                                    ATTACHMENT_TYPE_CODE varchar(30) NOT NULL,
                                    DESCRIPTION varchar(200) NOT NULL,
                                    UPDATE_TIMESTAMP datetime NOT NULL,
                                    UPDATE_USER varchar(60) NOT NULL,
                                    VER_NBR decimal(8,0) NOT NULL DEFAULT '1',
                                    OBJ_ID varchar(36) NOT NULL
);

ALTER TABLE subaward_tmpl_attach_type
    ADD CONSTRAINT PK_subaward_tmpl_attach_type
        PRIMARY KEY (ATTACHMENT_TYPE_CODE);

ALTER TABLE subaward_tmpl_attach_type
    ADD CONSTRAINT UQ_subaward_tmpl_attach_type
        UNIQUE (OBJ_ID);


CREATE TABLE SEQ_SUBAWARD_TMPL_ATT_ID (
    id BIGINT(19) NOT NULL AUTO_INCREMENT,
    PRIMARY KEY (id)
) ENGINE MyISAM;

ALTER TABLE SEQ_SUBAWARD_TMPL_ATT_ID
    AUTO_INCREMENT = 1;

CREATE TABLE SUBAWARD_TEMPLATE_ATTACHMENTS (
                                        ATTACHMENT_ID decimal(12,0) NOT NULL,
                                        SUBAWARD_ID decimal(12,0) NOT NULL,
                                        SUBAWARD_CODE varchar(20) NOT NULL,
                                        SEQUENCE_NUMBER decimal(4,0) NOT NULL,
                                        ATTACHMENT_TYPE_CODE varchar(30) NOT NULL,
                                        DOCUMENT_ID decimal(4,0) NOT NULL,
                                        DOCUMENT_STATUS_CODE char(1),
                                        FILE_NAME varchar(150) NOT NULL,
                                        MIME_TYPE varchar(255) NOT NULL,
                                        FILE_DATA_ID varchar(36) NOT NULL,
                                        DESCRIPTION varchar(200) NOT NULL,
                                        UPDATE_TIMESTAMP datetime NOT NULL,
                                        UPDATE_USER varchar(60) NOT NULL,
                                        VER_NBR decimal(8,0) NOT NULL DEFAULT '1',
                                        OBJ_ID varchar(36) NOT NULL,
                                        LAST_UPDATE_USER varchar(60) NOT NULL,
                                        LAST_UPDATE_TIMESTAMP datetime NOT NULL
);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT PK_SUBAWARD_TEMPLATE_ATTS
        PRIMARY KEY (ATTACHMENT_ID);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT FK_SUBAWARD_TEMPLATE_ATTS
        FOREIGN KEY (SUBAWARD_ID) REFERENCES SUBAWARD (SUBAWARD_ID);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT FK2_SUBAWARD_TEMPLATE_ATTS
        FOREIGN KEY (FILE_DATA_ID) REFERENCES file_data (ID);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT FK3_SUBAWARD_TEMPLATE_ATTS
        FOREIGN KEY (ATTACHMENT_TYPE_CODE) REFERENCES subaward_tmpl_attach_type (ATTACHMENT_TYPE_CODE);

ALTER TABLE SUBAWARD_TEMPLATE_ATTACHMENTS
    ADD CONSTRAINT UQ_SUBAWARD_TEMPLATE_ATTS
        UNIQUE (OBJ_ID);
