-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

update NARRATIVE_TYPE set DESCRIPTION = 'ProprietaryInformation' where DESCRIPTION = 'PropietaryInformation';

-- setting ALLOW_MULTIPLE to 'N' for PotentialTribalImpacts because the form only allows 2
insert into NARRATIVE_TYPE (NARRATIVE_TYPE_CODE,DESCRIPTION,NARRATIVE_TYPE_GROUP,ALLOW_MULTIPLE,SYSTEM_GENERATED,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
values('-9' ,'PotentialTribalImpacts1','P','N','N','admin',NOW(),UUID(),1);

insert into NARRATIVE_TYPE (NARRATIVE_TYPE_CODE,DESCRIPTION,NARRATIVE_TYPE_GROUP,ALLOW_MULTIPLE,SYSTEM_GENERATED,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
values('-10' ,'PotentialTribalImpacts2','P','N','N','admin',NOW(),UUID(),1);

-- narrative forms
INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'NSF_CoverPage_2_3', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'NSF_SingleCopyDocument'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'NSF_CoverPage_2_3', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PersonalData'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'NSF_CoverPage_2_3', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'ProprietaryInformation'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'NSF_CoverPage_2_3', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'Mentoring Plan'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'NSF_CoverPage_2_3', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'Data Management Plan'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'NSF_CoverPage_2_3', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'GOALILetter'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'NSF_CoverPage_2_3', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RAISEEmails'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'NSF_CoverPage_2_3', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PotentialTribalImpacts1'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'NSF_CoverPage_2_3', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PotentialTribalImpacts2'), 'N', 'admin', NOW(), UUID());



-- error messages
INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/NSF_CoverPage_2_3/NSFUnitConsideration/DivisionCode', 'Agency division code must be specified', 'proposal.SponsorProgramInformation', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/NSF_CoverPage_2_3/NSFUnitConsideration/ProgramCode', 'Agency program code must be specified', 'proposal.SponsorProgramInformation', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/NSF_CoverPage_2_3/PIInfo', 'PI needs to be added to proposal', 'keyPersonnel', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/NSF_CoverPage_2_3/OtherInfo', 'Please answer all questions on the NSF Cover Page Questionnaire prior to submission or printing', 'questions', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/NSF_CoverPage_2_3/NSFID', 'NSF ID must be specified and must be a 9-digit number', 'keyPersonnel', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/NSF_CoverPage_2_3', 'You must include all required data and answer all required questions for this form', 'questions', NOW(), 'admin', 1, UUID());

-- questionnaire
INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE (QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_ID, SEQUENCE_NUMBER, NAME, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, IS_FINAL, VER_NBR, OBJ_ID)
VALUES((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), -16, 1, 'NSF Cover Page 2.3 supporting questions', 'These questions support NSF 2.3 Cover Page Grants.gov forms.', NOW(), 'admin', 'Y', 1, UUID());

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=52 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 52)),
        1, 0, 1, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10111 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10111)),
        2, 0, 1, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10112 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10112)),
        5, 0, 1, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10142 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10142)),
        10, 0, 1, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10110 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10110)),
        11, 0, 1, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10143 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10143)),
        12, 0, 1, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=-10144 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10144)),
        13, 0, 1, 'N', null, 'null', 'admin', NOW(), UUID(), 1, null);

-- -10160
INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER)
values ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),-10160,1,'C','Would this result in Potential Life Sciences Dual Use Research of Concern (PAPPG II.E.6 & XI.B.5)','A',4,1,null,null,null,1,1,NOW(), 'admin',1,UUID(),null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM  SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION_ID=-10160),14,0,1,'N',null,null,'admin',NOW(),UUID(),1);

-- -10161
INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER)
values ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),-10161,1,'C','Would this result in Off-Campus or Off-Site Research (PAPPG II.D.1.d (viii) & II.E.9)','A',4,1,null,null,null,1,1,NOW(), 'admin',1,UUID(),null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM  SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION_ID=-10161),15,0,1,'N',null,null,'admin',NOW(),UUID(),1);

-- -10162
INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
Insert into QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER)
values ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),-10162,1,'C','Would this result in Potential Impacts on Tribal Nations','A',4,1,null,null,null,1,1,NOW(), 'admin',1,UUID(),null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM  SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16),(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION_ID=-10162),16,0,1,'N',null,null,'admin',NOW(),UUID(),1);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID, MODULE_ITEM_CODE, MODULE_SUB_ITEM_CODE, QUESTIONNAIRE_REF_ID_FK, QUESTIONNAIRE_SEQUENCE_NUMBER, RULE_ID, QUESTIONNAIRE_LABEL, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, IS_MANDATORY)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), 3, 2, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -16 AND SEQUENCE_NUMBER = 1), 1, null,'NSF 2.3 Cover Page questionnaire', NOW(), 'admin', 1, UUID(), 'N');

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT INTO S2S_FORM_TO_QUESTIONNAIRE (S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES ((SELECT MAX(ID) FROM SEQ_QUESTIONNAIRE_REF_ID), 'http://apply.grants.gov/forms/NSF_CoverPage_2_3-V2.3', 'NSF_CoverPage_2_3', '-16', NOW(), 'admin', UUID(), 1);


