/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.toml.TomlStreamReadException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.ListDeserializer;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.ObjectMapperFactory;
import org.flywaydb.core.internal.util.Pair;

public class TomlUtils {
    @Generated
    private static final Log LOG = LogFactory.getLog(TomlUtils.class);
    private static final String MSG = "Using both new Environment variable %1$s and old Environment variable %2$s. Please remove %2$s.";

    public static ConfigurationModel loadConfigurationFromEnvironment() {
        Map<String, String> environmentVariables = System.getenv().entrySet().stream().filter(e -> !((String)e.getKey()).equals("FLYWAY_CONFIG_FILES")).filter(e -> ((String)e.getKey()).startsWith("flyway_") || ((String)e.getKey()).startsWith("environments_") || ((String)e.getKey()).startsWith("FLYWAY_") && ConfigUtils.convertKey((String)e.getKey()) != null).collect(Collectors.toMap(k -> {
            String prop;
            String string = prop = ((String)k.getKey()).startsWith("FLYWAY_") || ((String)k.getKey()).toUpperCase(Locale.ENGLISH).startsWith("FLYWAY_JDBC_PROPERTIES_") ? ConfigUtils.convertKey(((String)k.getKey()).toUpperCase(Locale.ENGLISH)) : ((String)k.getKey()).replace("_", ".");
            if (prop != null && prop.startsWith("flyway.")) {
                String p = prop.substring("flyway.".length());
                if (Arrays.stream(EnvironmentModel.class.getDeclaredFields()).anyMatch(x -> x.getName().equals(p.split("\\.")[0]))) {
                    return "environments.tempConfigEnvironment." + p;
                }
            }
            return prop;
        }, v -> Pair.of((String)v.getKey(), (String)v.getValue()), (e1, e2) -> {
            if (((String)e1.getLeft()).startsWith("FLYWAY_")) {
                LOG.warn(String.format(MSG, e2.getLeft(), e1.getLeft()));
                return e2;
            }
            LOG.warn(String.format(MSG, e1.getLeft(), e2.getLeft()));
            return e1;
        })).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> (String)((Pair)v.getValue()).getRight()));
        return TomlUtils.toConfiguration(TomlUtils.unflattenMap(environmentVariables));
    }

    public static ConfigurationModel loadConfigurationFromCommandlineArgs(Map<String, String> commandLineArguments) {
        return TomlUtils.toConfiguration(TomlUtils.unflattenMap(commandLineArguments));
    }

    private static ConfigurationModel toConfiguration(Map<String, Object> properties) {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, String.class);
        simpleModule.addDeserializer(type.getRawClass(), new ListDeserializer());
        objectMapper.registerModule(simpleModule);
        try {
            return objectMapper.convertValue(properties, ConfigurationModel.class);
        }
        catch (IllegalArgumentException e) {
            throw new FlywayException("Unable to parse command line params.");
        }
    }

    public static Map<String, Object> unflattenMap(Map<String, String> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] parts = entry.getKey().split("\\.");
            Map<String, Object> currentMap = result;
            for (int i = 0; i < parts.length; ++i) {
                if (i != parts.length - 1) {
                    currentMap = (Map)currentMap.computeIfAbsent(parts[i], x -> new HashMap());
                    continue;
                }
                currentMap.put(parts[i], entry.getValue());
            }
        }
        return result;
    }

    public static ConfigurationModel loadConfigurationFiles(List<File> files) {
        ConfigurationModel defaultConfig = ConfigurationModel.defaults();
        ConfigUtils.dumpConfigurationModel(defaultConfig, "Default configuration:");
        return files.stream().map(TomlUtils::loadConfigurationFile).reduce(defaultConfig, ConfigurationModel::merge);
    }

    static ConfigurationModel loadConfigurationFile(File configFile) {
        try {
            String configText = FileUtils.readFileAsString(configFile);
            ConfigurationModel tomlConfig = (ConfigurationModel)ObjectMapperFactory.getObjectMapper(configFile.toString()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readerFor(ConfigurationModel.class).readValue(configText);
            ConfigUtils.dumpConfigurationModel(tomlConfig, "Loading config file: " + configFile.getAbsolutePath());
            return tomlConfig;
        }
        catch (TomlStreamReadException tomlread) {
            String line = FileUtils.readLine(configFile, tomlread.getLocation().getLineNr());
            StringBuilder highlight = new StringBuilder(line);
            highlight.insert(tomlread.getLocation().getColumnNr() - 1, "^");
            String message = "Error parsing config file at [line " + tomlread.getLocation().getLineNr() + ", column " + tomlread.getLocation().getColumnNr() + "]" + TomlUtils.getErrorCause(tomlread.getOriginalMessage()) + ", syntax error shown by ^: " + String.valueOf(highlight) + "\n\tin " + configFile.getAbsolutePath();
            throw new FlywayException(message);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load config file: " + configFile.getAbsolutePath(), e);
        }
    }

    private static String getErrorCause(String errorMessage) {
        StringBuilder message = new StringBuilder().append(" caused by: ");
        return switch (errorMessage) {
            case "Duplicate key", "Unknown token" -> message.append(errorMessage).toString();
            case "Table redefined" -> message.append("Duplicate table").toString();
            default -> "";
        };
    }
}

