-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

CREATE TABLE GRANT_FORWARD_RECORD
(
    ID VARCHAR(25) NOT NULL,
    PROPOSAL_NUMBER VARCHAR(12) NULL,
    GRANT_ID DECIMAL(25) NOT NULL,
    URL VARCHAR(2048),
    MODIFIED_DATE VARCHAR(25),
    AMOUNT_INFO LONGTEXT,
    SITE_GRANT_TYPE VARCHAR(100),
    APPLICATION_URL VARCHAR(2048),
    TITLE VARCHAR(500),
    EXT_GRANT_ID VARCHAR(100),
    ALL_TITLES VARCHAR(2000),
    SUBMISSION_INFO LONGTEXT,
    ALL_GRANT_SOURCE_URLS VARCHAR(10000),
    STATUS VARCHAR(25),
    DESCRIPTION LONGTEXT,
    ELIGIBILITY LONGTEXT,
    CATEGORIES_DISPLAY LONGTEXT,
    LIMITED_GRANT_INFO LONGTEXT,
    REPLACES VARCHAR(250),
    USER_CATEGORIES LONGTEXT,
    SUBMIT_DATE VARCHAR(25),
    IS_LIMITED DECIMAL(1),
    SITE_CATEGORIES LONGTEXT,
    COST_SHARING LONGTEXT,
    GRANT_SOURCE_URL VARCHAR(2048),
    ALL_TYPES VARCHAR(250),
    ALL_APPLICANT_TYPES VARCHAR(250),
    UPDATE_TIMESTAMP DATETIME NOT NULL,
    UPDATE_USER VARCHAR(60) NOT NULL,
    OBJ_ID VARCHAR(36) NOT NULL,
    VER_NBR DECIMAL(8) default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_RECORD
    ADD CONSTRAINT GRANT_FORWARD_RECORDP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_RECORD
    ADD CONSTRAINT GRANT_FORWARD_RECORDUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_RECORD
    ADD CONSTRAINT GRANT_FORWARD_RECORDUQ2
        UNIQUE(PROPOSAL_NUMBER);

ALTER TABLE GRANT_FORWARD_RECORD
    ADD CONSTRAINT GRANT_FORWARD_RECORDFK1
        FOREIGN KEY (PROPOSAL_NUMBER)
            REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

CREATE TABLE SEQ_GF_RECORD_ID (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE SEQ_GF_RECORD_ID AUTO_INCREMENT = 1;

CREATE TABLE GRANT_FORWARD_AMOUNT
(
    ID VARCHAR(25) NOT NULL,
    RECORD_ID VARCHAR(25) NOT NULL,
    CONFIRMED VARCHAR(1) NOT NULL,
    CURRENCY VARCHAR(10) NOT NULL,
    TYPE VARCHAR(25) NOT NULL,
    AMOUNT DECIMAL(19, 2) NOT NULL,
    UPDATE_TIMESTAMP DATETIME NOT NULL,
    UPDATE_USER VARCHAR(60) NOT NULL,
    OBJ_ID VARCHAR(36) NOT NULL,
    VER_NBR DECIMAL(8) default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_AMOUNT
    ADD CONSTRAINT GRANT_FORWARD_AMOUNTP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_AMOUNT
    ADD CONSTRAINT GRANT_FORWARD_AMOUNTUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_AMOUNT
    ADD CONSTRAINT GRANT_FORWARD_AMOUNTFK1
        FOREIGN KEY (RECORD_ID)
            REFERENCES GRANT_FORWARD_RECORD (ID);

CREATE TABLE SEQ_GF_AMOUNT_ID (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE SEQ_GF_AMOUNT_ID AUTO_INCREMENT = 1;

CREATE TABLE GRANT_FORWARD_DEADLINE
(
    ID VARCHAR(25) NOT NULL,
    RECORD_ID VARCHAR(25) NOT NULL,
    TYPE VARCHAR(25) NOT NULL,
    DEADLINE VARCHAR(25) NOT NULL,
    UPDATE_TIMESTAMP DATETIME NOT NULL,
    UPDATE_USER VARCHAR(60) NOT NULL,
    OBJ_ID VARCHAR(36) NOT NULL,
    VER_NBR DECIMAL(8) default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_DEADLINE
    ADD CONSTRAINT GRANT_FORWARD_DEADLINEP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_DEADLINE
    ADD CONSTRAINT GRANT_FORWARD_DEADLINEUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_DEADLINE
    ADD CONSTRAINT GRANT_FORWARD_DEADLINEFK1
        FOREIGN KEY (RECORD_ID)
            REFERENCES GRANT_FORWARD_RECORD (ID);

CREATE TABLE SEQ_GF_DEADLINE_ID (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE SEQ_GF_DEADLINE_ID AUTO_INCREMENT = 1;

CREATE TABLE GRANT_FORWARD_LOCATION
(
    ID VARCHAR(25) NOT NULL,
    RECORD_ID VARCHAR(25) NOT NULL,
    IS_EXCLUDE DECIMAL(1),
    IS_PRIMARY DECIMAL(1),
    TYPE VARCHAR(25) NOT NULL,
    LOCATION VARCHAR(150) NOT NULL,
    UPDATE_TIMESTAMP DATETIME NOT NULL,
    UPDATE_USER VARCHAR(60) NOT NULL,
    OBJ_ID VARCHAR(36) NOT NULL,
    VER_NBR DECIMAL(8) default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_LOCATION
    ADD CONSTRAINT GRANT_FORWARD_LOCATIONP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_LOCATION
    ADD CONSTRAINT GRANT_FORWARD_LOCATIONUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_LOCATION
    ADD CONSTRAINT GRANT_FORWARD_LOCATIONFK1
        FOREIGN KEY (RECORD_ID)
            REFERENCES GRANT_FORWARD_RECORD (ID);

CREATE TABLE SEQ_GF_LOCATION_ID (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE SEQ_GF_LOCATION_ID AUTO_INCREMENT = 1;

CREATE TABLE GRANT_FORWARD_SPONSOR
(
    ID VARCHAR(25) NOT NULL,
    RECORD_ID VARCHAR(25) NOT NULL,
    SPONSOR_ID DECIMAL(25) NOT NULL,
    SPONSOR VARCHAR(200) NOT NULL,
    UPDATE_TIMESTAMP DATETIME NOT NULL,
    UPDATE_USER VARCHAR(60) NOT NULL,
    OBJ_ID VARCHAR(36) NOT NULL,
    VER_NBR DECIMAL(8) default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_SPONSOR
    ADD CONSTRAINT GRANT_FORWARD_SPONSORP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_SPONSOR
    ADD CONSTRAINT GRANT_FORWARD_SPONSORUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_SPONSOR
    ADD CONSTRAINT GRANT_FORWARD_SPONSORFK1
        FOREIGN KEY (RECORD_ID)
            REFERENCES GRANT_FORWARD_RECORD (ID);

CREATE TABLE SEQ_GF_SPONSOR_ID (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE SEQ_GF_SPONSOR_ID AUTO_INCREMENT = 1;
