-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -
-- Creating new GEPA questions

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);

INSERT INTO QUESTION (QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE,
                      QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH,
                      UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_QUESTIONNAIRE_REF_ID), -10163, 1, 'C',
        'Describe how your entity’s existing mission, policies, or commitments ensure equitable access to, and equitable participation in, the proposed project or activity.',
        'A', 1, 5, NULL, NULL, NULL, 1, 4000, NOW(), 'admin', 1, UUID(), NULL);


INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);

INSERT INTO QUESTION (QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE,
                      QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH,
                      UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_QUESTIONNAIRE_REF_ID), -10164, 1, 'C',
        'Based on your proposed project or activity, what barriers may impede equitable access and participation of students, educators, or other beneficiaries?',
        'A', 1, 5, NULL, NULL, NULL, 1, 4000, NOW(), 'admin', 1, UUID(), NULL);


INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);

INSERT INTO QUESTION (QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE,
                      QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH,
                      UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_QUESTIONNAIRE_REF_ID), -10165, 1, 'C',
        'Based on the barriers identified, what steps will you take to address such barriers to equitable access and participation in the proposed project or activity?',
        'A', 1, 5, NULL, NULL, NULL, 1, 4000, NOW(), 'admin', 1, UUID(), NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);

INSERT INTO QUESTION (QUESTION_REF_ID, QUESTION_ID, SEQUENCE_NUMBER, SEQUENCE_STATUS, QUESTION, STATUS, GROUP_TYPE_CODE,
                      QUESTION_TYPE_ID, LOOKUP_CLASS, LOOKUP_RETURN, DISPLAYED_ANSWERS, MAX_ANSWERS, ANSWER_MAX_LENGTH,
                      UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, DOCUMENT_NUMBER)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_QUESTIONNAIRE_REF_ID), -10166, 1, 'C',
        'What is your timeline, including targeted milestones, for addressing these identified barriers?',
        'A', 1, 5, NULL, NULL, NULL, 1, 4000, NOW(), 'admin', 1, UUID(), NULL);


-- Create new questionnaire for ED General Education Provisions Act (GEPA) 427 Form

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);
INSERT INTO QUESTIONNAIRE (QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_ID, SEQUENCE_NUMBER, NAME, DESCRIPTION, UPDATE_TIMESTAMP,
                           UPDATE_USER, IS_FINAL, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), -17, 1, 'ED General Education Provisions Act (GEPA) 427',
        'The responses are used to populate the ED General Education Provisions Act (GEPA) 427 Form for submission via Grants.gov.',
        NOW(), 'admin', 'Y', 1, UUID());

-- Create Questionnaire Questions

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK,
                                     QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG,
                                     CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR,
                                     RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),
        (SELECT QUESTIONNAIRE_REF_ID
         FROM QUESTIONNAIRE
         WHERE QUESTIONNAIRE_ID = -17
           and SEQUENCE_NUMBER = (select max(sequence_number) from QUESTIONNAIRE where questionnaire_id = -17)),
        (SELECT QUESTION_REF_ID
         FROM QUESTION
         WHERE QUESTION_ID = -10163
           AND SEQUENCE_NUMBER = (select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10163)),
        1, 0, 1, 'N', null, null, 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK,
                                     QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG,
                                     CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR,
                                     RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),
        (SELECT QUESTIONNAIRE_REF_ID
         FROM QUESTIONNAIRE
         WHERE QUESTIONNAIRE_ID = -17
           and SEQUENCE_NUMBER = (select max(sequence_number) from QUESTIONNAIRE where questionnaire_id = -17)),
        (SELECT QUESTION_REF_ID
         FROM QUESTION
         WHERE QUESTION_ID = -10164
           AND SEQUENCE_NUMBER = (select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10164)),
        2, 0, 1, 'N', null, null, 'admin', NOW(), UUID(), 1, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK,
                                     QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG,
                                     CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR,
                                     RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),
        (SELECT QUESTIONNAIRE_REF_ID
         FROM QUESTIONNAIRE
         WHERE QUESTIONNAIRE_ID = -17
           and SEQUENCE_NUMBER = (select max(sequence_number) from QUESTIONNAIRE where questionnaire_id = -17)),
        (SELECT QUESTION_REF_ID
         FROM QUESTION
         WHERE QUESTION_ID = -10165
           AND SEQUENCE_NUMBER = (select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10165)),
        3, 0, 1, 'N', null, null, 'admin', NOW(), UUID(), 1, null);


INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK,
                                     QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG,
                                     CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR,
                                     RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),
        (SELECT QUESTIONNAIRE_REF_ID
         FROM QUESTIONNAIRE
         WHERE QUESTIONNAIRE_ID = -17
           and SEQUENCE_NUMBER = (select max(sequence_number) from QUESTIONNAIRE where questionnaire_id = -17)),
        (SELECT QUESTION_REF_ID
         FROM QUESTION
         WHERE QUESTION_ID = -10166
           AND SEQUENCE_NUMBER = (select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = -10166)),
        4, 0, 1, 'N', null, null, 'admin', NOW(), UUID(), 1, null);


-- Questionnaire Usage

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);
INSERT INTO QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID, MODULE_ITEM_CODE, MODULE_SUB_ITEM_CODE,
                                 QUESTIONNAIRE_REF_ID_FK, QUESTIONNAIRE_SEQUENCE_NUMBER, RULE_ID, QUESTIONNAIRE_LABEL,
                                 UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, IS_MANDATORY)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), 3, 2,
        (SELECT QUESTIONNAIRE_REF_ID
         FROM QUESTIONNAIRE
         WHERE QUESTIONNAIRE_ID = -17
           AND SEQUENCE_NUMBER = (select max(sequence_number) from QUESTIONNAIRE where questionnaire_id = -17)), 1,
        null,
        'ED General Education Provisions Act (GEPA) 427', NOW(), 'admin', 1, UUID(), 'N');

-- S2S Form to Questionnaire

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID
VALUES (NULL);
INSERT INTO s2s_form_to_questionnaire (S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID,
                                       UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES ((SELECT max(id)
         FROM SEQ_QUESTIONNAIRE_REF_ID), 'http://apply.grants.gov/forms/ED_GEPA427_2_0-V2.0',
        'ED_GEPA427_2_0-V2.0', -17,
        NOW(), 'admin', UUID(), '1');

-- Increase character limit for questionnaire answers
ALTER TABLE QUESTIONNAIRE_ANSWER MODIFY ANSWER VARCHAR(4000);
