-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

INSERT INTO KRIM_PERM_T (PERM_ID, OBJ_ID, NMSPC_CD, NM, DESC_TXT, PERM_TMPL_ID)
    VALUES ('RESBOOT-1042', UUID(), 'KC-COMMON', 'Read CustomAttribute', 'Read CustomAttribute in the KC system',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Read Class')
    )
;

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, OBJ_ID, ATTR_VAL, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID)
    VALUES ('RESBOOT-1039', UUID(), 'org.kuali.coeus.common.framework.custom.attr.CustomAttribute',
        (SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-COMMON' AND NM = 'Read CustomAttribute'),
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'Class Name'),
        (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KC-SYS' AND NM = 'className')
    )
;

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, OBJ_ID, ROLE_ID, PERM_ID)
    VALUES ('RESBOOT-1061', UUID(),
        (SELECT ROLE_ID FROM KRIM_ROLE_T WHERE NMSPC_CD = 'KUALI' AND ROLE_NM = 'User'),
        (SELECT PERM_ID FROM KRIM_PERM_T WHERE NMSPC_CD = 'KC-COMMON' AND NM = 'Read CustomAttribute')
    )
;

