-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

with priority_details as (
    -- Determine the date of the last action taken for each priority (per document) restricting to priorities which have been completed
    select r.doc_hdr_id,
           r.prio_nbr,
           max(actn_dt) as last_action_date,
           count(1) as priority_total,
           sum(if(t.actn_tkn_id is not null, 1, 0)) as taken_total
    from krew_actn_rqst_t r
             left outer join krew_actn_tkn_t t on t.actn_tkn_id = r.actn_tkn_id
    where r.actn_rqst_cd = 'A'
    group by r.doc_hdr_id, r.prio_nbr
    having priority_total = taken_total
), last_action_detail as (
    -- For each document, take the greatest date of the last action taken per completed priority => that is when the last priority was completed and the next activated
    select pd.doc_hdr_id, max(pd.last_action_date) as last_action_date
    from priority_details pd
    group by pd.doc_hdr_id
), ad_hoc_count as (
    -- The above does not work if there are ad hoc requests in the mix, so count the number of ad hocs
    select r.doc_hdr_id, sum(if(r.actn_rqst_cd = 'A' and r.prio_nbr = 0, 1, 0)) as ad_hoc_total
    from krew_actn_rqst_t r
    group by r.doc_hdr_id
), activated_date as (
    -- These results determine the correct activated date for each active request (excluding ones with ad hoc)
    select r.actn_rqst_id, lad.last_action_date
    from krew_actn_rqst_t r
             inner join last_action_detail lad on lad.doc_hdr_id = r.doc_hdr_id
             inner join ad_hoc_count ahc on ahc.doc_hdr_id = r.doc_hdr_id
    where ahc.ad_hoc_total = 0 and r.actn_rqst_cd = 'A' and r.stat_cd = 'A'
) update krew_actn_rqst_t r
    set r.crte_dt = (select ad.last_action_date from activated_date ad where r.actn_rqst_id = ad.actn_rqst_id)
    where r.actn_rqst_id in (select ad.actn_rqst_id from activated_date ad)
;

