-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -
CREATE TABLE EXCON_PROJECT_DOCUMENT  (
  DOCUMENT_NUMBER     VARCHAR(40) NOT NULL,
  VER_NBR             DECIMAL(8) default 1 NOT NULL,
  OBJ_ID              VARCHAR(36) NOT NULL,
  UPDATE_TIMESTAMP    DATETIME NOT NULL,
  UPDATE_USER         VARCHAR(60) NOT NULL);
ALTER TABLE EXCON_PROJECT_DOCUMENT
ADD CONSTRAINT EXCON_PROJECT_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);

ALTER TABLE EXCON_PROJECT_DOCUMENT
    ADD CONSTRAINT EXCON_PROJECT_DOCUMENTUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_TYPE
(
    PROJECT_TYPE_CODE     VARCHAR(3) NOT NULL,
    DESCRIPTION           VARCHAR(300) NOT NULL,
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36) NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_TYPEP1
        PRIMARY KEY (PROJECT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_STATUS_TYPE
(
    STATUS_TYPE_CODE      VARCHAR(3) NOT NULL,
    DESCRIPTION           VARCHAR(300) NOT NULL,
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36) NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_STATUS_TYPE
    ADD CONSTRAINT EXCON_PROJECT_STATUS_TYPEP1
        PRIMARY KEY (STATUS_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_STATUS_TYPE
    ADD CONSTRAINT EXCON_PROJECT_STATUS_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT
(
  PROJECT_ID            DECIMAL(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR(12) NOT NULL,
  SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
  DOCUMENT_NUMBER       VARCHAR(40) NOT NULL,
  PROJECT_TITLE         VARCHAR(100) NOT NULL,
  PROJECT_TYPE_CODE     VARCHAR(3) NOT NULL,
  LEAD_UNIT_NUMBER      VARCHAR(8),
  SPONSOR_CODE          VARCHAR(6),
  FUNDMNTL_RESEARCH_IND VARCHAR(1),
  PROJECT_START_DATE    DATETIME,
  PROJECT_END_DATE      DATETIME,
  PROJECT_STATUS_CODE   VARCHAR(3) NOT NULL,
  PROJECT_SEQUENCE_STATUS VARCHAR(10),
  agreement_role        char(1),
  responsible_party     VARCHAR(40),
  international_ind     VARCHAR(1),
  classified_ind        VARCHAR(1),
  restriction_ind       VARCHAR(1),
  UPDATE_TIMESTAMP      DATETIME NOT NULL,
  UPDATE_USER           VARCHAR(60) NOT NULL,
  OBJ_ID                VARCHAR(36) NOT NULL,
  VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTP1
PRIMARY KEY (PROJECT_ID);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTUQ2
        UNIQUE(PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTFK1
        FOREIGN KEY (PROJECT_TYPE_CODE)
            REFERENCES EXCON_PROJECT_TYPE (PROJECT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTFK2
        FOREIGN KEY (PROJECT_STATUS_CODE)
            REFERENCES EXCON_PROJECT_STATUS_TYPE (STATUS_TYPE_CODE);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTFK3
        FOREIGN KEY (SPONSOR_CODE)
            REFERENCES SPONSOR (SPONSOR_CODE);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTFK4
        FOREIGN KEY (LEAD_UNIT_NUMBER)
            REFERENCES UNIT (UNIT_NUMBER);

CREATE TABLE EXCON_PROJECT_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_S AUTO_INCREMENT = 1;
CREATE TABLE EXCON_PROJECT_NUMBER_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_NUMBER_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_PERSON_ROLE_TYPE
(
    PROJECT_PERSON_ROLE_TYPE_CODE VARCHAR(3) NOT NULL,
    DESCRIPTION                   VARCHAR(300) NOT NULL,
    UPDATE_TIMESTAMP              DATETIME NOT NULL,
    UPDATE_USER                   VARCHAR(60) NOT NULL,
    OBJ_ID                        VARCHAR(36) NOT NULL,
    VER_NBR                       DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_PERSON_ROLE_TYPE
    ADD CONSTRAINT EXCON_PROJECT_PERSON_RTP1
        PRIMARY KEY (PROJECT_PERSON_ROLE_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_PERSON_ROLE_TYPE
    ADD CONSTRAINT EXCON_PROJECT_PERSON_RTUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_PERSONS
(
  PROJECT_PERSON_ID     DECIMAL(22) NOT NULL,
  PERSON_ID             VARCHAR(40) NOT NULL,
  ROLODEX_ID            DECIMAL(6),
  FULL_NAME             VARCHAR(90) NOT NULL,
  PERSON_ROLE_TYPE_CODE VARCHAR(12) NOT NULL,
  PROJECT_ID            DECIMAL(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR(12) NOT NULL,
  SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
  UPDATE_TIMESTAMP      DATETIME NOT NULL,
  UPDATE_USER           VARCHAR(60) NOT NULL,
  OBJ_ID                VARCHAR(36) NOT NULL,
  VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_PERSONS
  ADD CONSTRAINT EXCON_PROJECT_PERSONSP1
  PRIMARY KEY (PROJECT_PERSON_ID);

ALTER TABLE EXCON_PROJECT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_PERSONSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_PERSONSIDX1
    ON EXCON_PROJECT_PERSONS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_PERSONSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_PERSONSFK2
        FOREIGN KEY (PERSON_ROLE_TYPE_CODE)
            REFERENCES EXCON_PROJECT_PERSON_ROLE_TYPE (PROJECT_PERSON_ROLE_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_PERSONSFK3
        FOREIGN KEY (ROLODEX_ID)
            REFERENCES ROLODEX (ROLODEX_ID);

CREATE TABLE EXCON_PROJECT_PERSON_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_PERSON_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_CNTNT_TYPE_CODE
(
    CONTENT_TYPE_CODE     VARCHAR(5),
    DESCRIPTION           VARCHAR(200),
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36) NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_CNTNT_TYPE_CODE
    ADD CONSTRAINT EXCON_PROJECT_CNTNT_TCP1
        PRIMARY KEY (CONTENT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_CNTNT_TYPE_CODE
    ADD CONSTRAINT EXCON_PROJECT_CNTNT_TCUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_EMAIL_CONTENT
(
    CONTENT_CODE          VARCHAR(20) NOT NULL,
    DESCRIPTION           VARCHAR(200),
    CONTENT_TYPE_CODE     VARCHAR(5),
    FILE_NAME             VARCHAR(150),
    CONTENT_TYPE          VARCHAR(255),
    CONTENT               BLOB,
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36) NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_EMAIL_CONTENT
    ADD CONSTRAINT EXCON_PROJECT_EMAIL_CONTENTP1
        PRIMARY KEY (CONTENT_CODE);

ALTER TABLE EXCON_PROJECT_EMAIL_CONTENT
    ADD CONSTRAINT EXCON_PROJECT_EMAIL_CONTENTUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_PROJECT_EMAIL_CONTENT
    ADD CONSTRAINT EXCON_PROJECT_EMAIL_CONTENTFK1
        FOREIGN KEY (CONTENT_TYPE_CODE)
            REFERENCES EXCON_PROJECT_CNTNT_TYPE_CODE (CONTENT_TYPE_CODE);

CREATE TABLE EXCON_PROJECT_TRAVELER_COM
(
    PROJECT_TRAVELER_COM_ID           DECIMAL(22) NOT NULL,
    PROJECT_PERSON_ID                 DECIMAL(22) NOT NULL,
    COMMUNICATION_DATE                DATETIME NOT NULL,
    EMAIL_BODY_CONTENT_CODE           VARCHAR(20),
    EMAIL_ATTACHMENT_CONTENT_CODE     VARCHAR(20),
    AGENDA_CONTENT_CODE               VARCHAR(20),
    TRAVEL_COMMENT                    LONGTEXT,
    UPDATE_TIMESTAMP                  DATETIME NOT NULL,
    UPDATE_USER                       VARCHAR(60) NOT NULL,
    OBJ_ID                            VARCHAR(36) NOT NULL,
    VER_NBR                           DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMSP1
        PRIMARY KEY (PROJECT_TRAVELER_COM_ID);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMFK1
        FOREIGN KEY (PROJECT_PERSON_ID)
            REFERENCES EXCON_PROJECT_PERSONS (PROJECT_PERSON_ID);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMFK2
        FOREIGN KEY (EMAIL_BODY_CONTENT_CODE)
            REFERENCES EXCON_PROJECT_EMAIL_CONTENT (CONTENT_CODE);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMFK3
        FOREIGN KEY (EMAIL_ATTACHMENT_CONTENT_CODE)
            REFERENCES EXCON_PROJECT_EMAIL_CONTENT (CONTENT_CODE);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMFK4
        FOREIGN KEY (AGENDA_CONTENT_CODE)
            REFERENCES EXCON_PROJECT_EMAIL_CONTENT (CONTENT_CODE);

CREATE TABLE EXCON_PROJECT_TRAVELER_COM_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_TRAVELER_COM_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_EVENT_TYPE
(
    PROJECT_EVENT_TYPE_CODE VARCHAR(3) NOT NULL,
    DESCRIPTION             VARCHAR(300) NOT NULL,
    UPDATE_TIMESTAMP        DATETIME NOT NULL,
    UPDATE_USER             VARCHAR(60) NOT NULL,
    OBJ_ID                  VARCHAR(36) NOT NULL,
    VER_NBR                 DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_EVENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_EVENT_TYPEP1
        PRIMARY KEY (PROJECT_EVENT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_EVENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_EVENT_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_EVENTS
(
  PROJECT_EVENT_ID        DECIMAL(22) NOT NULL,
  PROJECT_ID              DECIMAL(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR(12) NOT NULL,
  SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
  PROJECT_EVENT_TYPE_CODE VARCHAR(3) NOT NULL,
  EVENT_DATE              DATETIME NOT NULL,
  EVENT_COMMENT           LONGTEXT,
  UPDATE_TIMESTAMP        DATETIME NOT NULL,
  UPDATE_USER             VARCHAR(60) NOT NULL,
  OBJ_ID                  VARCHAR(36) NOT NULL,
  VER_NBR                 DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_EVENTS
  ADD CONSTRAINT EXCON_PROJECT_EVENTSP1
  PRIMARY KEY (PROJECT_EVENT_ID);

ALTER TABLE EXCON_PROJECT_EVENTS
    ADD CONSTRAINT EXCON_PROJECT_EVENTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_EVENTSIDX1
    ON EXCON_PROJECT_EVENTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_EVENTS
    ADD CONSTRAINT EXCON_PROJECT_EVENTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_EVENTS
    ADD CONSTRAINT EXCON_PROJECT_EVENTSFK2
        FOREIGN KEY (PROJECT_EVENT_TYPE_CODE)
            REFERENCES EXCON_PROJECT_EVENT_TYPE (PROJECT_EVENT_TYPE_CODE);

CREATE TABLE EXCON_PROJECT_EVENT_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_EVENT_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_COMMENT_TYPE
(
    PROJECT_COMMENT_TYPE_CODE VARCHAR(3) NOT NULL,
    DESCRIPTION               VARCHAR(300) NOT NULL,
    UPDATE_TIMESTAMP          DATETIME NOT NULL,
    UPDATE_USER               VARCHAR(60) NOT NULL,
    OBJ_ID                    VARCHAR(36) NOT NULL,
    VER_NBR                   DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_COMMENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_COMMENT_TYPEP1
        PRIMARY KEY (PROJECT_COMMENT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_COMMENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_COMMENT_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_COMMENTS
(
  PROJECT_COMMENT_ID    DECIMAL(22) NOT NULL,
  PROJECT_ID            DECIMAL(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR(12) NOT NULL,
  SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
  COMMENT_TYPE_CODE     VARCHAR(3) NOT NULL,
  COMMENTS              LONGTEXT,
  COMMENT_AUTHOR        VARCHAR(60),
  COMMENT_DATE          DATETIME,
  UPDATE_TIMESTAMP      DATETIME NOT NULL,
  UPDATE_USER           VARCHAR(60) NOT NULL,
  OBJ_ID                VARCHAR(36) NOT NULL,
  VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_COMMENTS
  ADD CONSTRAINT EXCON_PROJECT_COMMENTSP1
  PRIMARY KEY (PROJECT_COMMENT_ID);

ALTER TABLE EXCON_PROJECT_COMMENTS
    ADD CONSTRAINT EXCON_PROJECT_COMMENTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_COMMENTSIDX1
    ON EXCON_PROJECT_COMMENTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_COMMENTS
    ADD CONSTRAINT EXCON_PROJECT_COMMENTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_COMMENTS
    ADD CONSTRAINT EXCON_PROJECT_COMMENTSFK2
        FOREIGN KEY (COMMENT_TYPE_CODE)
            REFERENCES EXCON_PROJECT_COMMENT_TYPE (PROJECT_COMMENT_TYPE_CODE);

CREATE TABLE EXCON_PROJECT_COMMENT_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_COMMENT_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_UNIT_PERSONS
(
  PROJECT_UNIT_PERSON_ID        DECIMAL(22) NOT NULL,
  PERSON_ID                     VARCHAR(40) NOT NULL,
  FULL_NAME                     VARCHAR(90) NOT NULL,
  UNIT_ADMINISTRATOR_TYPE_CODE   varchar(5) NOT NULL,
  UNIT_ADMINISTRATOR_UNIT_NUMBER  VARCHAR(8) NOT NULL,
  PROJECT_ID                    DECIMAL(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR(12) NOT NULL,
  SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
  UPDATE_TIMESTAMP              DATETIME NOT NULL,
  UPDATE_USER                   VARCHAR(60) NOT NULL,
  OBJ_ID                        VARCHAR(36) NOT NULL,
  VER_NBR                       DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_UNIT_PERSONS
  ADD CONSTRAINT EXCON_PROJECT_UNIT_PERSONSP1
  PRIMARY KEY (PROJECT_UNIT_PERSON_ID);

ALTER TABLE EXCON_PROJECT_UNIT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_UNIT_PERSONSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_UNIT_PERSONSIDX1
    ON EXCON_PROJECT_UNIT_PERSONS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_UNIT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_UNIT_PERSONSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE TABLE EXCON_PROJECT_UNIT_PERSON_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_UNIT_PERSON_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_CUSTOM_DATA
(
  EXCON_PROJECT_CUSTOM_DATA_ID  DECIMAL(8),
  PROJECT_ID            DECIMAL(22),
  PROJECT_NUMBER        VARCHAR(12) NOT NULL,
  SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
  CUSTOM_ATTRIBUTE_ID   DECIMAL(12),
  VALUE                 VARCHAR(2000),
  UPDATE_TIMESTAMP      DATETIME,
  UPDATE_USER           VARCHAR(60),
  VER_NBR               DECIMAL(8) default 1,
  OBJ_ID                VARCHAR(36) NOT NULL
);
ALTER TABLE EXCON_PROJECT_CUSTOM_DATA
  ADD CONSTRAINT EXCON_PROJECT_CUSTOM_DATAP1
  PRIMARY KEY (EXCON_PROJECT_CUSTOM_DATA_ID);

ALTER TABLE EXCON_PROJECT_CUSTOM_DATA
    ADD CONSTRAINT EXCON_PROJECT_CUSTOM_DATAUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_CUSTOM_DATAIDX1
    ON EXCON_PROJECT_CUSTOM_DATA (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_CUSTOM_DATA
    ADD CONSTRAINT EXCON_PROJECT_CUSTOM_DATAFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_CUSTOM_DATA
    ADD CONSTRAINT EXCON_PROJECT_CUSTOM_DATAFK2
        FOREIGN KEY (CUSTOM_ATTRIBUTE_ID)
            REFERENCES CUSTOM_ATTRIBUTE (ID);

CREATE TABLE EXCON_PROJECT_CUSTOM_DATA_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_CUSTOM_DATA_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_ATTACHMENT_TYPE
(
    TYPE_CODE     VARCHAR(3) NOT NULL,
    DESCRIPTION   VARCHAR(200) NOT NULL,
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36) NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_ATTACHMENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_ATT_TYPEP1
        PRIMARY KEY (TYPE_CODE);

ALTER TABLE EXCON_PROJECT_ATTACHMENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_ATT_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_ATTACHMENTS
(
  PROJECT_ATTACHMENT_ID DECIMAL(22) NOT NULL,
  PROJECT_ID            DECIMAL(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR(12) NOT NULL,
  SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
  TYPE_CODE             VARCHAR(3) NOT NULL,
  DOCUMENT_ID           DECIMAL(4) NOT NULL,
  FILE_ID               DECIMAL(22) NOT NULL,
  DESCRIPTION           VARCHAR(200),
  attach_user           VARCHAR(60),
  attach_date           DATETIME,
  UPDATE_TIMESTAMP      DATETIME NOT NULL,
  UPDATE_USER           VARCHAR(60) NOT NULL,
  OBJ_ID                VARCHAR(36) NOT NULL,
  VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_ATTACHMENTS
  ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSP1
  PRIMARY KEY (PROJECT_ATTACHMENT_ID);

ALTER TABLE EXCON_PROJECT_ATTACHMENTS
    ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_ATTACHMENTSIDX1
    ON EXCON_PROJECT_ATTACHMENTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_ATTACHMENTS
    ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_ATTACHMENTS
    ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSFK2
        FOREIGN KEY (TYPE_CODE)
            REFERENCES EXCON_PROJECT_ATTACHMENT_TYPE (TYPE_CODE);

ALTER TABLE EXCON_PROJECT_ATTACHMENTS
    ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSFK3
        FOREIGN KEY (FILE_ID)
            REFERENCES ATTACHMENT_FILE (FILE_ID);

CREATE TABLE EXCON_PROJECT_ATTACHMENT_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_ATTACHMENT_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_RSTRCT_CNTRY
(
    POSTAL_CNTRY_CD      VARCHAR(3),
    SANCTION_LIST_CODE   VARCHAR(4),
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID               VARCHAR(36) NOT NULL,
    VER_NBR              DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_RSTRCT_CNTRY
  ADD CONSTRAINT EXCON_PROJECT_RST_CTRYP1
  PRIMARY KEY (POSTAL_CNTRY_CD);

ALTER TABLE EXCON_PROJECT_RSTRCT_CNTRY
    ADD CONSTRAINT EXCON_PROJECT_RST_CTRYUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_DESTINATIONS
(
  PROJECT_DEST_ID         DECIMAL(22) NOT NULL,
  PROJECT_ID              DECIMAL(22) NOT NULL,
  PROJECT_NUMBER          VARCHAR(12) NOT NULL,
  SEQUENCE_NUMBER         DECIMAL(4) DEFAULT 1,
  DESTINATION_COUNTRY_CD  VARCHAR(3) NOT NULL,
  ARRIVAL_DATE            DATETIME,
  DEPARTURE_DATE          DATETIME,
  DESTINATION_COMMENT     LONGTEXT,
  SANCTION_LIST           VARCHAR(4),
  UPDATE_TIMESTAMP        DATETIME NOT NULL,
  UPDATE_USER             VARCHAR(60) NOT NULL,
  OBJ_ID                  VARCHAR(36) NOT NULL,
  VER_NBR                 DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_DESTINATIONS
  ADD CONSTRAINT EXCON_PROJECT_DESTINATIONSP1
  PRIMARY KEY (PROJECT_DEST_ID);

ALTER TABLE EXCON_PROJECT_DESTINATIONS
    ADD CONSTRAINT EXCON_PROJECT_DESTINATIONSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_DESTINATIONSIDX1
    ON EXCON_PROJECT_DESTINATIONS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_DESTINATIONS
    ADD CONSTRAINT EXCON_PROJECT_DESTINATIONSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE TABLE EXCON_PROJECT_DEST_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_DEST_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_RSTRCT_UNIT
(
    UNIT_NUMBER      VARCHAR(8),
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID               VARCHAR(36) NOT NULL,
    VER_NBR              DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_RSTRCT_UNIT
  ADD CONSTRAINT EXCON_PROJECT_RST_UNITP1
  PRIMARY KEY (UNIT_NUMBER);

ALTER TABLE EXCON_PROJECT_RSTRCT_UNIT
    ADD CONSTRAINT EXCON_PROJECT_RST_UNITUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_PROJECT_RSTRCT_UNIT
    ADD CONSTRAINT EXCON_PROJECT_RST_UNITFK1
        FOREIGN KEY (UNIT_NUMBER)
            REFERENCES UNIT (UNIT_NUMBER);

CREATE TABLE EXCON_PROJECT_EXT_INSTS
(
    PROJECT_EXT_INST_ID     DECIMAL(22) NOT NULL,
    ROLODEX_ID            DECIMAL(6) NOT NULL,
    PROJECT_ID            DECIMAL(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR(12) NOT NULL,
    SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36) NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_EXT_INSTS
    ADD CONSTRAINT EXCON_PROJECT_EXT_INSTSP1
        PRIMARY KEY (PROJECT_EXT_INST_ID);

ALTER TABLE EXCON_PROJECT_EXT_INSTS
    ADD CONSTRAINT EXCON_PROJECT_EXT_INSTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_EXT_INSTSIDX1
    ON EXCON_PROJECT_EXT_INSTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_EXT_INSTS
    ADD CONSTRAINT EXCON_PROJECT_EXT_INSTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_EXT_INSTS
    ADD CONSTRAINT EXCON_PROJECT_EXT_INSTSFK2
        FOREIGN KEY (ROLODEX_ID)
            REFERENCES ROLODEX (ROLODEX_ID);

CREATE TABLE EXCON_PROJECT_EXT_INSTS_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_EXT_INSTS_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_REVIEWS
(
    PROJECT_REVIEW_ID     DECIMAL(22) NOT NULL,
    REVIEW_TYPE_CODE 		  VARCHAR(3) NOT NULL,
    REVIEW_COMMENT        VARCHAR(100),
    PROJECT_ID            DECIMAL(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR(12) NOT NULL,
    SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36) NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_REVIEWS
    ADD CONSTRAINT EXCON_PROJECT_REVIEWSP1
        PRIMARY KEY (PROJECT_REVIEW_ID);

ALTER TABLE EXCON_PROJECT_REVIEWS
    ADD CONSTRAINT EXCON_PROJECT_REVIEWSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_REVIEWSIDX1
    ON EXCON_PROJECT_REVIEWS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_REVIEWS
    ADD CONSTRAINT EXCON_PROJECT_REVIEWSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE TABLE EXCON_PROJECT_REVIEWS_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_REVIEWS_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_ASSOC_DOC_TYPE
(
    ASSOC_DOC_TYPE_CODE     	VARCHAR(8) NOT NULL,
    ASSOC_DOC_TYPE_NAME	  	VARCHAR(40) NOT NULL,
    ASSOC_DOC_TYPE_CLASS_NAME VARCHAR(100),
    ASSOC_DOC_TYPE_NBR_ATTR	VARCHAR(40),
    RETURNS_VALS				CHAR(1) DEFAULT 'N',
    UPDATE_TIMESTAMP        	DATETIME NOT NULL,
    UPDATE_USER             	VARCHAR(60) NOT NULL,
    OBJ_ID                  	VARCHAR(36) NOT NULL,
    VER_NBR                 	DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_ASSOC_DOC_TYPE
    ADD CONSTRAINT EXCON_PROJ_ASSOC_DOC_TYPEP1
        PRIMARY KEY (ASSOC_DOC_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_ASSOC_DOC_TYPE
    ADD CONSTRAINT EXCON_PROJ_ASSOC_DOC_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_ASSOC_DOCS
(
    ASSOC_DOC_ID         	  DECIMAL(22) NOT NULL,
    ASSOC_DOC_TYPE_CODE	  VARCHAR(8) NOT NULL,
    ASSOC_DOC_NUMBER        VARCHAR(12) NOT NULL,
    ASSOC_DOC_TITLE		  VARCHAR(200),
    PROJECT_ID              DECIMAL(22) NOT NULL,
    PROJECT_NUMBER          VARCHAR(12) NOT NULL,
    SEQUENCE_NUMBER         DECIMAL(4) DEFAULT 1,
    UPDATE_TIMESTAMP        DATETIME NOT NULL,
    UPDATE_USER             VARCHAR(60) NOT NULL,
    OBJ_ID                  VARCHAR(36) NOT NULL,
    VER_NBR                 DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_ASSOC_DOCS
    ADD CONSTRAINT EXCON_PROJECT_ASSOC_DOCSP1
        PRIMARY KEY (ASSOC_DOC_ID);

ALTER TABLE EXCON_PROJECT_ASSOC_DOCS
    ADD CONSTRAINT EXCON_PROJECT_ASSOC_DOCSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_ASSOC_DOCSIDX1
    ON EXCON_PROJECT_ASSOC_DOCS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_ASSOC_DOCS
    ADD CONSTRAINT EXCON_PROJECT_ASSOC_DOCSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_ASSOC_DOCS
    ADD CONSTRAINT EXCON_PROJECT_ASSOC_DOCSFK2
        FOREIGN KEY (ASSOC_DOC_TYPE_CODE)
            REFERENCES EXCON_PROJECT_ASSOC_DOC_TYPE (ASSOC_DOC_TYPE_CODE);

CREATE TABLE EXCON_PROJECT_ASSOC_DOCS_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_ASSOC_DOCS_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_RPS_ENTITY
(
    RPS_ENTITY_ID         DECIMAL(22) NOT NULL,
    PROJECT_ID            DECIMAL(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR(12) NOT NULL,
    SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
    FIRST_NAME            VARCHAR(60),
    LAST_NAME             VARCHAR(60),
    OTHER_NAMES           VARCHAR(200),
    CONCAT_NAMES          VARCHAR(320),
    COMPANY_NAME			VARCHAR(100),
    STREET_ADDRESS			VARCHAR(80),
    CITY					VARCHAR(50),
    STATE					VARCHAR(50),
    COUNTRY_CODE          VARCHAR(3),
    BIRTHDATE             DATETIME,
    OTHER_INFO            LONGTEXT,
    RPS_MATCH_CODE        VARCHAR(3),
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36) NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_RPS_ENTITY
    ADD CONSTRAINT EXCON_PROJECT_RPS_ENTITYP1
        PRIMARY KEY (RPS_ENTITY_ID);

ALTER TABLE EXCON_PROJECT_RPS_ENTITY
    ADD CONSTRAINT EXCON_PROJECT_RPS_ENTITYUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_RPS_ENTITYIDX1
    ON EXCON_PROJECT_RPS_ENTITY (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_RPS_ENTITY
    ADD CONSTRAINT EXCON_PROJECT_RPS_ENTITYFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE TABLE EXCON_PROJECT_RPS_ENTITY_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_RPS_ENTITY_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_PROJECT_HR_EXTENSION
(
    REQUEST_TYPE			VARCHAR(6),
    EMPLOYEE_TYPE			VARCHAR(6),
    JOB_CODE				VARCHAR(6),
    BC_RESULT				VARCHAR(6),
    BC_STATUS				VARCHAR(6),
    SELF_DISCLOSED		VARCHAR(6),
    CRIMINAL_DISC			LONGTEXT,
    CRIMINAL_OFFENSES		LONGTEXT,
    MVR_DISC				LONGTEXT,
    NOTES					LONGTEXT,
    CONTACT				VARCHAR(80),
    CRIMINAL_CHK			VARCHAR(1),
    CRIMINAL_PRV			VARCHAR(1),
    MVR_CHK				VARCHAR(1),
    MVR_PRV				VARCHAR(1),
    STATE_CHK				VARCHAR(1),
    CREDIT_CHK			VARCHAR(1),
    SEX_OFFENDER_CHK		VARCHAR(1),
    EDUCATION_CHK			VARCHAR(1),
    SSN_NO_DATA			VARCHAR(1),
    HARD_COPY_REQ			VARCHAR(1),
    CAND_DISPUTE			VARCHAR(1),
    RERUN_REASON			VARCHAR(6),
    PROJECT_ID            DECIMAL(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR(12) NOT NULL,
    SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36) NOT NULL,
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_HR_EXTENSION
    ADD CONSTRAINT EXCON_PROJECT_HR_EXTENSIONP1
        PRIMARY KEY (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_HR_EXTENSION
    ADD CONSTRAINT EXCON_PROJECT_HR_EXTENSIONUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_HR_EXTENSIONIDX1
    ON EXCON_PROJECT_HR_EXTENSION (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_HR_EXTENSION
    ADD CONSTRAINT EXCON_PROJECT_HR_EXTENSIONFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE TABLE EXCON_PROJECT_UNIT_ROLE_TYPE
(
    UNIT_PERSON_ROLE_TYPE_CODE 	VARCHAR(5) NOT NULL,
    DESCRIPTION                   VARCHAR(300) NOT NULL,
    UPDATE_TIMESTAMP              DATETIME NOT NULL,
    UPDATE_USER                   VARCHAR(60) NOT NULL,
    OBJ_ID                        VARCHAR(36) NOT NULL,
    VER_NBR                       DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_UNIT_ROLE_TYPE
    ADD CONSTRAINT EXCON_PROJ_UNIT_ROLE_TYPE_P1
        PRIMARY KEY (UNIT_PERSON_ROLE_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_UNIT_ROLE_TYPE
    ADD CONSTRAINT EXCON_PROJ_UNIT_ROLE_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_RPS_RESULTS
(
    RPS_RESULT_ID      	DECIMAL(22) NOT NULL,
    RPS_RESULT_CONTENT	LONGTEXT NOT NULL,
    RPS_SEARCH_DATE		DATETIME NOT NULL,
    RPS_SEARCH_USER		VARCHAR(60) NOT NULL,
    PROJECT_ID            DECIMAL(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR(12) NOT NULL,
    SEQUENCE_NUMBER       DECIMAL(4) DEFAULT 1,
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36),
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_RPS_RESULTS
    ADD CONSTRAINT EXCON_PROJECT_RPS_RESULTSP1
        PRIMARY KEY (RPS_RESULT_ID);

ALTER TABLE EXCON_PROJECT_RPS_RESULTS
    ADD CONSTRAINT EXCON_PROJECT_RPS_RESULTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_RPS_RESULTSIDX1
    ON EXCON_PROJECT_RPS_RESULTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_RPS_RESULTS
    ADD CONSTRAINT EXCON_PROJECT_RPS_RESULTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE TABLE EXCON_PROJECT_RPS_RESULTS_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_PROJECT_RPS_RESULTS_S AUTO_INCREMENT = 1;

CREATE TABLE EXCON_INTL_SHIPMENT_DOCUMENT (
                                               DOCUMENT_NUMBER     VARCHAR(40) NOT NULL,
                                               VER_NBR             DECIMAL(8) default 1 NOT NULL,
                                               OBJ_ID              VARCHAR(36) NOT NULL,
                                               UPDATE_TIMESTAMP    DATETIME NOT NULL,
                                               UPDATE_USER         VARCHAR(60) NOT NULL);
ALTER TABLE EXCON_INTL_SHIPMENT_DOCUMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENT_DOCP1
        PRIMARY KEY (DOCUMENT_NUMBER);

ALTER TABLE EXCON_INTL_SHIPMENT_DOCUMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENT_DOCUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_INTL_SHIPMENT
(
    DOCUMENT_NUMBER     VARCHAR(40) NOT NULL,
    SHIPMENT_ID      		DECIMAL(22) NOT NULL,
    RESTRICTED_EXPORT		VARCHAR(1) NOT NULL,
    SHIPMENT_DESC			LONGTEXT NOT NULL,
    RESTRICTED_COUNTRY	VARCHAR(1) NOT NULL,
    COUNTRY_CODE			VARCHAR(3) NOT NULL,
    SANCTION_LIST_CODE	VARCHAR(4),
    RESTRICTED_PARTY		VARCHAR(1) NOT NULL,
    RECEIVING_PARTY		LONGTEXT NOT NULL,
    RPS_RESULT_CONTENT	LONGTEXT,
    CERTIFICATION_IND		VARCHAR(1) NOT NULL,
    APPLICANT_ID			VARCHAR(40) NOT NULL,
    APPLICANT_NAME		VARCHAR(200) NOT NULL,
    SUPERVISOR_ID			VARCHAR(40) NOT NULL,
    SUPERVISOR_NAME		VARCHAR(200) NOT NULL,
    UNIT_NUMBER			VARCHAR(8) NOT NULL,
    UNIT_NAME				VARCHAR(200) NOT NULL,
    UPDATE_TIMESTAMP      DATETIME NOT NULL,
    UPDATE_USER           VARCHAR(60) NOT NULL,
    OBJ_ID                VARCHAR(36),
    VER_NBR               DECIMAL(8) default 1 NOT NULL
);
ALTER TABLE EXCON_INTL_SHIPMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENTP1
        PRIMARY KEY (SHIPMENT_ID);

ALTER TABLE EXCON_INTL_SHIPMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENTUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_INTL_SHIPMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENTFK1
        FOREIGN KEY (DOCUMENT_NUMBER)
            REFERENCES EXCON_INTL_SHIPMENT_DOCUMENT (DOCUMENT_NUMBER);

CREATE TABLE EXCON_INTL_SHIPMENT_S (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id)) ENGINE MyISAM;
ALTER TABLE EXCON_INTL_SHIPMENT_S AUTO_INCREMENT = 1;
