/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mysql;

import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.flywaydb.authentication.mysql.MySQLOptionFileReader;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayUpgradeMessage;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.UrlUtils;
import org.flywaydb.database.mysql.MySQLDatabase;
import org.flywaydb.database.mysql.MySQLParser;

public class MySQLDatabaseType
extends BaseDatabaseType {
    @Generated
    private static final Log LOG = LogFactory.getLog(MySQLDatabaseType.class);
    private static final String MYSQL_LEGACY_JDBC_DRIVER = "com.mysql.jdbc.Driver";
    private static final String MARIADB_JDBC_DRIVER = "org.mariadb.jdbc.Driver";

    @Override
    public String getName() {
        return "MySQL";
    }

    @Override
    public List<String> getSupportedEngines() {
        return List.of(this.getName(), "PerconaXtraDbCluster", "TiDb", "AuroraMySql");
    }

    @Override
    public int getNullType() {
        return 12;
    }

    @Override
    public boolean handlesJDBCUrl(String url) {
        return UrlUtils.isSecretManagerUrl(url, "mysql") || url.startsWith("jdbc:mysql:") || url.startsWith("jdbc:google:") || url.startsWith("jdbc:p6spy:mysql:") || url.startsWith("jdbc:p6spy:google:") || UrlUtils.isAwsWrapperUrl(url, "mysql");
    }

    @Override
    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:mysql:") || url.startsWith("jdbc:p6spy:google:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        if (url.startsWith("jdbc:mysql:")) {
            return "com.mysql.cj.jdbc.Driver";
        }
        if (UrlUtils.isAwsWrapperUrl(url, "mysql")) {
            return "software.amazon.jdbc.Driver";
        }
        return "com.mysql.jdbc.GoogleDriver";
    }

    @Override
    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        if (ClassUtils.isPresent(MYSQL_LEGACY_JDBC_DRIVER, classLoader)) {
            return MYSQL_LEGACY_JDBC_DRIVER;
        }
        if (ClassUtils.isPresent(MARIADB_JDBC_DRIVER, classLoader) && !url.contains("disableMariaDbDriver")) {
            return MARIADB_JDBC_DRIVER;
        }
        return null;
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.contains("MySQL");
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new MySQLDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new MySQLParser(configuration, parsingContext);
    }

    @Override
    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("connectionAttributes", "program_name:Flyway by Redgate");
    }

    @Override
    public Properties getExternalAuthProperties(String url, String username) {
        MySQLOptionFileReader mySQLOptionFileReader = new MySQLOptionFileReader();
        mySQLOptionFileReader.populateOptionFiles();
        if (!mySQLOptionFileReader.optionFiles.isEmpty()) {
            LOG.info(FlywayUpgradeMessage.generate("a MySQL option file", "use this for database authentication"));
        }
        return super.getExternalAuthProperties(url, username);
    }

    @Override
    public String instantiateClassExtendedErrorMessage() {
        return "Failure probably due to inability to load dependencies. Please ensure you have downloaded 'https://dev.mysql.com/downloads/connector/j/' and extracted to 'flyway/drivers' folder";
    }
}

