-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

update krcr_parm_t
set parm_nm       = 'DEFAULT_REPORTING_DASHBOARD_ID',
    parm_desc_txt = 'Default reporting dashboard id'
where nmspc_cd = 'KC-GEN'
  and cmpnt_cd = 'All'
  and parm_nm = 'KUALI_REPORTS_SISENSE_DEFAULT_DASHBOARD'
  and appl_id = 'KC';

update krcr_parm_t as p1
    left join (select val
               from krcr_parm_t
               where nmspc_cd = 'KC-GEN'
                 and cmpnt_cd = 'All'
                 and parm_nm = 'KUALI_REPORTS_SISENSE_ENABLED'
                 and appl_id = 'KC') as p2 on p1.val is not null
set p1.parm_desc_txt = 'Determines whether the Kuali Report links are available from the KC Application Header. Y to enable, N to disable',
    p1.val           = coalesce(p2.val, 'N')
where p1.nmspc_cd = 'KC-GEN'
  and p1.cmpnt_cd = 'All'
  and p1.parm_nm = 'KUALI_REPORTS_ENABLED'
  and p1.appl_id = 'KC';

delete
from krcr_parm_t
where nmspc_cd = 'KC-GEN'
  and cmpnt_cd = 'All'
  and parm_nm = 'KUALI_REPORTS_SISENSE_ENABLED'
  and appl_id = 'KC';
