-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -
alter table file_data add column location varchar(2048);

ALTER TABLE award_attachment DROP FOREIGN KEY FK_ATTACHMENT_FILE;
ALTER TABLE excon_project_attachments DROP FOREIGN KEY EXCON_PROJECT_ATTACHMENTSFK3;
ALTER TABLE negotiation_attachment DROP FOREIGN KEY NEGOTIATION_ATTACHMENT_FK2;

alter table attachment_file modify file_id varchar(36);
alter table award_attachment modify file_id varchar(36);
alter table excon_project_attachments modify file_id varchar(36);
alter table negotiation_attachment modify file_id varchar(36);

ALTER TABLE award_attachment ADD FOREIGN KEY FK_ATTACHMENT_FILE (file_id) REFERENCES attachment_file(file_id);
ALTER TABLE excon_project_attachments ADD FOREIGN KEY EXCON_PROJECT_ATTACHMENTSFK3 (file_id) REFERENCES attachment_file(file_id);
ALTER TABLE negotiation_attachment ADD FOREIGN KEY NEGOTIATION_ATTACHMENT_FK2 (file_id) REFERENCES attachment_file(file_id);

update subaward_forms set CONTENT_TYPE ='text/xsl' where form is not null;
update subaward_forms  set file_name = null, CONTENT_TYPE = null where form is null;
alter table subaward_forms modify form_id varchar(36);

alter table subaward_forms add constraint subaward_forms_uq1 unique (OBJ_ID);
alter table subaward_forms add column id varchar(36);

update subaward_forms set id = 'RESBOOT01' where form_id = 'FDP Modification';
update subaward_forms set id = 'RESBOOT02' where form_id = 'FDP Template';
update subaward_forms set id = 'RESBOOT03' where form_id = 'FDP Modification Unilateral';
update subaward_forms set id = 'RESBOOT04' where form_id = 'FDP_AFOSR';
update subaward_forms set id = 'RESBOOT05' where form_id = 'FDP_AMRAA';
update subaward_forms set id = 'RESBOOT06' where form_id = 'FDP_AMRMC';
update subaward_forms set id = 'RESBOOT07' where form_id = 'FDP_ARO';
update subaward_forms set id = 'RESBOOT08' where form_id = 'FDP_ATT_3A';
update subaward_forms set id = 'RESBOOT09' where form_id = 'FDP_ATT_3B';
update subaward_forms set id = 'RESBOOT10' where form_id = 'FDP_ATT_3B_2';
update subaward_forms set id = 'RESBOOT11' where form_id = 'FDP_ATT_4';
update subaward_forms set id = 'RESBOOT12' where form_id = 'FDP_DOE';
update subaward_forms set id = 'RESBOOT13' where form_id = 'FDP_EPA';
update subaward_forms set id = 'RESBOOT14' where form_id = 'FDP_NASA';
update subaward_forms set id = 'RESBOOT15' where form_id = 'FDP_NIH';
update subaward_forms set id = 'RESBOOT16' where form_id = 'FDP_NSF';
update subaward_forms set id = 'RESBOOT17' where form_id = 'FDP_ONR';
update subaward_forms set id = 'RESBOOT18' where form_id = 'FDP_USDA';
update subaward_forms set id = UUID() where id is null;

update subaward_forms set file_name = null, content_type = null, form = null where id in ('RESBOOT01', 'RESBOOT02');
update subaward_forms set form_id = 'FDP Bilateral Subaward Amendment', description = 'Default FDP Bilateral Subaward Amendment (September 2019)' where id = 'RESBOOT01';
update subaward_forms set form_id = 'FDP Cost Reimbursement Subaward', description = 'Default FDP Cost Reimbursement Subaward (September 2019)' where id = 'RESBOOT02';
update subaward_forms set form_id = 'FDP Unilateral Subaward Amendment' where id = 'RESBOOT03';

alter table subaward_forms drop primary key;
alter table subaward_forms add constraint PK_SUBAWARD_FORMS primary key (id);
alter table subaward_forms add constraint subaward_forms_uq2 unique (description);

alter table subaward_forms add column actv_ind char(1) not null default 'N';
update subaward_forms set actv_ind = 'Y';

create index subaward_forms_idx1 on subaward_forms (form_id, actv_ind);

alter table subaward_forms add column PDF_FORM_FILE_ID VARCHAR(36);
ALTER TABLE subaward_forms ADD CONSTRAINT FK_PDF_ID_SUBAWARD_FORMS FOREIGN KEY (PDF_FORM_FILE_ID) REFERENCES ATTACHMENT_FILE (FILE_ID);

alter table subaward_forms add column MAPPING_FILE_ID VARCHAR(36);
ALTER TABLE subaward_forms ADD CONSTRAINT FK_MAP_ID_SUBAWARD_FORMS FOREIGN KEY (MAPPING_FILE_ID) REFERENCES ATTACHMENT_FILE (FILE_ID);

CREATE TABLE seq_subaward_forms (id BIGINT(19) NOT NULL AUTO_INCREMENT, PRIMARY KEY (id));
ALTER TABLE seq_subaward_forms AUTO_INCREMENT = 1;

insert into file_data (id, location) values ('RESBOOT001', 'classpath:META-INF/resources/public/org/kuali/kra/subaward/reporting/pdf/FDP_BI_MOD_2019.pdf');
insert into attachment_file (FILE_ID, SEQUENCE_NUMBER, FILE_NAME, CONTENT_TYPE, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, file_data_id)
values ('RESBOOT001', 1, 'FDP_BI_MOD_2019.pdf', 'application/pdf', 1, NOW(), 'admin', UUID(), 'RESBOOT001');
update subaward_forms set PDF_FORM_FILE_ID = 'RESBOOT001' where id = 'RESBOOT01';

insert into file_data (id, location) values ('RESBOOT002', 'classpath:META-INF/resources/public/org/kuali/kra/subaward/reporting/mapping/FDP_BI_MOD_2019.json');
insert into attachment_file (FILE_ID, SEQUENCE_NUMBER, FILE_NAME, CONTENT_TYPE, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, file_data_id)
values ('RESBOOT002', 1, 'FDP_BI_MOD_2019.json', 'application/json', 1, NOW(), 'admin', UUID(), 'RESBOOT002');
update subaward_forms set MAPPING_FILE_ID = 'RESBOOT002' where id = 'RESBOOT01';

insert into file_data (id, location) values ('RESBOOT003', 'classpath:META-INF/resources/public/org/kuali/kra/subaward/reporting/pdf/FDP_CR_2019.pdf');
insert into attachment_file (FILE_ID, SEQUENCE_NUMBER, FILE_NAME, CONTENT_TYPE, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, file_data_id)
values ('RESBOOT003', 1, 'FDP_CR_2019.pdf', 'application/pdf', 1, NOW(), 'admin', UUID(), 'RESBOOT003');
update subaward_forms set PDF_FORM_FILE_ID = 'RESBOOT003' where id = 'RESBOOT02';

insert into file_data (id, location) values ('RESBOOT004', 'classpath:META-INF/resources/public/org/kuali/kra/subaward/reporting/mapping/FDP_CR_2019.json');
insert into attachment_file (FILE_ID, SEQUENCE_NUMBER, FILE_NAME, CONTENT_TYPE, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, file_data_id)
values ('RESBOOT004', 1, 'FDP_CR_2019.json', 'application/json', 1, NOW(), 'admin', UUID(), 'RESBOOT004');
update subaward_forms set MAPPING_FILE_ID = 'RESBOOT004' where id = 'RESBOOT02';
