-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -


-- PHS398_CareerDevelopmentyAwardSupplement

-- Correcting a mistaken overlap for some customers.

DELETE FROM NARRATIVE_TYPE WHERE NARRATIVE_TYPE_CODE = '162' AND DESCRIPTION = 'PHS_CareerDevelopmentAwardSupplement_Other_Plans';
DELETE FROM VALID_NARR_FORMS WHERE FORM_NAME = 'PHS398_CareerDevelopmentAwardSup_6_0' AND NARRATIVE_TYPE_CODE = '162';

-- Narratives

INSERT IGNORE INTO NARRATIVE_TYPE (NARRATIVE_TYPE_CODE,DESCRIPTION,NARRATIVE_TYPE_GROUP,ALLOW_MULTIPLE,SYSTEM_GENERATED,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ('190','PHS_CareerDevelopmentAwardSupplement_Other_Plans','P','N','N','admin',NOW(),UUID(),1);

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', '190', 'Y', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Candidate_Contribution'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_IntroductionToApplication'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHSCareer_CandidateInformationAndGoals'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_SpecificAims'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Res_Strategy'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_ProgressReportPubList'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Training_Resp_Conduct_Research'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Mentoring_Plan'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Mentor_Statements_Letters'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_SupportLtrs'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Inst_Environment'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Inst_Commitment'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_VertebrateAnimals'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_SelectAgentResearch'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Consortium_Contract'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Resource_Sharing_Plan'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHSCareer_KeyBioAndOrChemResources'), 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_CareerDevelopmentAwardSup_6_0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Appendix'), 'N', 'admin', NOW(), UUID());

-- Errors
INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/PHS398_CareerDevelopmentAwardSup_6_0/CareerDevelopmentAwardAttachments/ResearchStrategy', 'Research Strategy attachment is required for Career Development Award Supplement.', 'abstractsAttachments', NOW(), 'admin', 1, UUID());

INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/PHS398_CareerDevelopmentAwardSup_6_0/isNonUSCitizenship', 'Citizenship info is not valid for PI. Please make sure a PI has been added and the PI''s citizenship status has been selected in the Extended Details.', 'keyPersonnel', NOW(), 'admin', 1, UUID());

-- PHS_Fellowship_Supplemental_7_0

-- Fix conflict

DELETE FROM NARRATIVE_TYPE WHERE NARRATIVE_TYPE_CODE = '163' AND DESCRIPTION = 'PHS_Fellowship_Supplemental_Other_Plans';
DELETE FROM VALID_NARR_FORMS WHERE FORM_NAME = 'PHS_Fellowship_Supplemental_7_0' AND NARRATIVE_TYPE_CODE = '163';

-- Narratives


INSERT IGNORE INTO NARRATIVE_TYPE (NARRATIVE_TYPE_CODE,DESCRIPTION,NARRATIVE_TYPE_GROUP,ALLOW_MULTIPLE,SYSTEM_GENERATED,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ('191','PHS_Fellowship_Supplemental_Other_Plans','P','N','N','admin',NOW(),UUID(),1);

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '191', 'Y', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '97', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '98', 'Y', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '127', 'Y', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '88', 'Y', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '89', 'Y', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '103', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '90', 'Y', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '134', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '108', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '109', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '110', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '91', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '96', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '156', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '157', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '158', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '160', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS_Fellowship_Supplemental_7_0', '-7', 'N', 'admin', NOW(), UUID());

-- Questionnaire

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire (QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_ID, SEQUENCE_NUMBER, NAME, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, IS_FINAL, DOCUMENT_NUMBER, VER_NBR, OBJ_ID, file_name, template)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_QUESTIONNAIRE_REF_ID), -14, 1, 'PHS Fellowship Supplemental 7.0',
        'The responses are used to populate the PHS 398 Fellowship Supplement v7-0 for submission via Grants.gov.',
        NOW(), 'admin', 'Y', NULL, 1, UUID(), NULL, NULL);


INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 5 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                   FROM QUESTION
                                                   WHERE QUESTION_ID = 5)), 5, 0, 'N', NULL, NULL, NOW(), 'kr', 5, 1,
     UUID(), NULL);


INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 6 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                   FROM QUESTION
                                                   WHERE QUESTION_ID = 6)), 6, 5, 'Y', '4', 'Y', NOW(), 'kr', 1, 1,
     UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);
INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 7 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                   FROM QUESTION
                                                   WHERE QUESTION_ID = 7)), 7, 6, 'Y', '4', 'Y', NOW(), 'kr', 1, 1,
     UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 24 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 24)), 26, 0, 'N', NULL, NULL, NOW(), 'kr', 8,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 32 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 32)), 27, 26, 'Y', '4', 'Y', NOW(), 'kr', 1, 1,
     UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 28 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 28)), 32, 0, 'N', NULL, NULL, NOW(), 'kr', 9,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 29 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 29)), 33, 32, 'Y', '4', 'Y', NOW(), 'kr', 1, 1,
     UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 33 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 33)), 49, 27, 'N', NULL, NULL, NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 36 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 36)), 72, 0, 'N', NULL, NULL, NOW(), 'kr', 10,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 37 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 37)), 73, 72, 'Y', '4', 'Y', NOW(), 'kr', 2, 1,
     UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 38 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 38)), 74, 73, 'Y', '4', 'Y', NOW(), 'kr', 1, 1,
     UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 51 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 51)), 75, 74, 'N', NULL, NULL, NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 40 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 40)), 76, 75, 'N', NULL, NULL, NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 41 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 41)), 77, 76, 'N', NULL, NULL, NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 42 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 42)), 78, 0, 'N', NULL, NULL, NOW(), 'kr', 7,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 35 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 35)), 79, 78, 'Y', '4', 'Y', NOW(), 'kr', 1, 1,
     UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 99 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE
                                                            QUESTION_ID = 99 AND LOOKUP_RETURN = 'GraduateLevelDegree1-2')
        AND LOOKUP_RETURN = 'GraduateLevelDegree1-2'), 80, 78, 'Y', '4', 'Y', NOW(), 'kr', 2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 16 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 16)), 81, 80, 'Y', '2', 'MOTH', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 17 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 17)), 82, 80, 'Y', '2', 'DOTH', NOW(), 'kr', 2,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 18 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 18)), 83, 80, 'Y', '2', 'DDOT', NOW(), 'kr', 3,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 19 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 19)), 84, 80, 'Y', '2', 'VDOT', NOW(), 'kr', 4,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 100 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                     FROM QUESTION
                                                     WHERE QUESTION_ID = 100)), 85, 80, 'Y', '2', 'OTH', NOW(), 'kr',
     5, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 21 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 21)), 86, 80, 'Y', '2', 'MDOT', NOW(), 'kr', 6,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 43 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 43)), 87, 49, 'N', NULL, NULL, NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 44 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 44)), 88, 87, 'Y', '4', 'Y', NOW(), 'kr', 1, 1,
     UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 47 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 47)), 120, 72, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 48 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 48)), 121, 120, 'N', NULL, NULL, NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 50 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 50)), 122, 121, 'N', NULL, NULL, NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 49 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 49)), 123, 87, 'N', NULL, NULL, NOW(), 'kr', 2,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 45 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 45)), 124, 123, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 46 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 46)), 125, 123, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 27 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 27)), 126, 125, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 31 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 31)), 127, 125, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 32 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 32)), 128, 127, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 33 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 33)), 129, 128, 'N', NULL, NULL, NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 43 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 43)), 130, 129, 'N', NULL, NULL, NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 44 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 44)), 131, 130, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 49 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 49)), 132, 130, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 45 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 45)), 133, 132, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 46 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 46)), 134, 132, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 27 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 27)), 135, 134, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 31 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 31)), 136, 134, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 32 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 32)), 137, 136, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 33 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 33)), 138, 137, 'N', NULL, NULL, NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 43 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 43)), 139, 138, 'N', NULL, NULL, NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 44 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 44)), 140, 139, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 49 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 49)), 141, 139, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 45 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 45)), 142, 141, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 46 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 46)), 143, 141, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 27 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 27)), 144, 143, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 31 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 31)), 145, 143, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 32 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 32)), 146, 145, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 33 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 33)), 147, 146, 'N', NULL, NULL, NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 43 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 43)), 148, 147, 'N', NULL, NULL, NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 44 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 44)), 149, 148, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 49 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 49)), 150, 148, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 45 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 45)), 151, 150, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 46 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 46)), 152, 150, 'N', NULL, NULL, NOW(), 'kr',
     2, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 27 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                    FROM QUESTION
                                                    WHERE QUESTION_ID = 27)), 153, 152, 'Y', '4', 'Y', NOW(), 'kr', 1,
     1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 145 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                     FROM QUESTION
                                                     WHERE QUESTION_ID = 145)), 154, 0, 'N', NULL, NULL, NOW(), 'kr',
     4, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 146 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                     FROM QUESTION
                                                     WHERE QUESTION_ID = 146)), 155, 154, 'Y', '4', 'Y', NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 147 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                     FROM QUESTION
                                                     WHERE QUESTION_ID = 147)), 156, 155, 'Y', '4', 'Y', NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = 148 AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                     FROM QUESTION
                                                     WHERE QUESTION_ID = 148)), 157, 156, 'Y', '4', 'N', NOW(), 'kr',
     1, 1, UUID(), NULL);

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_TIMESTAMP, UPDATE_USER, QUESTION_SEQ_NUMBER, VER_NBR, OBJ_ID, RULE_ID)
VALUES
    ((SELECT (MAX(ID))
      FROM SEQ_QUESTIONNAIRE_REF_ID), (SELECT QUESTIONNAIRE_REF_ID
                                       FROM QUESTIONNAIRE
                                       WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1),
     (SELECT QUESTION_REF_ID
      FROM QUESTION
      WHERE QUESTION_ID = '200' AND SEQUENCE_NUMBER = (SELECT MAX(SEQUENCE_NUMBER)
                                                       FROM QUESTION
                                                       WHERE QUESTION_ID = 200)), 160, 0, 'N', NULL, NULL, NOW(), 'kr',
     6, 1, UUID(), NULL);


INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID, MODULE_ITEM_CODE, MODULE_SUB_ITEM_CODE, QUESTIONNAIRE_REF_ID_FK, QUESTIONNAIRE_SEQUENCE_NUMBER, RULE_ID, QUESTIONNAIRE_LABEL, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, IS_MANDATORY)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_QUESTIONNAIRE_REF_ID), 3, 2, (SELECT QUESTIONNAIRE_REF_ID
                                                FROM QUESTIONNAIRE
                                                WHERE QUESTIONNAIRE_ID = -14 AND SEQUENCE_NUMBER = 1), 1, NULL, 'PHS Fellowship Supplemental 7.0',
        NOW(), 'admin', 1, UUID(), 'N');

INSERT IGNORE INTO SEQ_QUESTIONNAIRE_REF_ID VALUES (NULL);

INSERT IGNORE INTO s2s_form_to_questionnaire (S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES ((SELECT max(id)
         FROM SEQ_QUESTIONNAIRE_REF_ID), 'http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_7_0-V7.0', 'PHS_Fellowship_Supplemental_7_0', -14,
        NOW(), 'admin', UUID(), '1');

-- Errors

INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (NULL);

INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/PHS_Fellowship_Supplemental_7_0/ResearchTrainingPlan/ResearchStrategy',
        'Research Strategy attachment is required for Research Training Plan.', 'abstractsAttachments', NOW(), 'admin', 1, UUID());

INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (NULL);

INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/PHS_Fellowship_Supplemental_7_0/ResearchTrainingPlan/RespectiveContribution',
        'Research Contribution attachment is required for Research Training Plan.', 'abstractsAttachments', NOW(), 'admin', 1, UUID());

INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (NULL);

INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/PHS_Fellowship_Supplemental_7_0/ResearchTrainingPlan/SponsorandInstitution',
        'Sponsor and institution attachment is required for Research Training Plan.', 'abstractsAttachments', NOW(), 'admin', 1, UUID());

INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (NULL);

INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_S2S_ERROR_ID),
        '/GrantApplication/Forms/PHS_Fellowship_Supplemental_7_0/ResearchTrainingPlan/TrainingInResponsibleConductOfResearch',
        'Responsible Conduct of Research attachment is required for Research Training Plan.', 'abstractsAttachments', NOW(), 'admin', 1, UUID());

INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (NULL);

INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_S2S_ERROR_ID),
        '/GrantApplication/Forms/PHS_Fellowship_Supplemental_7_0/ResearchTrainingPlan/SpecificAims',
        'Specific Aims attachment is required for Research Training Plan.', 'abstractsAttachments', NOW(), 'admin', 1, UUID());

INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (NULL);

INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_S2S_ERROR_ID),
        '/GrantApplication/Forms/PHS_Fellowship_Supplemental_7_0/AdditionalInformation/NonUSCitizen',
        'Citizenship Type is not valid in additional information. ', 'keyPersonnel', NOW(), 'admin', 1, UUID());

-- PHS398_ResearchPlan_5_0

DELETE FROM NARRATIVE_TYPE WHERE NARRATIVE_TYPE_CODE = '161' AND DESCRIPTION = 'PHS_ResearchPlan_Other_Plans';
DELETE FROM VALID_NARR_FORMS WHERE FORM_NAME = 'PHS398_ResearchPlan_5_0' AND NARRATIVE_TYPE_CODE = '161';

INSERT IGNORE INTO NARRATIVE_TYPE (NARRATIVE_TYPE_CODE,DESCRIPTION,NARRATIVE_TYPE_GROUP,ALLOW_MULTIPLE,SYSTEM_GENERATED,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ('192','PHS_ResearchPlan_Other_Plans','P','N','N','admin',NOW(),UUID(),1);

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '192', 'Y', 'admin', NOW(), UUID());
INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '111', 'Y', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '20', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '21', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '30', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '45', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '46', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '31', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '32', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '33', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '150', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '34', 'N', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchPlan_5_0', '44', 'N', 'admin', NOW(), UUID());

-- Errors

INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (NULL);

INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_S2S_ERROR_ID),
        '/GrantApplication/Forms/PHS398_ResearchPlan_5_0/ResearchPlanAttachments/ResearchStrategy',
        'Research Strategy attachment is required for Research Plan.', 'abstractsAttachments', NOW(), 'admin', 1,
        UUID());


-- PHS398_ResearchTrainingProgramPlan_5_0

-- Errors
INSERT IGNORE INTO SEQ_S2S_ERROR_ID VALUES (NULL);

INSERT IGNORE INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID),
        '/GrantApplication/Forms/PHS398_ResearchTrainingProgramPlan_5_0/ResearchTrainingProgramPlanAttachments',
        'Program Plan attachment is required for Research Training Program Plan.',
        'abstractsAttachments', NOW(), 'admin', 1, UUID());

DELETE FROM NARRATIVE_TYPE WHERE NARRATIVE_TYPE_CODE = '164' AND DESCRIPTION = 'PHS_ResearchPlan_Other_Plans';
DELETE FROM VALID_NARR_FORMS WHERE FORM_NAME = 'PHS398_ResearchPlan_5_0' AND NARRATIVE_TYPE_CODE = '164';

-- Narratives
INSERT IGNORE INTO NARRATIVE_TYPE (NARRATIVE_TYPE_CODE,DESCRIPTION,NARRATIVE_TYPE_GROUP,ALLOW_MULTIPLE,SYSTEM_GENERATED,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ('193','PHS_ResearchTrainingProgramPlan_Other_Plans','P','N','N','admin',NOW(),UUID(),1);

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'PHS398_ResearchTrainingProgramPlan_5_0', '193', 'Y', 'admin', NOW(), UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','151','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','112','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','114','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','116','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','121','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','117','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','123','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','125','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','124','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','119','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','120','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','122','N','admin',NOW(),UUID());

INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES(NULL);

INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID,FORM_NAME,NARRATIVE_TYPE_CODE,MANDATORY,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_VALID_NARR_FORMS_ID),'PHS398_ResearchTrainingProgramPlan_5_0','126','N','admin',NOW(),UUID());
