-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
UPDATE QUESTIONNAIRE_ANSWER_HEADER HEAD SET 
  MODULE_ITEM_KEY = (SELECT COI_DISCLOSURE_ID FROM COI_DISCLOSURE DISC WHERE DISC.COI_DISCLOSURE_NUMBER = HEAD.MODULE_ITEM_KEY AND DISC.SEQUENCE_NUMBER = CAST(HEAD.MODULE_SUB_ITEM_KEY as DECIMAL)),
  MODULE_SUB_ITEM_KEY = '-1'
  WHERE MODULE_ITEM_CODE = '8'
/

UPDATE QUESTIONNAIRE_ANSWER_HEADER HEAD SET MODULE_SUB_ITEM_KEY = COALESCE(
	(SELECT COI_PROJECT_ID FROM COI_DISCL_PROJECTS PROJ 
		WHERE PROJ.COI_DISCL_PROJECTS_ID = 
			(SELECT MAX(PROJ2.COI_DISCL_PROJECTS_ID) FROM COI_DISCL_PROJECTS PROJ2 
				WHERE PROJ2.COI_DISCLOSURE_ID = HEAD.MODULE_ITEM_KEY AND
				(PROJ2.ORIGINAL_COI_DISCLOSURE_ID = HEAD.ORIGINAL_COI_DISCLOSURE_ID OR PROJ2.ORIGINAL_COI_DISCLOSURE_ID IS NULL))), 
		'-1')
	WHERE MODULE_ITEM_CODE = '8' AND MODULE_SUB_ITEM_KEY = '-1' AND MODULE_SUB_ITEM_CODE != '6' AND MODULE_SUB_ITEM_CODE != '14' 
  		AND HEAD.ORIGINAL_COI_DISCLOSURE_ID IS NOT NULL
/

ALTER TABLE QUESTIONNAIRE_ANSWER_HEADER DROP COLUMN ORIGINAL_COI_DISCLOSURE_ID
/

DELIMITER ;
