-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
ALTER TABLE FILE_DATA MODIFY ID VARCHAR(36) CHARACTER SET utf8 COLLATE utf8_bin
/
ALTER TABLE BUDGET_SUB_AWARDS ADD FILE_DATA_ID VARCHAR(36)
/
ALTER TABLE BUDGET_SUB_AWARDS ADD XML_DATA_ID VARCHAR(36)
/
UPDATE BUDGET_SUB_AWARDS SET FILE_DATA_ID = UUID() WHERE SUB_AWARD_XFD_FILE IS NOT NULL
/
UPDATE BUDGET_SUB_AWARDS SET XML_DATA_ID = UUID() WHERE SUB_AWARD_XML_FILE IS NOT NULL
/
INSERT INTO FILE_DATA (SELECT FILE_DATA_ID, SUB_AWARD_XFD_FILE FROM BUDGET_SUB_AWARDS WHERE FILE_DATA_ID IS NOT NULL)
/
INSERT INTO FILE_DATA (SELECT XML_DATA_ID, SUB_AWARD_XML_FILE FROM BUDGET_SUB_AWARDS WHERE XML_DATA_ID IS NOT NULL)
/
ALTER TABLE BUDGET_SUB_AWARDS DROP COLUMN SUB_AWARD_XFD_FILE
/
ALTER TABLE BUDGET_SUB_AWARDS DROP COLUMN SUB_AWARD_XML_FILE
/
ALTER TABLE BUDGET_SUB_AWARDS ADD FOREIGN KEY FK2_BUDGET_SUB_AWARDS (FILE_DATA_ID) REFERENCES FILE_DATA (ID)
/
ALTER TABLE BUDGET_SUB_AWARDS ADD FOREIGN KEY FK3_BUDGET_SUB_AWARDS (XML_DATA_ID) REFERENCES FILE_DATA (ID)
/
DELIMITER ;
