-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
INSERT INTO KRNS_DOC_HDR_T (DOC_HDR_ID,OBJ_ID,VER_NBR,FDOC_DESC,ORG_DOC_HDR_ID,TMPL_DOC_HDR_ID,EXPLANATION)
VALUES ('KCIAC0209',UUID(),1,'IACUC Demo Committee',NULL,NULL,NULL)
/
INSERT INTO COMMITTEE_DOCUMENT (DOCUMENT_NUMBER,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,COMMITTEE_ID,DOC_STATUS_CODE) 
VALUES ('KCIAC0209',NOW(),'admin',0,UUID(),'KC002','F')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMMITTEE (ID,DOCUMENT_NUMBER,COMMITTEE_ID,COMMITTEE_NAME,HOME_UNIT_NUMBER,DESCRIPTION,SCHEDULE_DESCRIPTION,COMMITTEE_TYPE_CODE,MINIMUM_MEMBERS_REQUIRED,MAX_PROTOCOLS,ADV_SUBMISSION_DAYS_REQ,DEFAULT_REVIEW_TYPE_CODE,APPLICABLE_REVIEW_TYPE_CODE,CREATE_TIMESTAMP,CREATE_USER,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,SEQUENCE_NUMBER,OBJ_ID,COI_REVIEW_TYPE_CODE)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT DOC_HDR_ID FROM KRNS_DOC_HDR_T WHERE FDOC_DESC='IACUC Demo Committee'),'KC002','KC IACUC 1','000001','KC IACUC Demo Committee','Meets Monthly',(SELECT COMMITTEE_type_code FROM COMMITTEE_type WHERE description='IACUC'),2,22,2,NULL,1,NOW(),'admin',NOW(),'admin',0,1,UUID(),NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/

INSERT INTO COMM_MEMBERSHIPS (COMM_MEMBERSHIP_ID,COMMITTEE_ID_FK,PERSON_ID,ROLODEX_ID,PERSON_NAME,MEMBERSHIP_ID,PAID_MEMBER_FLAG,TERM_START_DATE,TERM_END_DATE,MEMBERSHIP_TYPE_CODE,COMMENTS,CONTACT_NOTES,TRAINING_NOTES,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),'10000000005',NULL,'Inez Chew',0,'Y',STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),1,NULL,NULL,NULL,NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBERSHIPS (COMM_MEMBERSHIP_ID,COMMITTEE_ID_FK,PERSON_ID,ROLODEX_ID,PERSON_NAME,MEMBERSHIP_ID,PAID_MEMBER_FLAG,TERM_START_DATE,TERM_END_DATE,MEMBERSHIP_TYPE_CODE,COMMENTS,CONTACT_NOTES,TRAINING_NOTES,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),'10000000004',NULL,'Nicholas Majors',0,'Y',STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),1,NULL,NULL,NULL,NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBERSHIPS (COMM_MEMBERSHIP_ID,COMMITTEE_ID_FK,PERSON_ID,ROLODEX_ID,PERSON_NAME,MEMBERSHIP_ID,PAID_MEMBER_FLAG,TERM_START_DATE,TERM_END_DATE,MEMBERSHIP_TYPE_CODE,COMMENTS,CONTACT_NOTES,TRAINING_NOTES,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),'10000000002',NULL,'Joe Tester',0,'Y',STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),1,NULL,NULL,NULL,NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBERSHIPS (COMM_MEMBERSHIP_ID,COMMITTEE_ID_FK,PERSON_ID,ROLODEX_ID,PERSON_NAME,MEMBERSHIP_ID,PAID_MEMBER_FLAG,TERM_START_DATE,TERM_END_DATE,MEMBERSHIP_TYPE_CODE,COMMENTS,CONTACT_NOTES,TRAINING_NOTES,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),'10000000059',NULL,'Roger Rabbit',0,'Y',STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),1,NULL,NULL,NULL,NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBERSHIPS (COMM_MEMBERSHIP_ID,COMMITTEE_ID_FK,PERSON_ID,ROLODEX_ID,PERSON_NAME,MEMBERSHIP_ID,PAID_MEMBER_FLAG,TERM_START_DATE,TERM_END_DATE,MEMBERSHIP_TYPE_CODE,COMMENTS,CONTACT_NOTES,TRAINING_NOTES,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),'10000000007',NULL,'Opal Blood',0,'Y',STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),1,NULL,NULL,NULL,NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/

INSERT INTO COMM_MEMBER_ROLES (COMM_MEMBER_ROLES_ID,VER_NBR,COMM_MEMBERSHIP_ID_FK,MEMBERSHIP_ROLE_CODE,START_DATE,END_DATE,UPDATE_TIMESTAMP,UPDATE_USER,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),0,(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000005' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),(SELECT membership_role_code FROM membership_role WHERE description='IACUC Chair'),STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),NOW(),'admin',UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBER_ROLES (COMM_MEMBER_ROLES_ID,VER_NBR,COMM_MEMBERSHIP_ID_FK,MEMBERSHIP_ROLE_CODE,START_DATE,END_DATE,UPDATE_TIMESTAMP,UPDATE_USER,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),0,(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000004' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),(SELECT membership_role_code FROM membership_role WHERE description='IACUC Admin'),STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),NOW(),'admin',UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBER_ROLES (COMM_MEMBER_ROLES_ID,VER_NBR,COMM_MEMBERSHIP_ID_FK,MEMBERSHIP_ROLE_CODE,START_DATE,END_DATE,UPDATE_TIMESTAMP,UPDATE_USER,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),0,(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000002' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),(SELECT membership_role_code FROM membership_role WHERE description='IACUC Member'),STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),NOW(),'admin',UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBER_ROLES (COMM_MEMBER_ROLES_ID,VER_NBR,COMM_MEMBERSHIP_ID_FK,MEMBERSHIP_ROLE_CODE,START_DATE,END_DATE,UPDATE_TIMESTAMP,UPDATE_USER,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),0,(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000059' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),(SELECT membership_role_code FROM membership_role WHERE description='IACUC Member'),STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),NOW(),'admin',UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBER_ROLES (COMM_MEMBER_ROLES_ID,VER_NBR,COMM_MEMBERSHIP_ID_FK,MEMBERSHIP_ROLE_CODE,START_DATE,END_DATE,UPDATE_TIMESTAMP,UPDATE_USER,OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),0,(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000007' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),(SELECT membership_role_code FROM membership_role WHERE description='IACUC Member'),STR_TO_DATE('20120101','%Y%m%d'),STR_TO_DATE('20151231','%Y%m%d'),NOW(),'admin',UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/

INSERT INTO COMM_MEMBER_EXPERTISE (COMM_MEMBER_EXPERTISE_ID,COMM_MEMBERSHIP_ID_FK,RESEARCH_AREA_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000005' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),'000001',NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBER_EXPERTISE (COMM_MEMBER_EXPERTISE_ID,COMM_MEMBERSHIP_ID_FK,RESEARCH_AREA_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000004' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),'000001',NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBER_EXPERTISE (COMM_MEMBER_EXPERTISE_ID,COMM_MEMBERSHIP_ID_FK,RESEARCH_AREA_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000002' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),'000001',NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBER_EXPERTISE (COMM_MEMBER_EXPERTISE_ID,COMM_MEMBERSHIP_ID_FK,RESEARCH_AREA_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000059' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),'000001',NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_MEMBER_EXPERTISE (COMM_MEMBER_EXPERTISE_ID,COMM_MEMBERSHIP_ID_FK,RESEARCH_AREA_CODE,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID)
VALUES((SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT COMM_MEMBERSHIP_ID FROM COMM_MEMBERSHIPS WHERE PERSON_ID='10000000007' AND COMMITTEE_ID_FK=(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002')),'000001',NOW(),'admin',0,UUID())
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/

INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20120709','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20120707','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20120813','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20120811','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20120910','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20120908','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20121008','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20121006','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20121112','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20121110','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20121210','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20121208','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20130114','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20130112','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20130211','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20130209','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20130311','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20130309','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20130408','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20130406','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20130513','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20130511','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20130610','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20130608','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20130708','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20130706','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20130812','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20130810','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20130909','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20130907','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20131014','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20131012','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20131111','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20131109','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20131209','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20131207','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20140113','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20140111','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20140210','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20140208','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20140310','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20140308','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20140414','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20140412','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20140512','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20140510','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20140609','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20140607','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20140714','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20140712','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20140811','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20140809','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20140908','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20140906','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20141013','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20141011','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20141110','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20141108','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20141208','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20141206','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20150112','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20150110','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20150209','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20150207','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20150309','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20150307','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20150413','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20150411','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20150511','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20150509','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20150608','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20150606','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20150713','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20150711','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20150810','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20150808','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20150914','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20150912','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20151012','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20151010','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20151109','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20151107','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO SEQ_COMMITTEE_ID VALUES(NULL)
/
INSERT INTO COMM_SCHEDULE (ID,SCHEDULE_ID,COMMITTEE_ID_FK,SCHEDULED_DATE,PLACE,TIME,PROTOCOL_SUB_DEADLINE,SCHEDULE_STATUS_CODE,MEETING_DATE,START_TIME,END_TIME,AGENDA_PROD_REV_DATE,MAX_PROTOCOLS,COMMENTS,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,AVAILABLE_TO_REVIEWERS)
VALUES((SELECT (MAX(ID) - 1 ) FROM SEQ_COMMITTEE_ID),(SELECT (MAX(ID)) FROM SEQ_COMMITTEE_ID),(SELECT ID FROM COMMITTEE WHERE COMMITTEE_ID='KC002'),STR_TO_DATE('20151214','%Y%m%d'),'CR 101',STR_TO_DATE('197001011200','%Y%m%d%H%i'),STR_TO_DATE('20151212','%Y%m%d'),(SELECT SCHEDULE_STATUS_CODE FROM SCHEDULE_STATUS WHERE DESCRIPTION = 'Scheduled'),NULL,STR_TO_DATE('19700101','%Y%m%d'),STR_TO_DATE('19700101','%Y%m%d'),NULL,22,NULL,NOW(),'quickstart',0,UUID(),'N')
/


DELIMITER ;
