/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc;

public class CliOptions {
    private String[] args;

    public CliOptions(String[] args) {
        this.args = args;
    }

    public boolean isValid() {
        boolean valid;
        boolean bl = valid = this.args != null && this.args.length > 0;
        if (valid && (this.containsHelp() || this.containsVersion())) {
            return true;
        }
        if (valid && (this.inactivateCleanupPolicy() || this.deleteCleanupPolicy())) {
            valid = true;
        }
        if (valid && this.containsValidate() && !"".equals(this.getCoeusConnectionString()) && !"".equals(this.getRiceConnectionString())) {
            return true;
        }
        return valid && this.containsNormalMigrationTarget() && !"".equals(this.getCoeusConnectionString()) && !"".equals(this.getRiceConnectionString());
    }

    public boolean containsNormalMigrationTarget() {
        return this.containsProposalPersonRole() || this.containsProposal() || this.containsQuestSeq() || this.containsAwardUpdateUser() || this.containsIpUpdateUser() || this.containsSubawardUpdateUser() || this.containsTmUpdateUser() || this.containsTimeAndMoneyDocStatus() || this.containsSubawardAmountInfo() || this.containsProposalYnq() || this.containsProposalPersonNames() || this.containsTimeAndMoneyDups() || this.containsSubawardStatus();
    }

    public boolean containsHelp() {
        return this.contains("-help");
    }

    public boolean containsVersion() {
        return this.contains("-version");
    }

    public boolean containsDebug() {
        return this.contains("-debug");
    }

    public boolean containsDryRun() {
        return this.contains("-dryrun");
    }

    public boolean containsValidate() {
        return this.contains("-validate");
    }

    public boolean containsProposalPersonRole() {
        return this.contains("pprole");
    }

    public boolean containsProposal() {
        return this.contains("proposal");
    }

    public boolean containsQuestSeq() {
        return this.contains("questseq");
    }

    public boolean containsQuestReseq() {
        return this.contains("questreseq");
    }

    public boolean containsTimeAndMoneyDocStatus() {
        return this.contains("tmdocstatus");
    }

    public boolean containsSubawardAmountInfo() {
        return this.contains("subaward-amountinfo");
    }

    public boolean containsTimeAndMoneyDups() {
        return this.contains("tm-dups");
    }

    public boolean containsProposalYnq() {
        return this.contains("proposal-ynq");
    }

    public boolean containsProposalPersonNames() {
        return this.contains("proposal-person-names");
    }

    public boolean containsAwardUpdateUser() {
        return this.contains("award-updateuser");
    }

    public boolean containsIpUpdateUser() {
        return this.contains("ip-updateuser");
    }

    public boolean containsSubawardUpdateUser() {
        return this.contains("subaward-updateuser");
    }

    public boolean containsSubawardStatus() {
        return this.contains("subaward-status");
    }

    public boolean containsTmUpdateUser() {
        return this.contains("tm-updateuser");
    }

    public boolean containsSubawardTmplAttach() {
        return this.contains("subaward-tmpl-attach");
    }

    private boolean contains(String name) {
        for (String arg : this.args) {
            if (!name.equals(arg)) continue;
            return true;
        }
        return false;
    }

    private String nextArg(String name) {
        boolean returnNext = false;
        for (String arg : this.args) {
            if (returnNext) {
                return arg;
            }
            if (!name.equals(arg)) continue;
            returnNext = true;
        }
        return "";
    }

    public String getCoeusConnectionString() {
        if (this.contains("-dbcoeuscon")) {
            return this.nextArg("-dbcoeuscon");
        }
        return "";
    }

    public String getRiceConnectionString() {
        if (this.contains("-dbricecon")) {
            return this.nextArg("-dbricecon");
        }
        return "";
    }

    public String getCoeusUser() {
        if (this.contains("-dbcoeususer")) {
            return this.nextArg("-dbcoeususer");
        }
        return "";
    }

    public String getCoeusPassword() {
        if (this.contains("-dbcoeuspwd")) {
            return this.nextArg("-dbcoeuspwd");
        }
        return "";
    }

    public String getRiceUser() {
        if (this.contains("-dbriceuser")) {
            return this.nextArg("-dbriceuser");
        }
        return "";
    }

    public String getRicePassword() {
        if (this.contains("-dbricepwd")) {
            return this.nextArg("-dbricepwd");
        }
        return "";
    }

    public String getCleanupPolicy() {
        if (this.contains("-cleanup")) {
            return this.nextArg("-cleanup");
        }
        return "inactivate";
    }

    public boolean deleteCleanupPolicy() {
        return this.getCleanupPolicy().equals("delete");
    }

    public boolean inactivateCleanupPolicy() {
        return this.getCleanupPolicy().equals("inactivate");
    }

    public boolean isMySql() {
        if (this.contains("-platform") && "MySql".equalsIgnoreCase(this.nextArg("-platform"))) {
            return true;
        }
        if (this.contains("-dbricecon") && (this.nextArg("-dbricecon").startsWith("jdbc:mysql") || this.nextArg("-dbricecon").startsWith("jdbc:mariadb"))) {
            return true;
        }
        return this.contains("-dbcoeuscon") && (this.nextArg("-dbcoeuscon").startsWith("jdbc:mysql") || this.nextArg("-dbcoeuscon").startsWith("jdbc:mariadb"));
    }

    public boolean isOracle() {
        if (this.contains("-platform") && "Oracle".equalsIgnoreCase(this.nextArg("-platform"))) {
            return true;
        }
        if (this.contains("-dbricecon") && this.nextArg("-dbricecon").startsWith("jdbc:oracle")) {
            return true;
        }
        return this.contains("-dbcoeuscon") && this.nextArg("-dbcoeuscon").startsWith("jdbc:oracle");
    }

    public String getCliHelpString() {
        return "coeus-data-conv [options] [conv_target [conv_target2 [conv_target3] ...]]\n  Options:\n  -help                    print this message\n  -version                 print the version information and exit\n  -dryrun                  executes conversion without writing out to the database\n  -validate                validates database connections only\n  -debug                   print debugging information\n  -cleanup <policy>        the policy used for data cleanup (delete|inactivate)\n  -dbplatform <platform>   the database platform (MySql|Oracle)\n  -dbricecon <connection>  the kuali rice jdbc database connection string (jdbc:mysql://localhost/rice?permitMysqlScheme&user=usr&password=pwd)\n  -dbcoeuscon <connection> the kuali coeus jdbc database connection string (jdbc:mysql://localhost/coeus?permitMysqlScheme&user=usr&password=pwd)\n  -dbriceuser <ricedbuser>  the kuali rice database user\n  -dbricepwd <ricerbpassword> the kuali rice database password\n  -dbcoeususer <coeususer>  the kuali coeus database user\n  -dbcoeuspwd <coeuspassword> the kuali coeus database password\n\nIf platform is not specified then the platform will be autodetected from the connection strings.\n\nThe valid conversion targets are (proposal|pprole|questseq|tmdocstatus|subaward-amountinfo|tm-dups|award-updateuser|ip-updateuser|subaward-updateuser|tm-updateuser|proposal-ynq|proposal-person-names|subaward-status).\n\nThe dryrun flag may still cause database sequences to increment.\n\nThe cleanup flag when choosing inactivate will attempt to set the active flag to false when possible.  This is the default. ";
    }
}

