-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE (QUESTIONNAIRE_REF_ID,QUESTIONNAIRE_ID,SEQUENCE_NUMBER,NAME,DESCRIPTION,UPDATE_TIMESTAMP,UPDATE_USER,IS_FINAL,VER_NBR,OBJ_ID,FILE_NAME)
values ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), -11,1,'ED524 Budget V-1.4 Questions','These questions support ED524 Budget V-1.4 forms.',NOW(), 'admin','Y',1,UUID(),null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTION (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,
MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER)
values ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),-10146,1,'C','Do the instructions for this project indicate this is a training program?','I',4,1,null,null,null,1,1,NOW(),'admin',1,UUID(),null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM  SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'ED524 Budget V-1.4 Questions' AND SEQUENCE_NUMBER = 1),
(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION_ID = -10120),1,0,1,'N',null,null,'admin',NOW(),UUID(),1);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,QUESTION_SEQ_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ((SELECT (MAX(ID)) FROM  SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE NAME = 'ED524 Budget V-1.4 Questions' AND SEQUENCE_NUMBER = 1),
(SELECT max(QUESTION_REF_ID) FROM QUESTION WHERE QUESTION_ID = -10146),2,0,1,'N',null,null,'admin',NOW(),UUID(),1);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID,MODULE_ITEM_CODE,MODULE_SUB_ITEM_CODE,QUESTIONNAIRE_REF_ID_FK,QUESTIONNAIRE_SEQUENCE_NUMBER,RULE_ID,QUESTIONNAIRE_LABEL,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,IS_MANDATORY)
values ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID) ,3,(SELECT SUB_MODULE_CODE FROM COEUS_SUB_MODULE WHERE DESCRIPTION = 'S2S Questionnaires'),
(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -11 AND SEQUENCE_NUMBER = 1), 1,null,'ED524 Budget V-1.4 Questionnaire',NOW(),'admin',1,UUID(),'N');

insert into SEQ_QUESTIONNAIRE_REF_ID values (NULL);
insert into s2s_form_to_questionnaire(S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES ((select max(id) from SEQ_QUESTIONNAIRE_REF_ID), 'http://apply.grants.gov/forms/ED_524_Budget_1_4-V1.4', 'ED_524_Budget_1_4-V1.4',
(select questionnaire_id from questionnaire where questionnaire_id = -11), NOW(), 'admin', UUID(), '1');

INSERT INTO SEQ_S2S_FORM_CONFIG_ID VALUES (NULL);
INSERT INTO S2S_FORM_CONFIG (S2S_FORM_CONFIG_ID, FORM_NAME, ACTIVE_FLAG, INACTIVE_MESSAGE, VER_NBR, OBJ_ID, UPDATE_TIMESTAMP, UPDATE_USER)
VALUES ((SELECT MAX(id) FROM SEQ_S2S_FORM_CONFIG_ID), 'ED_524_Budget_1_4-V1.4', 'N', 'Form ED_524_Budget_1_4-V1.4 is still undergoing testing. Expect it to be available soon.', '1', UUID(), NOW(), 'admin');

alter table ORGANIZATION_IDC add column TRAINING_RATE_POLICY varchar(3);

