-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

-- Proposal development

insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values ('RES-BOOT10043', 'KC-PD', 'specialReviewAndApprovalTypeRule', 'Check proposal contains given special review type and approval type', 'java.lang.Boolean', 'KC1006', 'Y', 1);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10075', 'DevelopmentProposal', 'Development Proposal BO', 'org.kuali.coeus.propdev.impl.core.DevelopmentProposal',  'RES-BOOT10043', 1);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10076', 'Special Review Type Code', 'Special Review Type Code', 'java.lang.String', 'RES-BOOT10043', 2);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10077', 'Approval Type Code', 'Approval Type Code', 'java.lang.String', 'RES-BOOT10043', 3);

insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values ('RES-BOOT2126', 'RES-BOOT10043', 'java.lang.Boolean', 'Y', 1, 'Check proposal contains given special review type and approval type', 'KC-PD');

insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values ('RES-BOOT2113', 'KC-PD', 'Special Review Type and Approval Type Resolver', 'KC1001', 'RES-BOOT2126', 'Y', 1);

insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values ('RES-BOOT2102', 'RES-BOOT2113', 'Special Review Type Code', 1);

insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values ('RES-BOOT2103', 'RES-BOOT2113', 'Approval Type Code', 1);

insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values ('RES-BOOT1066', 'KC-PD-CONTEXT', 'RES-BOOT2126', 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values ('RES-BOOT2126', 'KC1001');


-- Award
insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values ('RES-BOOT10044', 'KC-AWARD', 'specialReviewAndApprovalTypeRule', 'Check award contains given special review type and approval type', 'java.lang.Boolean', 'KC10001', 'Y', 1);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10078', 'award', 'Award BO', 'org.kuali.kra.award.home.Award',  'RES-BOOT10044', 1);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10079', 'Special Review Type Code', 'Special Review Type Code', 'java.lang.String', 'RES-BOOT10044', 2);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10080', 'Approval Type Code', 'Approval Type Code', 'java.lang.String', 'RES-BOOT10044', 3);

insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values ('RES-BOOT2127', 'RES-BOOT10044', 'java.lang.Boolean', 'Y', 1, 'Check award contains given special review type and approval type', 'KC-AWARD');

insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values ('RES-BOOT2114', 'KC-AWARD', 'Special Review Type and Approval Type Resolver', 'KC1001', 'RES-BOOT2127', 'Y', 1);

insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values ('RES-BOOT2104', 'RES-BOOT2114', 'Special Review Type Code', 1);

insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values ('RES-BOOT2105', 'RES-BOOT2114', 'Approval Type Code', 1);

insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values ('RES-BOOT1067', 'KC-AWARD-CONTEXT', 'RES-BOOT2127', 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values ('RES-BOOT2127', 'KC1010');

-- Institutional Proposal
insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values ('RES-BOOT10045', 'KC-IP', 'specialReviewAndApprovalTypeRule', 'Check Institutional Proposal contains given special review type and approval type', 'java.lang.Boolean', 'RES-BOOT10002', 'Y', 1);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10081', 'InstitutionalProposal', 'Institutional Proposal BO', 'org.kuali.kra.institutionalproposal.home.InstitutionalProposal',  'RES-BOOT10045', 1);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10082', 'Special Review Type Code', 'Special Review Type Code', 'java.lang.String', 'RES-BOOT10045', 2);

insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values ('RES-BOOT10083', 'Approval Type Code', 'Approval Type Code', 'java.lang.String', 'RES-BOOT10045', 3);

insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values ('RES-BOOT2128', 'RES-BOOT10045', 'java.lang.Boolean', 'Y', 1, 'Check Institutional Proposal contains given special review type and approval type', 'KC-IP');

insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values ('RES-BOOT2115', 'KC-IP', 'Special Review Type and Approval Type Resolver', 'KC1001', 'RES-BOOT2128', 'Y', 1);

insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values ('RES-BOOT2106', 'RES-BOOT2115', 'Special Review Type Code', 1);

insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values ('RES-BOOT2107', 'RES-BOOT2115', 'Approval Type Code', 1);

insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values ('RES-BOOT1068', 'KC-IP-CONTEXT', 'RES-BOOT2128', 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values ('RES-BOOT2128', 'KC1016');
