-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
INSERT INTO SEQ_SPONSOR_FORM_TEMPLATES VALUES(NULL)
/
INSERT INTO SPONSOR_FORM_TEMPLATES (SPONSOR_FORM_TEMPLATE_ID,SPONSOR_FORM_ID,PAGE_NUMBER,PAGE_DESCRIPTION,FILE_NAME,CONTENT_TYPE,FORM_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) 
VALUES ((SELECT (MAX(ID)) FROM SEQ_SPONSOR_FORM_TEMPLATES),(SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE PACKAGE_NAME = 'NIH 398 package (Coeus 4.0)'),12,'Detailed Budget Period 1','Detailed Budget Period 1.xslt','text/xml',
'<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://era.nih.gov/Projectmgmt/SBIR/CGAP/common.namespace" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:nih="http://era.nih.gov/Projectmgmt/SBIR/CGAP/nihspecific.namespace" xmlns:phs398="http://era.nih.gov/Projectmgmt/SBIR/CGAP/phs398.namespace" xmlns:rar="http://era.nih.gov/Projectmgmt/SBIR/CGAP/researchandrelated.namespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
<xsl:param name="SV_OutputFormat" select="''PDF''"/>
<xsl:variable name="XML" select="/"/>
<xsl:variable name="fo:layout-master-set">
<fo:layout-master-set>
<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.3in" margin-right="0.3in">
<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
<fo:region-after extent="0.79in"/>
</fo:simple-page-master>
</fo:layout-master-set>
</xsl:variable>
<xsl:template match="/">
<fo:root>
<xsl:copy-of select="$fo:layout-master-set"/>
<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
<xsl:call-template name="footerall"/>
<fo:flow flow-name="xsl-region-body">
<fo:block>
<xsl:for-each select="$XML">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block border-left-style="none" border-right-style="none" border-top-style="none" line-height="12pt" text-align="center" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Principal Investigator/Program Director (Last, first, middle) :</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/SalariesAndWages/Name/LastName[../../ProjectRole =&quot;PI/PD&quot;][../../../BudgetPeriodID=1]"/>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text> , </xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod/SalariesAndWages/Name/FirstName[../../ProjectRole =&quot;PI/PD&quot;][../../../BudgetPeriodID=1]"/>
</fo:inline>
</fo:block>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table border-collapse="collapse" line-height="20pt" table-layout="fixed" width="100%" border="solid 1pt gray">
<fo:table-column column-width="4.5in"/>
<fo:table-column column-width="1.75in"/>
<fo:table-column column-width="1.75in"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="9pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block border-left-color="white" border-left-style="none" font-family="Verdana" font-size="9pt" text-align="center" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
<xsl:text>DETAILED BUDGET FOR INITIAL BUDGET PERIOD</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
<xsl:text>DIRECT COSTS ONLY</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" display-align="before">
<fo:block>
<fo:inline font-family="Verdana">
<xsl:text>From </xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="StartDate">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" display-align="before">
<fo:block>
<fo:inline font-family="Verdana">
<xsl:text>Through</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="EndDate">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block text-align="center" margin="0pt">
<fo:block>
<xsl:if test="count(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/SalariesAndWages/Name ) &lt; 8">
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:if test="BudgetPeriod/BudgetPeriodID =1">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="SalariesAndWages">
<fo:table border-collapse="collapse" line-height="20pt" table-layout="fixed" width="100%" border="solid 1pt gray">
<fo:table-column column-width="2.1in"/>
<fo:table-column column-width="1in"/>
<fo:table-column column-width=".42in"/>
<fo:table-column column-width=".44in"/>
<fo:table-column column-width=".48in"/>
<fo:table-column column-width=".7in"/>
<fo:table-column column-width=".95in"/>
<fo:table-column column-width=".95in"/>
<fo:table-column column-width=".95in"/>
<fo:table-header start-indent="0pt">
<fo:table-row>
<fo:table-cell border-top-style="none" line-height="9pt" number-columns-spanned="2" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>PERSONNEL(Applicant organization only)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" line-height="9pt" number-rows-spanned="2" border="solid 1pt gray" padding="5" text-align="left" display-align="before">
<fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell border-left-width="0" border-right-width="0" border-top-width="0" border="solid 1pt gray" padding="2pt" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="6pt">
<xsl:text>Months</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:block/>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Cal. Mnths</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" line-height="9pt" number-rows-spanned="2" border="solid 1pt gray" padding="5" text-align="left" display-align="before">
<fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell border-left-width="0" border-right-width="0" border-top-width="0" border="solid 1pt gray" padding="2pt" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="6pt">
<xsl:text>Devoted </xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:block/>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Acad. Mnths</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" font-family="Verdana" line-height="9pt" margin-left="0" margin-right="0" padding-left="0" padding-right="0" number-rows-spanned="2" border="solid 1pt gray" padding="5" text-align="left" display-align="before">
<fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell border-left-width="0" border-right-width="0" border-top-width="0" font-family="Verdana" margin-right="0" padding-left="0" padding-right="0" border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="6pt">
<xsl:text> to Project</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:block/>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Sum. mnths</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" line-height="9pt" number-rows-spanned="2" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>INST.</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>BASE</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>SALARY</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>DOLLAR AMOUNT REQUESTED (omit cents)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>NAME</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>ROLE ON</xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>PROJECT</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>SALARY</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>REQUESTED</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>FRINGE</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>BENEFITS</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>TOTALS</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-header>
<fo:table-body start-indent="0pt">
<xsl:for-each select="SalariesAndWages">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<xsl:for-each select="Name">
<xsl:for-each select="LastName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="8pt">
<xsl:text>, </xsl:text>
</fo:inline>
<xsl:for-each select="Name">
<xsl:for-each select="FirstName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="Name">
<xsl:for-each select="MiddleName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<xsl:for-each select="ProjectRole">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<xsl:for-each select="FundingMonths">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<xsl:for-each select="AcademicFundingMonths">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<xsl:for-each select="SummerFundingMonths">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:if test="BaseSalary != 0">
<xsl:for-each select="BaseSalary">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</fo:block>
</fo:table-cell>
<fo:table-cell border-bottom-style="none" font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="RequestedCost">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell border-bottom-style="none" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="FringeCost">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell border-bottom-style="none" font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="format-number(number(RequestedCost + FringeCost), ''#,###,###,##0'')"/>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:if>
<xsl:if test="count(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/SalariesAndWages/Name ) &gt;=8">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table line-height="20pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
<fo:table-column column-width="2.1in"/>
<fo:table-column column-width="1in"/>
<fo:table-column column-width=".4in"/>
<fo:table-column column-width=".4in"/>
<fo:table-column column-width=".4in"/>
<fo:table-column column-width=".8in"/>
<fo:table-column column-width=".95in"/>
<fo:table-column column-width=".95in"/>
<fo:table-column column-width=".95in"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell border-top-style="none" font-family="Verdana" font-size="8pt" number-columns-spanned="2" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>PERSONNEL (Applicant organization only)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" font-family="Verdana" font-size="8pt" number-rows-spanned="2" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Cal.</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline>
<xsl:text>Mnths</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" font-family="Verdana" font-size="8pt" number-rows-spanned="2" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Acad.</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline>
<xsl:text>Mnths</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" font-family="Verdana" font-size="8pt" number-rows-spanned="2" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>Sum.</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline>
<xsl:text>Mnths</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" font-family="Verdana" font-size="8pt" number-rows-spanned="2" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>INST.</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>BASE</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>SALARY</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell border-top-style="none" font-family="Verdana" font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>DOLLAR AMOUNT REQUESTED (omit cents)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>NAME</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>ROLE ON </xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>PROJECT</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>SALARY</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>REQUESTED</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>FRINGE</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline>
<xsl:text>BENEFITS</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>TOTALS</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="9pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>See attached.</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="0" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
</xsl:if>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table border-collapse="collapse" line-height="20pt" table-layout="fixed" width="100%" border="solid 1pt gray">
<fo:table-column column-width="2.1in"/>
<fo:table-column column-width="3.05in"/>
<fo:table-column column-width=".95in"/>
<fo:table-column column-width=".95in"/>
<fo:table-column column-width=".95in"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell border-right-style="none" border-top-style="none" font-size="8pt" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block/>
</fo:table-cell>
<fo:table-cell border-left-style="none" border-top-style="none" font-size="8pt" line-height="10pt" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>SUBTOTALS-----------------------------------------&gt;</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-bottom-width="thick" border-left-width="thick" border-top-width="thick" font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/SalariesAndWages/RequestedCost )), ''#,###,###,##0'')"/>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-bottom-width="thick" border-top-width="thick" font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/SalariesAndWages/FringeCost )), ''#,###,###,##0'')"/>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-bottom-width="thick" border-top-width="thick" font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =1">
<xsl:for-each select="SalariesWagesTotal">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="4" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>CONSULTANT COSTS</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="rar:OtherDirectCosts">
<xsl:if test="Type =&apos;Consultant Costs&apos;">
<xsl:for-each select="Cost">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="4" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>EQUIPMENT (</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-style="italic">
<xsl:text>Itemize</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>)&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =1">
<xsl:for-each select="rar:EquipmentCosts">
<fo:inline font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="EquipmentDescription">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="EquipmentTotal">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="4" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>SUPPLIES (</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-style="italic">
<xsl:text>Itemize by category</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>)&#160; </xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="rar:OtherDirectCosts">
<xsl:if test="Type =&apos;Materials and Supplies&apos;">
<xsl:for-each select="Description">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="rar:OtherDirectCosts">
<xsl:if test="Type =&apos;Materials and Supplies&apos;">
<xsl:for-each select="Cost">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="8pt" number-columns-spanned="4" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>TRAVEL</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="TravelTotal">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="8pt" number-rows-spanned="2" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>PATIENT CARE COSTS</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>INPATIENT</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="rar:ParticipantPatientCosts">
<xsl:if test="Type=&apos;Inpatient&apos;">
<xsl:for-each select="Cost">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>OUTPATIENT</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="rar:ParticipantPatientCosts">
<xsl:if test="Type=&apos;Outpatient&apos;">
<xsl:for-each select="Cost">
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="4" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>ALTERATIONS AND RENOVATIONS(</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-style="italic">
<xsl:text>Itemize by category</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="rar:OtherDirectCosts">
<xsl:if test="Type=&apos;Alterations and Renovations&apos;">
<xsl:for-each select="Cost">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="8pt" number-columns-spanned="4" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>OTHER EXPENSES (</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt" font-style="italic">
<xsl:text>Itemize by category</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>)</xsl:text>
</fo:inline>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID =1">
<xsl:for-each select="rar:OtherDirectCosts">
<fo:inline font-size="8pt">
<xsl:text>&#160;&#160; </xsl:text>
</fo:inline>
<xsl:if test="Type =&apos;Other Direct Costs&apos;">
<xsl:for-each select="Description">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:if>
<fo:inline font-size="8pt">
<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline>
<xsl:value-of select="format-number(number(sum(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/rar:OtherDirectCosts[Type=&apos;Other Direct Costs&apos;]/Cost )), ''#,###,###,##0'')"/>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="2" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>CONSORITUM/CONTRACTUAL COSTS</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="2" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>DIRECT COSTS</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="ConsortiumCosts">
<xsl:for-each select="DirectCosts">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>SUBTOTAL DIRECT COSTS FOR INITIAL BUDGET PERIOD(Item 7a, Face Page)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-width="thick" font-family="Verdana" font-size="8pt" number-columns-spanned="2" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:value-of select="format-number(number(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/PeriodDirectCostsTotal - nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/ConsortiumCosts/IndirectCosts), ''#,###,###,##0'')"/>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="2" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>CONSORTIUM/CONTRACTUAL COSTS</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" number-columns-spanned="2" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<fo:inline>
<xsl:text>FACILITIES AND ADMINISTRATION COSTS</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="ConsortiumCosts">
<xsl:for-each select="IndirectCosts">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell font-size="8pt" number-columns-spanned="3" border="solid 1pt gray" padding="5" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>TOTAL DIRECT COSTS FOR INITIAL BUDGET PERIOD </xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell border-width="thick" font-family="Verdana" font-size="8pt" number-columns-spanned="2" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="PeriodDirectCostsTotal">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
</fo:block>
</fo:block>
<xsl:if test="count(nih:ResearchAndRelatedProject/BudgetSummary/BudgetPeriod[BudgetPeriodID=1]/SalariesAndWages/Name ) &gt;=8">
<fo:block break-after="page">
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table border-collapse="collapse" line-height="20pt" page-break-after="always" table-layout="fixed" width="100%" border="solid 1pt gray">
<fo:table-column column-width="4.5in"/>
<fo:table-column column-width="1.75in"/>
<fo:table-column column-width="1.75in"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="9pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block border-left-color="white" border-left-style="none" font-family="Verdana" font-size="9pt" text-align="center" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
<xsl:text>DETAILED BUDGET FOR INITIAL BUDGET PERIOD</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-family="Verdana" font-size="9pt" font-weight="bold">
<xsl:text>DIRECT COSTS ONLY</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" display-align="before">
<fo:block>
<fo:inline font-family="Verdana">
<xsl:text>From</xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="StartDate">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" display-align="before">
<fo:block>
<fo:inline font-family="Verdana">
<xsl:text>Through</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<xsl:for-each select="EndDate">
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
<xsl:text>/</xsl:text>
<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block text-align="center" margin="0pt">
<fo:block/>
</fo:block>
<xsl:for-each select="nih:ResearchAndRelatedProject">
<xsl:for-each select="BudgetSummary">
<xsl:if test="BudgetPeriod/BudgetPeriodID =1">
<xsl:for-each select="BudgetPeriod">
<xsl:if test="BudgetPeriodID=1">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<xsl:if test="SalariesAndWages">
<fo:table border-collapse="collapse" line-height="20pt" table-layout="fixed" width="100%" border="solid 1pt gray">
<fo:table-column column-width="2.1in"/>
<fo:table-column column-width="1in"/>
<fo:table-column column-width=".42in"/>
<fo:table-column column-width=".41in"/>
<fo:table-column column-width=".41in"/>
<fo:table-column column-width=".8in"/>
<fo:table-column column-width=".95in"/>
<fo:table-column column-width=".95in"/>
<fo:table-column column-width=".95in"/>
<fo:table-header start-indent="0pt">
<fo:table-row>
<fo:table-cell line-height="9pt" number-columns-spanned="2" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>PERSONNEL(Applicant organization only)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-rows-spanned="2" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Cal.</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Mnths</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-rows-spanned="2" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Acad.</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Mnths</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-rows-spanned="2" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Sum.</xsl:text>
</fo:inline>
<fo:block/>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Mnths</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-rows-spanned="2" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>INST.</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>BASE</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>SALARY</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" number-columns-spanned="3" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>DOLLAR AMOUNT REQUESTED (omit cents)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>NAME</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>ROLE ON</xsl:text>
</fo:inline>
<fo:block/>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>PROJECT</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>SALARY</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>REQUESTED</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>FRINGE</xsl:text>
</fo:inline>
<fo:block>
<fo:leader leader-pattern="space"/>
</fo:block>
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:block line-height="9pt" margin="0pt">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>BENEFITS</xsl:text>
</fo:inline>
</fo:block>
</fo:block>
</fo:block>
</fo:table-cell>
<fo:table-cell line-height="9pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>TOTALS</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-header>
<fo:table-body start-indent="0pt">
<xsl:for-each select="SalariesAndWages">
<fo:table-row>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<xsl:for-each select="Name">
<xsl:for-each select="LastName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="8pt">
<xsl:text>, </xsl:text>
</fo:inline>
<xsl:for-each select="Name">
<xsl:for-each select="FirstName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
<fo:inline font-size="8pt">
<xsl:text>&#160;</xsl:text>
</fo:inline>
<xsl:for-each select="Name">
<xsl:for-each select="MiddleName">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="9pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" display-align="center">
<fo:block>
<xsl:for-each select="ProjectRole">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block font-family="Verdana" font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<xsl:for-each select="FundingMonths">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<xsl:for-each select="AcademicFundingMonths">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="center" display-align="center">
<fo:block>
<xsl:for-each select="SummerFundingMonths">
<xsl:variable name="value-of-template">
<xsl:apply-templates/>
</xsl:variable>
<xsl:choose>
<xsl:when test="contains(string($value-of-template),''&#x2029;'')">
<fo:block>
<xsl:copy-of select="$value-of-template"/>
</fo:block>
</xsl:when>
<xsl:otherwise>
<fo:inline>
<xsl:copy-of select="$value-of-template"/>
</fo:inline>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:if test="BaseSalary != 0">
<xsl:for-each select="BaseSalary">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</xsl:if>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="RequestedCost">
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<xsl:for-each select="FringeCost">
<fo:inline font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="format-number(number(string(.)), ''#,###,###,##0'')"/>
</fo:inline>
</xsl:for-each>
</fo:block>
</fo:table-cell>
<fo:table-cell font-family="Verdana" font-size="8pt" border="solid 1pt gray" padding="5" text-align="right" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>$</xsl:text>
</fo:inline>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:value-of select="format-number(number(RequestedCost + FringeCost), ''#,###,###,##0'')"/>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</xsl:for-each>
</fo:table-body>
</fo:table>
</xsl:if>
</xsl:if>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</xsl:for-each>
</xsl:if>
</xsl:for-each>
</fo:block>
<fo:block id="SV_RefID_PageTotal"/>
</fo:flow>
</fo:page-sequence>
</fo:root>
</xsl:template>
<xsl:template name="footerall">
<fo:static-content flow-name="xsl-region-after">
<fo:block>
<xsl:for-each select="$XML">
<fo:inline-container>
<fo:block>
<xsl:text>&#x2029;</xsl:text>
</fo:block>
</fo:inline-container>
<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
<fo:table-column column-width="276"/>
<fo:table-column column-width="proportional-column-width(1)"/>
<fo:table-column column-width="150"/>
<fo:table-body start-indent="0pt">
<fo:table-row>
<fo:table-cell padding="0" number-columns-spanned="3" height="30" display-align="center">
<fo:block/>
</fo:table-cell>
</fo:table-row>
<fo:table-row>
<fo:table-cell padding="0" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>PHS 398 (Rev. 11/07)</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="0" text-align="left" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Page: __</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
<fo:table-cell padding="0" text-align="right" display-align="center">
<fo:block>
<fo:inline font-family="Verdana" font-size="8pt">
<xsl:text>Form Page 4</xsl:text>
</fo:inline>
</fo:block>
</fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
</xsl:for-each>
</fo:block>
</fo:static-content>
</xsl:template>
<xsl:template name="double-backslash">
<xsl:param name="text"/>
<xsl:param name="text-length"/>
<xsl:variable name="text-after-bs" select="substring-after($text, '''')"/>
<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
<xsl:choose>
<xsl:when test="$text-after-bs-length = 0">
<xsl:choose>
<xsl:when test="substring($text, $text-length) = ''''">
<xsl:value-of select="concat(substring($text,1,$text-length - 1), \'\'\\\'\')"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$text"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), \'\'\\\'\')"/>
<xsl:call-template name="double-backslash">
<xsl:with-param name="text" select="$text-after-bs"/>
<xsl:with-param name="text-length" select="$text-after-bs-length"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
</xsl:stylesheet>','admin',NOW(),UUID(),1)
/
DELIMITER ;
