/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.dao.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.timeandmoney.dao.TimeAndMoneyDao;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TimeAndMoneyActionSummary;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.history.TransactionDetailType;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TimeAndMoneyDaoOjb
extends PlatformAwareDaoBaseOjb
implements TimeAndMoneyDao {
    private static final String DOCUMENT_STATUS = "documentStatus";
    private static final String AWARD_AMOUNT_INFOS_AWARD_ID = "awardAmountInfos.awardId";
    private static final String SUMMARY_SQL_QUERY;
    public static final String TIME_AND_MONEY_DOCUMENT_NUMBER = "timeAndMoneyDocumentNumber";
    public static final String TRANSACTION_DETAIL_TYPE = "transactionDetailType";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public List<TimeAndMoneyActionSummary> buildTimeAndMoneyActionSummaryForAward(String awardNumber) {
        ArrayList<TimeAndMoneyActionSummary> summaryItems = new ArrayList<TimeAndMoneyActionSummary>();
        PersistenceBroker pbInstance = this.getPersistenceBroker(true);
        try (PreparedStatement stmt = pbInstance.serviceConnectionManager().getConnection().prepareStatement(SUMMARY_SQL_QUERY);){
            stmt.setString(1, awardNumber);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    TimeAndMoneyActionSummary timeAndMoneyActionSummary = new TimeAndMoneyActionSummary();
                    timeAndMoneyActionSummary.setNoticeDate(rs.getDate(1));
                    timeAndMoneyActionSummary.setTransactionType(rs.getString(2));
                    if (rs.getObject(5) != null) {
                        timeAndMoneyActionSummary.setChangeAmount(new ScaleTwoDecimal((BigDecimal)rs.getObject(5)));
                    }
                    if (rs.getObject(6) != null) {
                        timeAndMoneyActionSummary.setObligationCumulative(new ScaleTwoDecimal((BigDecimal)rs.getObject(6)));
                    }
                    timeAndMoneyActionSummary.setObligationEndDate(rs.getDate(7));
                    timeAndMoneyActionSummary.setObligationStartDate(rs.getDate(8));
                    summaryItems.add(timeAndMoneyActionSummary);
                }
            }
        }
        catch (SQLException | LookupException e) {
            throw new RuntimeException(e);
        }
        return summaryItems;
    }

    @Override
    public List<TimeAndMoneyDocument> getTimeAndMoneyDocumentForAwards(List<Long> awardIds) {
        Criteria crit = new Criteria();
        crit.addIn(AWARD_AMOUNT_INFOS_AWARD_ID, awardIds);
        crit.addNotEqualTo((Object)DOCUMENT_STATUS, (Object)VersionStatus.CANCELED.toString());
        QueryByCriteria criteria = new QueryByCriteria(TimeAndMoneyDocument.class, crit);
        criteria.setDistinct(true);
        ArrayList<TimeAndMoneyDocument> docs = new ArrayList<TimeAndMoneyDocument>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)criteria));
        return docs;
    }

    @Override
    public TimeAndMoneyDocument getTimeAndMoneyDocument(String documentNumber) {
        return (TimeAndMoneyDocument)this.businessObjectService.findBySinglePrimaryKey(TimeAndMoneyDocument.class, (Object)documentNumber);
    }

    @Override
    public List<TransactionDetail> getTransactionDetailsForDocument(String documentNumber) {
        Criteria crit = new Criteria();
        crit.addEqualTo(TIME_AND_MONEY_DOCUMENT_NUMBER, (Object)documentNumber);
        Criteria types = new Criteria();
        types.addEqualTo(TRANSACTION_DETAIL_TYPE, (Object)TransactionDetailType.PRIMARY.toString());
        types.addEqualTo(TRANSACTION_DETAIL_TYPE, (Object)TransactionDetailType.DATE.toString());
        crit.addOrCriteria(types);
        QueryByCriteria criteria = new QueryByCriteria(TransactionDetail.class, crit);
        return new ArrayList<TransactionDetail>(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)criteria));
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT A.NOTICE_DATE, C.DESCRIPTION, B.AWARD_AMOUNT_INFO_ID, C.DESCRIPTION, B.OBLIGATED_CHANGE, B.AMOUNT_OBLIGATED_TO_DATE,");
        sb.append(" B.OBLIGATION_EXPIRATION_DATE, B.CURRENT_FUND_EFFECTIVE_DATE FROM AWARD_AMOUNT_TRANSACTION A, AWARD_AMOUNT_INFO B, AWARD_TRANSACTION_TYPE C");
        sb.append(" WHERE A.AWARD_NUMBER = B.AWARD_NUMBER AND A.TRANSACTION_ID = B.TNM_DOCUMENT_NUMBER AND B.AWARD_NUMBER = ?");
        sb.append(" AND A.TRANSACTION_TYPE_CODE = C.AWARD_TRANSACTION_TYPE_CODE");
        sb.append(" ORDER BY B.AWARD_AMOUNT_INFO_ID DESC");
        SUMMARY_SQL_QUERY = sb.toString();
    }
}

