/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.core;

import java.util.List;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.framework.income.BudgetProjectIncome;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.rate.BudgetLaRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.framework.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgeCostTotalAuditRule;
import org.kuali.kra.award.budget.AwardBudgetBudgetTypeAuditRule;
import org.kuali.kra.award.budget.AwardBudgetCostLimitAuditRule;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.TransactionalDocument;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetDocumentRule")
public class BudgetDocumentRule
extends CostShareRuleResearchDocumentBase
implements DocumentAuditRule {
    private static final String BUDGETS = "budgets";
    @Autowired
    @Qualifier(value="kcBusinessRulesEngine")
    private KcBusinessRulesEngine kcBusinessRulesEngine;

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        boolean result = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        result &= this.getDictionaryValidationService().validateDefaultExistenceChecksForTransDoc((TransactionalDocument)document);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return result &= this.getKcBusinessRulesEngine().applyRules(new BudgetSaveEvent(((AwardBudgetDocument)document).getBudget(), BUDGETS)).booleanValue();
    }

    @KcEventMethod
    public boolean processBudgetSaveRule(BudgetSaveEvent event) {
        return this.getKnsDictionaryValidationService().validate((Object)event.getBudget()).getNumberOfErrors() == 0;
    }

    @KcEventMethod
    public boolean processBudgetProjectIncomeBusinessRule(BudgetSaveEvent event) {
        String errorPath;
        boolean valid = true;
        Budget budget = event.getBudget();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int i = 0;
        for (BudgetCostShare budgetCostShare : budget.getBudgetCostShares()) {
            errorPath = "budget.budgetCostShares[" + i + "]";
            errorMap.addToErrorPath(errorPath);
            if (budgetCostShare.getSharePercentage() != null && (budgetCostShare.getSharePercentage().isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO) || budgetCostShare.getSharePercentage().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100)))) {
                errorMap.putError("sharePercentage", "error.costSharing.percentage", new String[0]);
                valid = false;
            }
            String currentField = "document.budget.budgetCostShares[" + i + "].projectPeriod";
            int numberOfProjectPeriods = budget.getBudgetPeriods().size();
            boolean validationCheck = this.validateProjectPeriod(budgetCostShare.getProjectPeriod(), currentField, numberOfProjectPeriods);
            valid &= validationCheck;
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        i = 0;
        for (BudgetProjectIncome budgetProjectIncome : budget.getBudgetProjectIncomes()) {
            errorPath = "budgetProjectIncomes[" + i + "]";
            errorMap.addToErrorPath(errorPath);
            if (budgetProjectIncome.getProjectIncome() == null || !budgetProjectIncome.getProjectIncome().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(0.0))) {
                errorMap.putError("projectIncome", "error.projectIncome.negativeOrZero", new String[0]);
                valid = false;
            }
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        return valid;
    }

    @KcEventMethod
    public boolean processBudgetRatesBusinessRule(BudgetSaveEvent event) {
        String errorPath;
        String rateClassType;
        boolean valid = true;
        boolean APPLICABLE_RATE_LENGTH_EXCEEDED = true;
        int APPLICABLE_RATE_NEGATIVE = -1;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int i = 0;
        for (BudgetRate budgetRate : event.getBudget().getBudgetRates()) {
            rateClassType = budgetRate.getRateClass().getRateClassType().getDescription();
            errorPath = "budgetProposalRate[" + rateClassType + "][" + i + "]";
            errorMap.addToErrorPath(errorPath);
            if (budgetRate.isApplicableRateNull()) {
                valid = false;
                errorMap.putError("applicableRate", "error.required.applicableRate", new String[0]);
            } else if (!ScaleTwoDecimal.isNumeric((String)budgetRate.getApplicableRate().toString())) {
                valid = false;
                errorMap.putError("applicableRate", "error.applicableRate.notNumeric", new String[0]);
            } else {
                switch (this.verifyApplicableRate(budgetRate.getApplicableRate())) {
                    case 1: {
                        valid = false;
                        errorMap.putError("applicableRate", "error.applicableRate.limit", new String[]{"999.99"});
                        break;
                    }
                    case -1: {
                        valid = false;
                        errorMap.putError("applicableRate", "error.applicableRate.negative", new String[0]);
                    }
                }
            }
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        i = 0;
        for (BudgetLaRate budgetLaRate : event.getBudget().getBudgetLaRates()) {
            rateClassType = "";
            if (ObjectUtils.isNotNull((Object)budgetLaRate.getRateClass()) && ObjectUtils.isNotNull((Object)budgetLaRate.getRateClass().getRateClassType())) {
                rateClassType = budgetLaRate.getRateClass().getRateClassType().getDescription();
            }
            errorPath = "budgetRate[" + rateClassType + "][" + i + "]";
            errorMap.addToErrorPath(errorPath);
            if (budgetLaRate.isApplicableRateNull()) {
                valid = false;
                errorMap.putError("applicableRate", "error.required.applicableRate", new String[0]);
            } else if (!ScaleTwoDecimal.isNumeric((String)budgetLaRate.getApplicableRate().toString())) {
                valid = false;
                errorMap.putError("applicableRate", "error.applicableRate.notNumeric", new String[0]);
            } else {
                switch (this.verifyApplicableRate(budgetLaRate.getApplicableRate())) {
                    case 1: {
                        valid = false;
                        errorMap.putError("applicableRate", "error.applicableRate.limit", new String[]{"999.99"});
                        break;
                    }
                    case -1: {
                        valid = false;
                        errorMap.putError("applicableRate", "error.applicableRate.negative", new String[0]);
                    }
                }
            }
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        return valid;
    }

    private int verifyApplicableRate(ScaleTwoDecimal applicableRate) {
        int rateValue = 0;
        if (applicableRate.isNegative()) {
            rateValue = -1;
        } else if (applicableRate.isGreaterThan((AbstractDecimal)new ScaleTwoDecimal("999.99"))) {
            rateValue = 1;
        }
        return rateValue;
    }

    @KcEventMethod
    public boolean processBudgetExpenseBusinessRules(BudgetSaveEvent event) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        List<BudgetPeriod> budgetPeriods = event.getBudget().getBudgetPeriods();
        int i = 0;
        int j = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            j = 0;
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                if (budgetLineItem != null && budgetLineItem.getStartDate() != null && budgetLineItem.getStartDate().before(budgetPeriod.getStartDate())) {
                    errorMap.putError("budgetCategoryTypes[" + budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode() + "].budgetPeriods[" + i + "].budgetLineItems[" + j + "].startDate", "error.lineItemStartDate.before.periodStartDate", new String[0]);
                    valid = false;
                }
                if (budgetLineItem != null && budgetLineItem.getEndDate() != null && budgetLineItem.getEndDate().after(budgetPeriod.getEndDate())) {
                    if (budgetLineItem.getBudgetCategory() == null) {
                        budgetLineItem.refreshReferenceObject("budgetCategory");
                    }
                    errorMap.putError("budgetCategoryTypes[" + budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode() + "].budgetPeriods[" + i + "].budgetLineItems[" + j + "].endDate", "error.lineItemEndDate.after.periodEndDate", new String[0]);
                    valid = false;
                }
                if (budgetLineItem != null && budgetLineItem.getQuantity() != null && budgetLineItem.getQuantity() < 0) {
                    errorMap.putError("budgetPeriod[" + i + "].budgetLineItem[" + j + "].quantity", "error.negativeAmount", new String[]{"Quantity"});
                    valid = false;
                }
                ++j;
            }
            ++i;
        }
        return valid;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = true;
        retval &= this.getKcBusinessRulesEngine().applyRules(new BudgetAuditEvent(((AwardBudgetDocument)document).getBudget())).booleanValue();
        if (!((AwardBudgetDocument)document).getBudget().isProposalBudget()) {
            retval &= new AwardBudgetBudgetTypeAuditRule().processRunAuditBusinessRules(document);
            retval &= new AwardBudgeCostTotalAuditRule().processRunAuditBusinessRules(document);
            retval &= new AwardBudgetCostLimitAuditRule().processRunAuditBusinessRules(document);
        }
        return retval;
    }

    public KcBusinessRulesEngine getKcBusinessRulesEngine() {
        if (this.kcBusinessRulesEngine == null) {
            this.kcBusinessRulesEngine = KcServiceLocator.getService(KcBusinessRulesEngine.class);
        }
        return this.kcBusinessRulesEngine;
    }

    public void setKcBusinessRulesEngine(KcBusinessRulesEngine kcBusinessRulesEngine) {
        this.kcBusinessRulesEngine = kcBusinessRulesEngine;
    }
}

