/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.PostRemove;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.propdev.api.s2s.S2sAppAttachmentsContract;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="S2S_APP_ATTACHMENTS")
@IdClass(value=S2sAppAttachmentsId.class)
public class S2sAppAttachments
extends KcPersistableBusinessObjectBase
implements S2sAppAttachmentsContract {
    @PortableSequenceGenerator(name="SEQ_S2S_APP_ATTACHMENT_ID")
    @GeneratedValue(generator="SEQ_S2S_APP_ATTACHMENT_ID")
    @Id
    @Column(name="S2S_APP_ATTACHMENT_ID")
    private Long id;
    @Id
    @Column(name="CONTENT_ID")
    private String contentId;
    @Id
    @Column(name="PROPOSAL_NUMBER")
    private String proposalNumber;
    @Column(name="CONTENT_TYPE")
    private String contentType;
    @Column(name="HASH_CODE")
    private String sha1Hash;
    @Column(name="FILE_DATA_ID")
    private String fileDataId;
    @Column(name="FILE_NAME")
    private String name;
    @Transient
    private transient GrantApplicationHashService grantApplicationHashService;
    @Transient
    private transient WeakReference<byte[]> data;

    public Long getId() {
        return this.id;
    }

    public void setId(Long appAttachmentId) {
        this.id = appAttachmentId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getSha1Hash() {
        byte[] dt;
        if (StringUtils.isBlank((CharSequence)this.sha1Hash) && (dt = this.getData()) != null) {
            this.sha1Hash = this.getGrantApplicationHashService().computeAttachmentHash(dt);
        }
        return this.sha1Hash;
    }

    public void setSha1Hash(String sha1Hash) {
        this.sha1Hash = sha1Hash;
    }

    public byte[] getData() {
        byte[] existingData;
        if (this.data != null && (existingData = (byte[])this.data.get()) != null) {
            return existingData;
        }
        byte[] newData = this.getKcAttachmentDao().getData(this.fileDataId);
        this.data = new WeakReference<byte[]>(newData);
        return newData;
    }

    private KcAttachmentDataDao getKcAttachmentDao() {
        return KcServiceLocator.getService(KcAttachmentDataDao.class);
    }

    public String getFileDataId() {
        return this.fileDataId;
    }

    public void setFileDataId(String fileDataId) {
        this.fileDataId = fileDataId;
    }

    public void setData(byte[] data) {
        if (data == null) {
            this.getKcAttachmentDao().removeData(this.fileDataId);
        } else {
            this.fileDataId = this.getKcAttachmentDao().saveData(data, this.fileDataId);
        }
        this.data = new WeakReference<byte[]>(data);
    }

    @PostRemove
    public void removeData() {
        if (this.getFileDataId() != null) {
            this.getKcAttachmentDao().removeData(this.getFileDataId());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.getContentType();
    }

    public void setName(String name) {
        this.name = name;
    }

    public GrantApplicationHashService getGrantApplicationHashService() {
        if (this.grantApplicationHashService == null) {
            this.grantApplicationHashService = KcServiceLocator.getService(GrantApplicationHashService.class);
        }
        return this.grantApplicationHashService;
    }

    public static final class S2sAppAttachmentsId
    implements Serializable,
    Comparable<S2sAppAttachmentsId> {
        private Long id;
        private String contentId;
        private String proposalNumber;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getContentId() {
            return this.contentId;
        }

        public void setContentId(String contentId) {
            this.contentId = contentId;
        }

        public String getProposalNumber() {
            return this.proposalNumber;
        }

        public void setProposalNumber(String proposalNumber) {
            this.proposalNumber = proposalNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("contentId", (Object)this.contentId).append("proposalNumber", (Object)this.proposalNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            S2sAppAttachmentsId rhs = (S2sAppAttachmentsId)other;
            return new EqualsBuilder().append((Object)this.id, (Object)rhs.id).append((Object)this.contentId, (Object)rhs.contentId).append((Object)this.proposalNumber, (Object)rhs.proposalNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.contentId).append((Object)this.proposalNumber).toHashCode();
        }

        @Override
        public int compareTo(S2sAppAttachmentsId other) {
            return new CompareToBuilder().append((Object)this.id, (Object)other.id).append((Object)this.contentId, (Object)other.contentId).append((Object)this.proposalNumber, (Object)other.proposalNumber).toComparison();
        }
    }
}

