/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.serializers;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.document.service.DocumentActionListService;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.elasticsearch.CustomDataEntry;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.coeus.sys.framework.view.JstlFunctions;
import org.kuali.kra.bo.AbstractPerson;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.service.ActionTakenService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ElasticsearchDocumentSerializer {
    private static final Logger LOG = LogManager.getLogger(ElasticsearchDocumentSerializer.class);
    private static final String DEVELOPMENT_PROPOSAL = "DevelopmentProposal";
    private static final String DOCUMENT_SUFFIX = "Document";
    protected static final String NAME_SEPARATOR = ", ";
    @Autowired
    @Qualifier(value="actionTakenService")
    private ActionTakenService actionTakenService;
    @Autowired
    @Qualifier(value="businessObjectService")
    protected BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    protected DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="documentActionListService")
    private DocumentActionListService documentActionListService;
    @Autowired
    @Qualifier(value="documentRouteHeaderService")
    private RouteHeaderService documentRouteHeaderService;
    @Autowired
    @Qualifier(value="groupService")
    protected GroupService groupService;
    @Autowired
    @Qualifier(value="personService")
    protected PersonService personService;
    @Autowired
    @Qualifier(value="parameterService")
    protected ParameterService parameterService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    protected QuestionnaireAnswerService questionnaireAnswerService;

    public abstract GrantsSearchDocument translateDocument(Object var1);

    public abstract String getNamespace();

    public abstract Set<String> getViewPermissions();

    public abstract boolean supports(Object var1);

    protected void setGenericDocumentFields(GrantsSearchDocument esDoc, Document document) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            document.getDocumentHeader().setWorkflowDocument(WorkflowDocumentFactory.loadDocument((String)"kr", (String)document.getDocumentNumber()));
        }
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        esDoc.setDocumentNumber(document.getDocumentNumber());
        esDoc.setDocumentTitle(document.getDocumentTitle());
        esDoc.setRouteStatus(workflowDoc.getStatus().getLabel());
        esDoc.setInitiatorPrincipalId(workflowDoc.getInitiatorPrincipalId());
        Person initiator = this.personService.getPerson(workflowDoc.getInitiatorPrincipalId());
        esDoc.setInitiatorName(initiator != null ? this.formatNameForElasticsearch(initiator) : workflowDoc.getInitiatorPrincipalId());
        workflowDoc.getActionsTaken().stream().max(Comparator.comparing(ActionTaken::getActionDate)).ifPresent(actionTaken -> {
            esDoc.setLastActionDate(DateUtils.toUtc(actionTaken.getActionDate().toDate()));
            esDoc.setLastActionPrincipalId(actionTaken.getPrincipalId());
            Person lastActionUser = this.personService.getPerson(actionTaken.getPrincipalId());
            esDoc.setLastActionUserName(this.formatNameForElasticsearch(lastActionUser));
        });
        if ("ProposalDevelopmentDocument".equals(workflowDoc.getDocumentTypeName())) {
            esDoc.setDocumentType(DEVELOPMENT_PROPOSAL);
        } else {
            esDoc.setDocumentType(StringUtils.replace((String)workflowDoc.getDocumentTypeName(), (String)DOCUMENT_SUFFIX, (String)""));
        }
        esDoc.setCreateDate(DateUtils.toUtc(workflowDoc.getDateCreated().toDate()));
        if (document instanceof KcTransactionalDocumentBase) {
            esDoc.setUpdateDate(DateUtils.toUtc(((KcTransactionalDocumentBase)document).getUpdateTimestamp()));
        }
        if (workflowDoc.getStatus() == DocumentStatus.ENROUTE) {
            this.setActionRequestFields(esDoc, document);
            if (esDoc.getApprovalPriorityStop() == null) {
                LOG.warn(String.format("Document %s is ENROUTE but no pending or future approvals were found", document.getDocumentNumber()));
            }
        }
        esDoc.setLastApprovedDate(DateUtils.toUtc(this.actionTakenService.getLastApprovedDate(document.getDocumentNumber())));
    }

    protected void setActionRequestFields(GrantsSearchDocument esDoc, Document document) {
        DocumentRouteHeaderValue routeHeader = this.documentRouteHeaderService.getRouteHeader(document.getDocumentNumber());
        this.documentActionListService.fixActionRequestsPositions(routeHeader);
        List<ActionRequestValue> savedRequests = this.documentActionListService.populateRouteLogFormActionRequests(routeHeader);
        List<ActionRequestValue> simulatedRequests = this.documentActionListService.populateRouteLogFutureRequests(routeHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%d saved requests, %d simulated requests found for document %s, ", savedRequests.size(), simulatedRequests.size(), document.getDocumentNumber()));
        }
        List<ActionRequestValue> allIncompleteRequests = Stream.concat(savedRequests.stream(), simulatedRequests.stream()).filter(Predicate.not(ActionRequestValue::isDone)).filter(actionRequestValue -> ActionRequestType.COMPLETE.getCode().equalsIgnoreCase(actionRequestValue.getActionRequested()) || ActionRequestType.APPROVE.getCode().equalsIgnoreCase(actionRequestValue.getActionRequested())).collect(Collectors.toList());
        List<Integer> allIncompleteStops = this.determineIncompleteStops(allIncompleteRequests);
        allIncompleteRequests.forEach(request -> this.setActionRequestFieldsForTopLevelRequest(esDoc, (ActionRequestValue)request, allIncompleteStops));
    }

    protected List<Integer> determineIncompleteStops(List<ActionRequestValue> allIncompleteRequests) {
        Predicate<Integer> isAdHoc = priority -> priority == 0;
        boolean onlyAdHocActive = allIncompleteRequests.stream().filter(ActionRequestValue::isActive).map(ActionRequestValue::getPriority).allMatch(isAdHoc);
        if (onlyAdHocActive) {
            return allIncompleteRequests.stream().map(ActionRequestValue::getPriority).distinct().collect(Collectors.toList());
        }
        return allIncompleteRequests.stream().map(ActionRequestValue::getPriority).distinct().filter(Predicate.not(isAdHoc)).collect(Collectors.toList());
    }

    protected void setActionRequestFieldsForTopLevelRequest(GrantsSearchDocument esDoc, ActionRequestValue parentRequest, List<Integer> allIncompleteStops) {
        int position;
        if (LOG.isDebugEnabled()) {
            String logMessage = "%s request %s requested of %s for document %s";
            if (parentRequest.isUserRequest() && parentRequest.getPrincipal() != null) {
                LOG.debug(String.format("%s request %s requested of %s for document %s", parentRequest.getActionRequestedLabel(), parentRequest.getActionRequestId(), "user " + parentRequest.getPrincipal().getPrincipalName(), esDoc.getDocumentNumber()));
            } else if (parentRequest.isGroupRequest()) {
                LOG.debug(String.format("%s request %s requested of %s for document %s", parentRequest.getActionRequestedLabel(), parentRequest.getActionRequestId(), "group " + parentRequest.getGroupName(), esDoc.getDocumentNumber()));
            } else if (parentRequest.isRoleRequest()) {
                LOG.debug(String.format("%s request %s requested of %s for document %s", parentRequest.getActionRequestedLabel(), parentRequest.getActionRequestId(), "role " + parentRequest.getRoleName(), esDoc.getDocumentNumber()));
            }
        }
        if ((position = allIncompleteStops.indexOf(parentRequest.getPriority())) == 0) {
            esDoc.setApprovalType(parentRequest.getRecipientTypeLabel());
            esDoc.setApprovalPriorityStop(parentRequest.getPriority());
            this.getCurrentRouteStopForRequest(parentRequest).ifPresent(esDoc::setCurrentRouteStop);
            esDoc.setCurrentRouteStopDate(DateUtils.toUtc(parentRequest.getCreateDate()));
            this.getPrimaryApproverForRequest(parentRequest).ifPresent(esDoc::addPrimaryApprover);
        }
        BiConsumer<ActionRequestValue, String> setApproverFields = (request, principalId) -> {
            Person person = this.personService.getPerson(principalId);
            if (person != null) {
                esDoc.addApproverId(person.getPrincipalId());
                esDoc.addApproverName(this.formatNameForElasticsearch(person));
                if (!request.isDone()) {
                    if (request.isActive()) {
                        esDoc.addApproverSteps(person.getPrincipalId(), 0);
                    } else {
                        esDoc.addApproverSteps(person.getPrincipalId(), Math.max(position, 1));
                    }
                }
                esDoc.addApproverStatus(person.getPrincipalId(), request.getStatus());
                esDoc.addApproverDetails(parentRequest.getPriority(), String.format("%s;%s", person.getPrincipalId(), person.getName()));
            }
        };
        this.setApproverFieldsForRequest(esDoc, setApproverFields, parentRequest);
    }

    protected Optional<String> getCurrentRouteStopForRequest(ActionRequestValue request) {
        if (StringUtils.isNotBlank((CharSequence)request.getQualifiedRoleNameLabel())) {
            return Optional.ofNullable(request.getQualifiedRoleNameLabel());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getQualifiedRoleName())) {
            return Optional.ofNullable(request.getQualifiedRoleName());
        }
        return this.getPrimaryApproverForRequest(request);
    }

    protected Optional<String> getPrimaryApproverForRequest(ActionRequestValue parentRequest) {
        if (parentRequest.isRoleRequest()) {
            return Optional.ofNullable(StringUtils.isNotBlank((CharSequence)parentRequest.getQualifiedRoleNameLabel()) ? parentRequest.getQualifiedRoleNameLabel() : parentRequest.getQualifiedRoleName());
        }
        if (parentRequest.isGroupRequest()) {
            return Optional.ofNullable(this.groupService.getGroup(parentRequest.getGroupId())).map(Group::getName);
        }
        if (StringUtils.isNotBlank((CharSequence)parentRequest.getPrincipalId())) {
            return Optional.ofNullable(parentRequest.getPrincipalId()).map(arg_0 -> ((PersonService)this.personService).getPerson(arg_0)).map(this::formatNameForElasticsearch);
        }
        return Optional.empty();
    }

    protected void setApproverFieldsForRequest(GrantsSearchDocument esDoc, BiConsumer<ActionRequestValue, String> setApproverFields, ActionRequestValue request) {
        if (CollectionUtils.isNotEmpty((Collection)request.getChildrenRequests())) {
            request.getChildrenRequests().forEach(child -> this.setApproverFieldsForRequest(esDoc, setApproverFields, (ActionRequestValue)child));
            if (!request.isRoleRequest()) {
                this.setApproverFieldsForDirectRequest(esDoc, setApproverFields, request);
            }
        } else {
            this.setApproverFieldsForDirectRequest(esDoc, setApproverFields, request);
        }
    }

    protected void setApproverFieldsForDirectRequest(GrantsSearchDocument esDoc, BiConsumer<ActionRequestValue, String> setApproverFields, ActionRequestValue request) {
        Set<String> approverIds = null;
        if (request.isUserRequest() && !esDoc.getApproverIds().contains(request.getPrincipalId())) {
            approverIds = Set.of(request.getPrincipalId());
            setApproverFields.accept(request, request.getPrincipalId());
        } else if (request.isGroupRequest()) {
            approverIds = new HashSet<String>(this.groupService.getMemberPrincipalIds(request.getGroupId()));
            approverIds.forEach(principalId -> setApproverFields.accept(request, (String)principalId));
        }
        Optional<Object> maybeApproverIds = Optional.ofNullable(approverIds);
        maybeApproverIds.ifPresent(approvers -> {
            String delegationTypeCode = request.getParentActionRequest() != null && request.getParentActionRequest().isRoleRequest() ? request.getParentActionRequest().getDelegationTypeCode() : request.getDelegationTypeCode();
            this.setDelegatesForPrincipalIds(esDoc, delegationTypeCode, (Set<String>)approvers);
        });
    }

    protected void setDelegatesForPrincipalIds(GrantsSearchDocument esDoc, String delegationTypeCode, Set<String> principalIds) {
        if (DelegationType.PRIMARY.getCode().equals(delegationTypeCode)) {
            principalIds.forEach(esDoc::addApproverPrimaryDelegate);
        } else if (DelegationType.SECONDARY.getCode().equals(delegationTypeCode)) {
            principalIds.forEach(esDoc::addApproverSecondaryDelegate);
        }
    }

    protected void setPdSpecificFields(GrantsSearchDocument esDoc, DevelopmentProposal devProposal) {
        this.setPdSpecificFields(esDoc, List.of(devProposal));
    }

    protected void setPdSpecificFields(GrantsSearchDocument esDoc, Collection<DevelopmentProposal> devProposals) {
        for (DevelopmentProposal proposal : devProposals) {
            esDoc.addProposalNumber(proposal.getProposalNumber());
            esDoc.addDevProposalNumber(proposal.getProposalNumber());
            esDoc.addOpportunityId(proposal.getOpportunityIdForGG());
            esDoc.addPrevGrantsGovTrackingID(proposal.getPrevGrantsGovTrackingID());
            esDoc.addProgramAnnouncementNumber(proposal.getProgramAnnouncementNumber());
            esDoc.addProgramAnnouncementTitle(proposal.getProgramAnnouncementTitle());
            esDoc.addAgencyRoutingIdentifier(proposal.getAgencyRoutingIdentifier());
            esDoc.addDeadlineDate(DateUtils.toUtc(proposal.getDeadlineDate()));
            esDoc.addDeadlineTime(proposal.getDeadlineTime());
            if (proposal.getDeadlineDate() != null) {
                int daysTilDeadline = (int)ChronoUnit.DAYS.between(LocalDate.now(), proposal.getDeadlineDate().toLocalDate());
                if (esDoc.getDaysTilNextDeadline() == null || esDoc.getDaysTilNextDeadline() > daysTilDeadline) {
                    esDoc.setDaysTilNextDeadline(daysTilDeadline);
                }
                if (proposal.getDeadlineTypeRef() != null) {
                    esDoc.setDeadlineTypeDescription(proposal.getDeadlineTypeRef().getDescription());
                }
            }
            if (proposal.getFinalBudget() == null || !CollectionUtils.isNotEmpty(proposal.getFinalBudget().getBudgetSubAwards())) continue;
            esDoc.addSubrecipientOrganizationName(proposal.getFinalBudget().getBudgetSubAwards().stream().map(BudgetSubAwards::getOrganizationName).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
    }

    protected void addPersonnel(GrantsSearchDocument esDoc, AbstractPerson projectPerson) {
        this.addPersonnel(esDoc, this.personnelIdFor(projectPerson), this.formatNameForElasticsearch(projectPerson), null);
    }

    protected void addPersonnel(GrantsSearchDocument esDoc, ProposalPerson projectPerson) {
        this.addPersonnel(esDoc, this.personnelIdFor(projectPerson), this.formatNameForElasticsearch(projectPerson), this.formatNameForElasticsearch((AbstractPerson)projectPerson));
    }

    private void addPersonnel(GrantsSearchDocument esDoc, String personnelId, String personnelName, String alternateName) {
        if (personnelId != null) {
            esDoc.addPersonnelId(personnelId);
        }
        if (StringUtils.isNotBlank((CharSequence)personnelName)) {
            esDoc.addPersonnelName(personnelName);
        }
        if (StringUtils.isNotBlank((CharSequence)alternateName) && !personnelName.equals(alternateName)) {
            esDoc.addPersonnelAlternateName(alternateName);
        }
    }

    private String personnelIdFor(AbstractPerson person) {
        if (StringUtils.isNotBlank((CharSequence)person.getPersonId())) {
            return person.getPersonId();
        }
        return String.valueOf(person.getRolodexId());
    }

    protected Optional<Rolodex> getRolodex(String rolodexId) {
        if (StringUtils.isEmpty((CharSequence)rolodexId)) {
            return Optional.empty();
        }
        return Optional.ofNullable((Rolodex)this.businessObjectService.findByPrimaryKey(NonOrganizationalRolodex.class, Map.of("rolodexId", rolodexId)));
    }

    protected boolean isExportControlEnabled() {
        return JstlFunctions.isProfileActive("excon");
    }

    protected String getSpecialReviewApprovalType(SpecialReview<?> specialReview) {
        return this.isExportControlEnabled() && "RESBOOT-1000".equals(specialReview.getApprovalTypeCode()) ? specialReview.getProtocolStatus() : (specialReview.getApprovalType() != null ? specialReview.getApprovalType().getDescription() : null);
    }

    protected String formatNameForElasticsearch(AbstractPerson abstractPerson) {
        if (abstractPerson == null) {
            return null;
        }
        String result = null;
        if (abstractPerson.getPersonId() != null && StringUtils.isBlank((CharSequence)(result = this.formatNameForElasticsearch(abstractPerson.getPerson())))) {
            Person person = this.personService.getPerson(abstractPerson.getPersonId());
            result = this.formatNameForElasticsearch(person);
        }
        if (StringUtils.isBlank(result) && abstractPerson.getRolodexId() != null) {
            Rolodex rolodex = (Rolodex)this.businessObjectService.findByPrimaryKey(Rolodex.class, Map.of("rolodexId", abstractPerson.getRolodexId()));
            result = this.formatNameForElasticsearch(rolodex);
        }
        return result;
    }

    protected String formatNameForElasticsearch(Person person) {
        if (person == null) {
            return null;
        }
        return this.formatNameForElasticsearch(person.getName(), person.getLastName(), person.getFirstName(), person.getMiddleName());
    }

    protected String formatNameForElasticsearch(KcPerson person) {
        if (person == null) {
            return null;
        }
        return this.formatNameForElasticsearch(person.getFullName(), person.getLastName(), person.getFirstName(), person.getMiddleName());
    }

    protected String formatNameForElasticsearch(Rolodex rolodex) {
        if (rolodex == null) {
            return null;
        }
        return this.formatNameForElasticsearch(rolodex.getFullName(), rolodex.getLastName(), rolodex.getFirstName(), rolodex.getMiddleName());
    }

    protected String formatNameForElasticsearch(ProposalPerson person) {
        if (person == null) {
            return null;
        }
        return this.formatNameForElasticsearch(person.getFullName(), person.getLastName(), person.getFirstName(), person.getMiddleName());
    }

    private String formatNameForElasticsearch(String fullName, String surname, String given, String middle) {
        if (StringUtils.isNotBlank((CharSequence)given) && StringUtils.isNotBlank((CharSequence)surname)) {
            return surname + NAME_SEPARATOR + given + (String)(StringUtils.isNotBlank((CharSequence)middle) ? " " + middle : "");
        }
        return fullName;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    protected void setDocumentActionListService(DocumentActionListService documentActionListService) {
        this.documentActionListService = documentActionListService;
    }

    protected void setDocumentRouteHeaderService(RouteHeaderService documentRouteHeaderService) {
        this.documentRouteHeaderService = documentRouteHeaderService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public void setSearchDocCustomDataIfEnabled(GrantsSearchDocument esDoc, CustomDataContainer customDataContainer) {
        boolean enabled = this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "Elasticsearch_Index_SupplementalInfo_Enabled", Boolean.FALSE);
        if (enabled) {
            customDataContainer.getCustomDataList().stream().map(CustomDataEntry::createEntry).forEach(esDoc::addCustomData);
        }
    }
}

