/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardSyncAuditRule
implements DocumentAuditRule {
    protected String SYNC_ERRORS = "awardSyncAuditErrors";
    protected List<AuditError> auditErrors;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        AwardDocument awardDocument = (AwardDocument)document;
        this.auditErrors = new ArrayList<AuditError>();
        Award award = awardDocument.getAward();
        if (award.getSyncChanges() != null && !award.getSyncChanges().isEmpty()) {
            for (AwardSyncChange change : award.getSyncChanges()) {
                if (change.getSyncDescendantsType() != null) continue;
                valid = false;
                this.auditErrors.add(new AuditError("document.awardList[0].syncChanges[" + award.getSyncChanges().indexOf(change) + "].syncDescendants", "error.award.awardhierarchy.sync.whichdescendants", "awardActions.Award Hierarchy Sync"));
            }
            AwardHierarchy hierarchy = this.getAwardHierarchyService().loadAwardHierarchyBranch(award.getAwardNumber());
            if (hierarchy != null) {
                for (AwardHierarchy curHierarchy : hierarchy.getChildren()) {
                    valid &= this.validateHierarchyIsActive(curHierarchy);
                }
            }
        }
        this.reportAndCreateAuditCluster();
        return valid;
    }

    protected AwardHierarchyService getAwardHierarchyService() {
        return KcServiceLocator.getService(AwardHierarchyService.class);
    }

    protected VersionHistoryService getVersionHistoryService() {
        return KcServiceLocator.getService(VersionHistoryService.class);
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(this.SYNC_ERRORS, new AuditCluster("Award Hierarchy Sync", this.auditErrors, "Error"));
        }
    }

    protected boolean validateHierarchyIsActive(AwardHierarchy hierarchy) {
        boolean success = this.isAwardActive(hierarchy.getAwardNumber());
        if (!success) {
            this.auditErrors.add(new AuditError("document.awardList[0].syncChanges", "error.award.awardhierarchy.sync.invalidstatus", "awardActions.Award Hierarchy Sync", new String[]{hierarchy.getAwardNumber()}));
        }
        for (AwardHierarchy curHierarchy : hierarchy.getChildren()) {
            success &= this.validateHierarchyIsActive(curHierarchy);
        }
        return success;
    }

    protected boolean isAwardActive(String awardNumber) {
        boolean success = false;
        List<VersionHistory> versions = this.getVersionHistoryService().loadVersionHistory(Award.class, awardNumber);
        for (VersionHistory history : versions) {
            if (history.getStatus() == VersionStatus.PENDING) {
                return false;
            }
            if (history.getStatus() != VersionStatus.ACTIVE) continue;
            success = true;
        }
        return success;
    }
}

