/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.dataovveride.common;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.dataovveride.common.CommonDataOverrideService;
import org.kuali.coeus.sys.api.model.ScaleThreeDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.metadata.DataObjectRelationship;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="commonDataOverrideService")
public class CommonDataOverrideServiceImpl
implements CommonDataOverrideService {
    private static final Logger LOG = LogManager.getLogger(CommonDataOverrideServiceImpl.class);
    private static final String ON = "on";
    private static final String YES = "Yes";
    private static final String Y = "Y";
    private static final String NO = "No";
    private static final String TRUE = "true";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;

    @Override
    public void setChangedValue(KcPersistableBusinessObjectBase bo, String propertyName, String propertyValue) {
        block29: {
            Class type = this.dataObjectService.wrap((Object)bo).getPropertyType(propertyName);
            try {
                if (propertyValue == null) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, null);
                    break block29;
                }
                if (Date.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)this.getDateTimeService().convertToSqlDate(propertyValue));
                    break block29;
                }
                if (Timestamp.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)this.getDateTimeService().convertToSqlTimestamp(propertyValue));
                    break block29;
                }
                if (Time.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)this.getDateTimeService().convertToSqlTime(propertyValue));
                    break block29;
                }
                if (java.util.Date.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)this.getDateTimeService().convertToDateTime(propertyValue));
                    break block29;
                }
                if (Integer.TYPE.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Integer.valueOf(propertyValue));
                    break block29;
                }
                if (Byte.TYPE.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Byte.valueOf(propertyValue));
                    break block29;
                }
                if (Short.TYPE.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Short.valueOf(propertyValue));
                    break block29;
                }
                if (Integer.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Integer.valueOf(propertyValue));
                    break block29;
                }
                if (Byte.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Byte.valueOf(propertyValue));
                    break block29;
                }
                if (Short.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Short.valueOf(propertyValue));
                    break block29;
                }
                if (Long.TYPE.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Long.valueOf(propertyValue));
                    break block29;
                }
                if (Long.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Long.valueOf(propertyValue));
                    break block29;
                }
                if (Float.TYPE.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Float.valueOf(Float.valueOf(propertyValue).floatValue()));
                    break block29;
                }
                if (Float.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Float.valueOf(propertyValue));
                    break block29;
                }
                if (Double.TYPE.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Double.valueOf(propertyValue));
                    break block29;
                }
                if (Double.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)Double.valueOf(propertyValue));
                    break block29;
                }
                if (BigInteger.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)new BigInteger(propertyValue));
                    break block29;
                }
                if (BigDecimal.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)new BigDecimal(propertyValue));
                    break block29;
                }
                if (String.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)propertyValue);
                    break block29;
                }
                if (Boolean.TYPE.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)ON.equals(propertyValue));
                    break block29;
                }
                if (Boolean.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)(ON.equals(propertyValue) || YES.equals(propertyValue) || Y.equals(propertyValue) ? 1 : 0));
                    break block29;
                }
                if (ScaleTwoDecimal.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)new ScaleTwoDecimal(propertyValue));
                    break block29;
                }
                if (ScaleThreeDecimal.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)new ScaleThreeDecimal(propertyValue));
                    break block29;
                }
                if (KualiDecimal.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)new KualiDecimal(propertyValue));
                    break block29;
                }
                if (KualiInteger.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)new KualiInteger(propertyValue));
                    break block29;
                }
                if (KualiPercent.class.isAssignableFrom(type)) {
                    PropertyUtils.setNestedProperty((Object)bo, (String)propertyName, (Object)new KualiPercent(propertyValue));
                    break block29;
                }
                throw new RuntimeException("Data override does not work for this class");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String getChangedValue(KcPersistableBusinessObjectBase bo, String propertyName) {
        Object propertyObject = this.getPropertyValue(bo, propertyName);
        DataType dataType = DataType.getDataTypeFromClass((Class)this.dataObjectService.wrap((Object)bo).getPropertyType(propertyName));
        String propertyValue = null;
        if (propertyObject != null) {
            propertyValue = dataType == null ? propertyObject.toString() : (dataType.isTemporal() ? this.getDateTimeService().toDateString((java.util.Date)propertyObject) : (dataType.equals((Object)DataType.STRING) ? (String)propertyObject : (dataType.equals((Object)DataType.BOOLEAN) ? (TRUE.equals(propertyObject.toString()) ? YES : NO) : propertyObject.toString())));
        }
        return propertyValue;
    }

    @Override
    public <T extends KcPersistableBusinessObjectBase> String getDisplayReferenceValue(T bo, String propertyName, Class<T> clazz) {
        String refName = "";
        DataObjectRelationship relationship = this.getDataObjectService().getMetadataRepository().getMetadata(clazz).getRelationshipByLastAttributeInRelationship(propertyName);
        if (relationship != null) {
            refName = relationship.getName();
        }
        if (StringUtils.isNotEmpty((CharSequence)refName)) {
            this.getDataObjectService().wrap(bo).fetchRelationship(refName);
            try {
                Object refObject = PropertyUtils.getNestedProperty(bo, (String)refName);
                return (String)PropertyUtils.getNestedProperty((Object)refObject, (String)"description");
            }
            catch (Exception e) {
                LOG.warn("no description field found on ref object", (Throwable)e);
            }
        }
        return null;
    }

    protected Object getPropertyValue(KcPersistableBusinessObjectBase bo, String propertyName) {
        try {
            return PropertyUtils.getNestedProperty((Object)bo, (String)propertyName);
        }
        catch (Exception e) {
            throw new RiceRuntimeException("propertyName [" + propertyName + "] can not be found on bo", (Throwable)e);
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

