/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.rate;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.rate.AbstractInstituteRate;
import org.kuali.coeus.common.budget.framework.rate.InstituteRate;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.budget.impl.rate.InstituteRateRateTypeRateClassRule;
import org.kuali.coeus.common.budget.impl.rate.InstituteRateRateTypeRateClassRuleImpl;
import org.kuali.coeus.common.framework.type.ActivityType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstituteRateMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private final InstituteRateRateTypeRateClassRule rule;

    public InstituteRateMaintenanceDocumentRule() {
        this(new InstituteRateRateTypeRateClassRuleImpl());
    }

    InstituteRateMaintenanceDocumentRule(InstituteRateRateTypeRateClassRule rule) {
        if (rule == null) {
            throw new NullPointerException("the rule is null");
        }
        this.rule = rule;
    }

    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        this.logDocInfo(document);
        boolean valid = this.rule.validateRateTypeAndRateClass((AbstractInstituteRate)document.getDocumentDataObject());
        return valid &= this.checkExistence((AbstractInstituteRate)document.getNewMaintainableObject().getDataObject());
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        this.logDocInfo(document);
        boolean valid = this.rule.validateRateTypeAndRateClass((AbstractInstituteRate)document.getDocumentDataObject());
        return valid &= this.checkExistence((AbstractInstituteRate)document.getNewMaintainableObject().getDataObject());
    }

    private boolean checkExistence(AbstractInstituteRate newInstituteRate) {
        HashMap<String, String> pkMap;
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)newInstituteRate.getRateClassCode()) && StringUtils.isNotBlank((CharSequence)newInstituteRate.getRateTypeCode())) {
            pkMap = new HashMap();
            pkMap.put("rateClassCode", newInstituteRate.getRateClassCode());
            pkMap.put("rateTypeCode", newInstituteRate.getRateTypeCode());
            RateType rateType = (RateType)KcServiceLocator.getService(BusinessObjectService.class).findByPrimaryKey(RateType.class, pkMap);
            if (rateType == null) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.rateTypeCode", "error.rateType.not.exist", new String[]{newInstituteRate.getRateClassCode(), newInstituteRate.getRateTypeCode()});
                valid = false;
            }
        }
        pkMap = new HashMap<String, String>();
        pkMap.put("unitNumber", newInstituteRate.getUnitNumber());
        valid &= this.checkExistenceFromTable(Unit.class, pkMap, "unitNumber", "Unit Number");
        if (newInstituteRate instanceof InstituteRate) {
            HashMap<String, String> pkMap1 = new HashMap<String, String>();
            pkMap1.put("code", ((InstituteRate)newInstituteRate).getActivityTypeCode());
            valid &= this.checkExistenceFromTable(ActivityType.class, pkMap1, "activityTypeCode", "Activity Type");
        }
        return valid;
    }

    private void logDocInfo(MaintenanceDocument maintenanceDocument) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("new maintainable is: " + String.valueOf(maintenanceDocument.getNewMaintainableObject().getClass()));
        }
    }
}

