/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.auth;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.bo.authorization.BusinessObjectAuthorizerBase;
import org.kuali.rice.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

public abstract class KcTransactionalDocumentAuthorizerBase
extends BusinessObjectAuthorizerBase
implements TransactionalDocumentAuthorizer {
    private ParameterService parameterService;
    public static final String PRE_ROUTING_ROUTE_NAME = "PreRoute";

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    public Set<String> getDocumentActions(Document document, Person user, Set<String> oldDocumentActions) {
        return this.getDocumentActions(document, user);
    }

    protected Set<String> getDocumentActions(Document document, Person user) {
        HashSet<String> documentActions = new HashSet<String>();
        if (this.canEdit(document, user)) {
            documentActions.add("canEdit");
        }
        if (this.canEdit(document, user)) {
            documentActions.add("canEditDocumentOverview");
        }
        if (this.canAnnotate(document, user)) {
            documentActions.add("canAnnotate");
        }
        if (this.canClose(document, user)) {
            documentActions.add("canClose");
        }
        if (this.canSave(document, user)) {
            documentActions.add("canSave");
        }
        if (this.canRoute(document, user)) {
            documentActions.add("canRoute");
        }
        if (this.canCancel(document, user)) {
            documentActions.add("canCancel");
        }
        if (this.canReload(document, user)) {
            documentActions.add("canReload");
        }
        if (this.canCopy(document, user)) {
            documentActions.add("canCopy");
        }
        if (this.canPerformRouteReport(document, user)) {
            documentActions.add("canPerformRouteReport");
        }
        if (this.canAdHocRoute(document, user)) {
            documentActions.add("canAdHocRoute");
        }
        if (this.canBlanketApprove(document, user)) {
            documentActions.add("canBlanketApprove");
        }
        if (this.canApprove(document, user)) {
            documentActions.add("canApprove");
        }
        if (this.canDisapprove(document, user)) {
            documentActions.add("canDisapprove");
        }
        if (this.canSendAdhocRequests(document, user)) {
            documentActions.add("canSendAdHocRequests");
        }
        if (this.canAddAdhocRequests(document, user)) {
            documentActions.add("canAddAdHocRequests");
        }
        if (this.canAcknowledge(document, user)) {
            documentActions.add("canAcknowledge");
        }
        if (this.canFyi(document, user)) {
            documentActions.add("canFYI");
        }
        if (this.canRecall(document, user)) {
            documentActions.add("canRecall");
        }
        if (this.canComplete(document)) {
            documentActions.add("canComplete");
        }
        return documentActions;
    }

    protected boolean canComplete(Document document) {
        return document.getDocumentHeader().getWorkflowDocument().isException();
    }

    protected final boolean canEdit(Document document) {
        boolean canEdit = false;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isInitiated() || workflowDocument.isSaved() || workflowDocument.isEnroute() || workflowDocument.isException()) {
            canEdit = true;
        }
        return canEdit;
    }

    protected final boolean canAnnotate(Document document) {
        return this.canEdit(document);
    }

    protected final boolean canReload(Document document) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return this.canEdit(document) && !workflowDocument.isInitiated();
    }

    protected final boolean canClose(Document document) {
        return true;
    }

    protected final boolean canRoute(Document document) {
        boolean canRoute = false;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isInitiated() || workflowDocument.isSaved()) {
            canRoute = true;
        }
        return canRoute;
    }

    protected final boolean canCancel(Document document) {
        return this.canEdit(document);
    }

    protected final boolean canCopy(Document document) {
        boolean canCopy = false;
        if (document.getAllowsCopy()) {
            canCopy = true;
        }
        return canCopy;
    }

    protected final boolean canPerformRouteReport(Document document) {
        return this.getParameterService().getParameterValueAsBoolean("KR-NS", "Document", "DEFAULT_CAN_PERFORM_ROUTE_REPORT_IND");
    }

    protected final boolean canAdHocRoute(Document document) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        return this.canEdit(document) && !workflowDocument.isException();
    }

    protected final boolean canBlanketApprove(Document document) {
        return this.canEdit(document);
    }

    protected final boolean canSendAdhocRequests(Document document) {
        return this.canAdHocRoute(document) && document.getDocumentHeader().getWorkflowDocument().isEnroute();
    }

    public boolean canEdit(Document document, Person user) {
        return this.canEdit(document);
    }

    public boolean canAnnotate(Document document, Person user) {
        return this.canAnnotate(document);
    }

    public boolean canClose(Document document, Person user) {
        return this.canClose(document);
    }

    public boolean canSave(Document document, Person user) {
        return this.canEdit(document);
    }

    public boolean canCancel(Document document, Person user) {
        return this.canCancel(document);
    }

    public boolean canReload(Document document, Person user) {
        return this.canReload(document);
    }

    public boolean canCopy(Document document, Person user) {
        return this.canCopy(document);
    }

    public boolean canPerformRouteReport(Document document, Person user) {
        return this.canPerformRouteReport(document);
    }

    public boolean canApprove(Document document, Person user) {
        WorkflowDocument workDoc = this.getWorkflowDocument(document, user);
        return workDoc.isApprovalRequested() && workDoc.getValidActions().getValidActions().contains(ActionType.fromCode((String)"A")) && workDoc.isEnroute();
    }

    public boolean canDisapprove(Document document, Person user) {
        WorkflowDocument workflowDocument = this.getWorkflowDocument(document, user);
        return workflowDocument.isApprovalRequested() && workflowDocument.getValidActions().getValidActions().contains(ActionType.fromCode((String)"D")) && workflowDocument.isEnroute();
    }

    protected boolean canSendAdhocRequests(Document document, Person user) {
        return this.canSendAdhocRequests(document);
    }

    protected boolean canAddAdhocRequests(Document document, Person user) {
        return this.canAdHocRoute(document, user);
    }

    public boolean canBlanketApprove(Document document, Person user) {
        return this.canBlanketApprove(document) && this.isAuthorizedByTemplate(document, "KR-WKFLW", "Blanket Approve Document", user.getPrincipalId());
    }

    public boolean canRoute(Document document, Person user) {
        return this.canRoute(document) && this.isAuthorizedByTemplate(document, "KR-WKFLW", "Route Document", user.getPrincipalId());
    }

    public boolean canAcknowledge(Document document, Person user) {
        return this.canTakeRequestedAction(document, "K", user);
    }

    public boolean canFyi(Document document, Person user) {
        return this.canTakeRequestedAction(document, "F", user);
    }

    protected boolean canAdHocRoute(Document document, Person user) {
        return this.canAdHocRoute(document);
    }

    public final boolean canReceiveAdHoc(Document document, Person user, String actionRequestCode) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("actionRequestCd", actionRequestCode);
        return this.isAuthorizedByTemplate(document, "KR-WKFLW", "Ad Hoc Review Document", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    public boolean canAddNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (attachmentTypeCode != null) {
            additionalPermissionDetails.put("attachmentTypeCode", attachmentTypeCode);
        }
        return this.isAuthorizedByTemplate(document, "KR-NS", "Add Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    public boolean canDeleteNoteAttachment(Document document, String attachmentTypeCode, String createdBySelfOnly, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (attachmentTypeCode != null) {
            additionalPermissionDetails.put("attachmentTypeCode", attachmentTypeCode);
        }
        additionalPermissionDetails.put("createdBySelfOnly", createdBySelfOnly);
        return this.isAuthorizedByTemplate(document, "KR-NS", "Delete Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, Person user) {
        return this.canViewNoteAttachment(document, attachmentTypeCode, user.getPrincipalId(), user);
    }

    public boolean canViewNoteAttachment(Document document, String attachmentTypeCode, String authorUniversalIdentifier, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (attachmentTypeCode != null) {
            additionalPermissionDetails.put("attachmentTypeCode", attachmentTypeCode);
        }
        return this.isAuthorizedByTemplate(document, "KR-NS", "View Note / Attachment", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    public boolean canTakeRequestedAction(Document document, String actionRequestCode, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("actionRequestCd", actionRequestCode);
        return this.isAuthorizedByTemplate(document, "KR-NS", "Take Requested Action", user.getPrincipalId(), additionalPermissionDetails, null);
    }

    protected void addPermissionDetails(Object businessObject, Map<String, String> attributes) {
        super.addPermissionDetails(businessObject, attributes);
        if (businessObject instanceof Document) {
            this.addStandardAttributes((Document)businessObject, attributes);
        }
    }

    protected void addRoleQualification(Object businessObject, Map<String, String> attributes) {
        super.addRoleQualification(businessObject, attributes);
        if (businessObject instanceof Document) {
            this.addStandardAttributes((Document)businessObject, attributes);
        }
    }

    private void addStandardAttributes(Document document, Map<String, String> attributes) {
        WorkflowDocument wd = document.getDocumentHeader().getWorkflowDocument();
        attributes.put("documentNumber", document.getDocumentNumber());
        attributes.put("documentTypeName", wd.getDocumentTypeName());
        if (wd.isInitiated() || wd.isSaved()) {
            attributes.put("routeNodeName", PRE_ROUTING_ROUTE_NAME);
        } else {
            WorkflowDocumentService workflowDocumentService = KRADServiceLocatorWeb.getWorkflowDocumentService();
            attributes.put("routeNodeName", workflowDocumentService.getCurrentRouteNodeNames(wd));
        }
        attributes.put("routeStatusCode", wd.getStatus().getCode());
    }

    protected final TaskAuthorizationService getTaskAuthorizationService() {
        return KcServiceLocator.getService(TaskAuthorizationService.class);
    }

    public boolean canSendAdHocRequests(Document arg0, String arg1, Person arg2) {
        return true;
    }

    protected boolean isEnroute(Document document) {
        return "R".equals(document.getDocumentHeader().getWorkflowDocument().getStatus().getCode());
    }

    protected boolean isFinal(Document document) {
        return "F".equals(document.getDocumentHeader().getWorkflowDocument().getStatus().getCode());
    }

    private WorkflowDocument getWorkflowDocument(Document document, Person user) {
        WorkflowDocument workDoc = WorkflowDocumentFactory.loadDocument((String)user.getPrincipalId(), (String)document.getDocumentHeader().getWorkflowDocument().getDocumentId());
        return workDoc;
    }

    public boolean canEditDocumentOverview(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canSendAnyTypeAdHocRequests(Document document, Person user) {
        return true;
    }

    public boolean canRecall(Document document, Person user) {
        return false;
    }

    public boolean canSuperUserTakeAction(Document document, Person user) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        String principalId = user.getPrincipalId();
        String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
        if (KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, documentTypeId)) {
            return true;
        }
        String documentTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List routeNodeInstances = document.getDocumentHeader().getWorkflowDocument().getRouteNodeInstances();
        String documentStatus = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveSingleActionRequest(principalId, documentTypeName, routeNodeInstances, documentStatus);
    }

    public boolean canSuperUserApprove(Document document, Person user) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        String principalId = user.getPrincipalId();
        String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
        if (KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, documentTypeId)) {
            return true;
        }
        String documentTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List routeNodeInstances = document.getDocumentHeader().getWorkflowDocument().getRouteNodeInstances();
        String documentStatus = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserApproveDocument(principalId, documentTypeName, routeNodeInstances, documentStatus);
    }

    public boolean canSuperUserDisapprove(Document document, Person user) {
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            return false;
        }
        String principalId = user.getPrincipalId();
        String documentTypeId = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
        if (KewApiServiceLocator.getDocumentTypeService().isSuperUserForDocumentTypeId(principalId, documentTypeId)) {
            return true;
        }
        String documentTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List routeNodeInstances = document.getDocumentHeader().getWorkflowDocument().getRouteNodeInstances();
        String documentStatus = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        return KewApiServiceLocator.getDocumentTypeService().canSuperUserDisapproveDocument(principalId, documentTypeName, routeNodeInstances, documentStatus);
    }

    public void setDocumentRequestAuthorizationCache(DocumentRequestAuthorizationCache documentRequestAuthorizationCache) {
    }
}

