/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.impl.LineItem;
import org.kuali.coeus.common.framework.impl.LineItemGroup;
import org.kuali.coeus.common.framework.impl.LineItemObject;
import org.kuali.coeus.common.framework.impl.LineItemRow;
import org.kuali.coeus.common.framework.impl.Period;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.bind.UifCurrencyEditor;

@BeanTag(name="lineItemTable", parent="Uif-LineItemTable")
public class LineItemTable
extends GroupBase
implements DataBinding {
    private static final long serialVersionUID = 1677312513807050571L;
    private static final Logger LOG = LogManager.getLogger(LineItemTable.class);
    private String propertyName;
    private BindingInfo bindingInfo;
    private List<LineItemRow> rows = new ArrayList<LineItemRow>();
    private List<LineItemRow> flattenedRows = new ArrayList<LineItemRow>();
    private LineItemRow headerRow;
    private String dateRangeFormat;
    private boolean renderRowTotalColumn;
    private int numPeriodColumns;
    private boolean renderDisclosureLinks;
    private boolean renderOpened;
    private int lineIndex;
    private UifCurrencyEditor currencyEditor = new UifCurrencyEditor();

    public void performInitialization(Object model) {
        super.performInitialization(model);
        View view = ViewLifecycle.getView();
        this.bindingInfo.setDefaults(view, this.getPropertyName());
    }

    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        this.setOnDocumentReadyScript("Kc.LineItemTable.setupLineItemTable(jQuery('#" + this.getId() + "'));");
        this.lineIndex = 0;
        try {
            List periods = (List)PropertyUtils.getProperty((Object)model, (String)this.getBindingInfo().getBindingPath());
            if (periods != null) {
                this.headerRow = new LineItemRow();
                this.headerRow.getCellContent().add("");
                int columnNum = 0;
                if (this.getHeader() != null && this.getHeader().getRightGroup() != null && this.numPeriodColumns >= periods.size()) {
                    this.getHeader().getRightGroup().setRender(false);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateRangeFormat);
                for (Period period : periods) {
                    String startDate = "?";
                    String endDate = "?";
                    if (period.getStartDate() != null) {
                        startDate = simpleDateFormat.format(period.getStartDate());
                    }
                    if (period.getEndDate() != null) {
                        endDate = simpleDateFormat.format(period.getEndDate());
                    }
                    this.headerRow.getCellContent().add(period.getName() + "<span class='uif-period-dateRange'>(" + startDate + " - " + endDate + ")</span>");
                    List<LineItemGroup> lineItemGroups = period.getLineItemGroups();
                    ++columnNum;
                    for (LineItemGroup lineItemGroup : lineItemGroups) {
                        LineItemRow lineItemGroupRow = this.findRow(this.rows, lineItemGroup.getGroupName());
                        if (lineItemGroupRow == null) {
                            lineItemGroupRow = new LineItemRow(this.getId() + "_" + lineItemGroup.getGroupName() + this.lineIndex);
                            lineItemGroupRow.setLineItemId(lineItemGroup.getGroupName());
                            lineItemGroupRow.getCellContent().add(lineItemGroup.getGroupName());
                            lineItemGroupRow.setCssClass("uif-lineItemGroup");
                            lineItemGroupRow.setGroupRow(true);
                            this.rows.add(lineItemGroupRow);
                            ++this.lineIndex;
                        }
                        this.processSubLineItems(lineItemGroup, lineItemGroupRow, columnNum, "uif-lineItem", 0);
                        this.processGroupSubTotal(lineItemGroup, lineItemGroupRow, "uif-groupSubTotal");
                    }
                }
                for (LineItemRow groupRow : this.rows) {
                    this.flattenedRows.add(groupRow);
                    this.flattenSubLineItemRows(groupRow.getChildRows(), true);
                }
                if (this.renderRowTotalColumn) {
                    this.headerRow.getCellContent().add("Totals");
                    for (LineItemRow row : this.flattenedRows) {
                        if (row.getValues() == null || row.getValues().isEmpty()) continue;
                        ScaleTwoDecimal rowTotal = ScaleTwoDecimal.ZERO;
                        for (ScaleTwoDecimal value : row.getValues()) {
                            rowTotal = (ScaleTwoDecimal)rowTotal.add((AbstractDecimal)value);
                        }
                        this.currencyEditor.setValue((Object)rowTotal);
                        row.getCellContent().add(this.currencyEditor.getAsText());
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception occurred while trying to get value for LineItemTable: " + String.valueOf((Object)this), (Throwable)e);
        }
    }

    private LineItemRow findRow(List<LineItemRow> rows, String identifier) {
        for (LineItemRow row : rows) {
            if (!row.getLineItemId().equals(identifier)) continue;
            return row;
        }
        return null;
    }

    private void processSubLineItems(LineItem lineItem, LineItemRow parentRow, int columnNum, String cssClass, int nestingLevel) {
        ++nestingLevel;
        for (LineItemObject subLineItem : lineItem.getLineItems()) {
            LineItemRow row = this.findRow(parentRow.getChildRows(), subLineItem.getLineItemId());
            if (row == null) {
                row = new LineItemRow(this.getId() + "_" + subLineItem.getLineItemId() + this.lineIndex);
                row.setParentRow(parentRow.getId());
                row.setLineItemId(subLineItem.getLineItemId());
                row.setCssClass(cssClass + nestingLevel);
                row.getCellContent().add(subLineItem.getName());
                parentRow.getChildRows().add(row);
                ++this.lineIndex;
            }
            while (row.getValues().size() + 1 < columnNum) {
                row.getValues().add(ScaleTwoDecimal.ZERO);
                this.currencyEditor.setValue((Object)ScaleTwoDecimal.ZERO);
                row.getCellContent().add(this.currencyEditor.getAsText());
            }
            row.getValues().add(subLineItem.getAmount());
            this.currencyEditor.setValue((Object)subLineItem.getAmount());
            row.getCellContent().add(this.currencyEditor.getAsText());
            if (subLineItem.getLineItems() == null || subLineItem.getLineItems().isEmpty()) continue;
            this.processSubLineItems(subLineItem, row, columnNum, cssClass, nestingLevel);
        }
        for (LineItemRow row : parentRow.getChildRows()) {
            if (row.getId().endsWith("_subTotal")) continue;
            while (row.getValues().size() < columnNum) {
                row.getValues().add(ScaleTwoDecimal.ZERO);
                this.currencyEditor.setValue((Object)ScaleTwoDecimal.ZERO);
                row.getCellContent().add(this.currencyEditor.getAsText());
            }
        }
    }

    private void processGroupSubTotal(LineItemGroup lineItemGroup, LineItemRow parentRow, String cssClass) {
        ScaleTwoDecimal total = ScaleTwoDecimal.ZERO;
        if (!lineItemGroup.isCalculateGroupSubTotal()) {
            return;
        }
        for (LineItemObject subLineItem : lineItemGroup.getLineItems()) {
            total = (ScaleTwoDecimal)total.add((AbstractDecimal)subLineItem.getAmount());
        }
        LineItemRow row = this.findRow(parentRow.getChildRows(), parentRow.getId() + "_subTotal");
        if (row == null) {
            row = new LineItemRow(parentRow.getId() + "_subTotal");
            row.setLineItemId(parentRow.getId() + "_subTotal");
            row.setCssClass(cssClass);
            row.getCellContent().add(lineItemGroup.getGroupName() + " Subtotal");
            parentRow.getChildRows().add(row);
            ++this.lineIndex;
        }
        row.getValues().add(total);
        this.currencyEditor.setValue((Object)total);
        row.getCellContent().add(this.currencyEditor.getAsText());
    }

    private void flattenSubLineItemRows(List<LineItemRow> rows, boolean open) {
        for (LineItemRow row : rows) {
            if (!open) {
                row.setCssClass(row.getCssClass() + " collapse");
            }
            if (this.renderDisclosureLinks && !row.getChildRows().isEmpty()) {
                Object linkText = row.getCellContent().get(0);
                linkText = this.renderOpened ? "<span class=\"icon-chevron-down\" aria-hidden=\"true\"></span> " + (String)linkText : "<span class=\"icon-chevron-right\" aria-hidden=\"true\"></span> " + (String)linkText;
                row.getCellContent().set(0, "<a class=\"uif-lineItem-disclosure\"> " + (String)linkText + "</a>");
            }
            this.flattenedRows.add(row);
            this.flattenSubLineItemRows(row.getChildRows(), this.renderOpened);
        }
    }

    @BeanTagAttribute
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @BeanTagAttribute
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public LineItemRow getHeaderRow() {
        return this.headerRow;
    }

    public List<LineItemRow> getFlattenedRows() {
        return this.flattenedRows;
    }

    @BeanTagAttribute
    public String getDateRangeFormat() {
        return this.dateRangeFormat;
    }

    public void setDateRangeFormat(String dateRangeFormat) {
        this.dateRangeFormat = dateRangeFormat;
    }

    @BeanTagAttribute
    public boolean isRenderRowTotalColumn() {
        return this.renderRowTotalColumn;
    }

    public void setRenderRowTotalColumn(boolean renderRowTotalColumn) {
        this.renderRowTotalColumn = renderRowTotalColumn;
    }

    @BeanTagAttribute
    public int getNumPeriodColumns() {
        return this.numPeriodColumns;
    }

    public void setNumPeriodColumns(int numPeriodColumns) {
        this.numPeriodColumns = numPeriodColumns;
    }

    @BeanTagAttribute
    public boolean isRenderDisclosureLinks() {
        return this.renderDisclosureLinks;
    }

    public void setRenderDisclosureLinks(boolean renderDisclosureLinks) {
        this.renderDisclosureLinks = renderDisclosureLinks;
    }

    @BeanTagAttribute
    public boolean isRenderOpened() {
        return this.renderOpened;
    }

    public void setRenderOpened(boolean renderOpened) {
        this.renderOpened = renderOpened;
    }
}

