/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.sponsor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.SponsorType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.external.dunningcampaign.DunningCampaign;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="SPONSOR")
public class Sponsor
extends KcPersistableBusinessObjectBase
implements SponsorContract,
MutableInactivatable {
    @PortableSequenceGenerator(name="SEQ_SPONSOR_CODE")
    @GeneratedValue(generator="SEQ_SPONSOR_CODE")
    @Id
    @Column(name="SPONSOR_CODE")
    private String sponsorCode;
    @Column(name="ACRONYM")
    private String acronym;
    @Column(name="AUDIT_REPORT_SENT_FOR_FY")
    private String auditReportSentForFy;
    @Column(name="CAGE_NUMBER")
    private String cageNumber;
    @Column(name="COUNTRY_CODE")
    private String countryCode;
    @Column(name="DODAC_NUMBER")
    private String dodacNumber;
    @Column(name="DUN_AND_BRADSTREET_NUMBER")
    private String dunAndBradstreetNumber;
    @Column(name="DUNS_PLUS_FOUR_NUMBER")
    private String dunsPlusFourNumber;
    @Column(name="OWNED_BY_UNIT")
    private String ownedByUnit;
    @Column(name="POSTAL_CODE")
    private String postalCode;
    @Column(name="ROLODEX_ID")
    private Integer rolodexId;
    @Column(name="SPONSOR_NAME")
    private String sponsorName;
    @Column(name="SPONSOR_TYPE_CODE")
    private String sponsorTypeCode;
    @Column(name="STATE")
    private String state;
    @Column(name="CREATE_USER")
    private String createUser;
    @Column(name="DUNNING_CAMPAIGN_ID")
    private String dunningCampaignId;
    @Transient
    private DunningCampaign dunningCampaign;
    @Column(name="CUSTOMER_NUMBER")
    private String customerNumber;
    @Transient
    private String customerExists;
    @Transient
    private String customerTypeCode;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="SPONSOR_TYPE_CODE", referencedColumnName="SPONSOR_TYPE_CODE", insertable=false, updatable=false)
    private SponsorType sponsorType;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="OWNED_BY_UNIT", referencedColumnName="UNIT_NUMBER", insertable=false, updatable=false)
    private Unit unit;
    @OneToOne(mappedBy="sponsor", orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ROLODEX_ID", referencedColumnName="ROLODEX_ID", insertable=false, updatable=false)
    private Rolodex rolodex;
    @Transient
    private transient Boolean nih;
    @Transient
    private transient Boolean kcoiPhs;
    @JsonIgnore
    @Transient
    private transient SponsorHierarchyService sponsorHierarchyService;

    public Sponsor() {
        this.setCreateUser(this.getUpdateUser());
    }

    public String getSponsorCode() {
        return this.sponsorCode;
    }

    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    public String getAuditReportSentForFy() {
        return this.auditReportSentForFy;
    }

    public void setAuditReportSentForFy(String auditReportSentForFy) {
        this.auditReportSentForFy = auditReportSentForFy;
    }

    public String getCageNumber() {
        return this.cageNumber;
    }

    public void setCageNumber(String cageNumber) {
        this.cageNumber = cageNumber;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getDodacNumber() {
        return this.dodacNumber;
    }

    public void setDodacNumber(String dodacNumber) {
        this.dodacNumber = dodacNumber;
    }

    public String getDunAndBradstreetNumber() {
        return this.dunAndBradstreetNumber;
    }

    public void setDunAndBradstreetNumber(String dunAndBradstreetNumber) {
        this.dunAndBradstreetNumber = dunAndBradstreetNumber;
    }

    public String getDunsPlusFourNumber() {
        return this.dunsPlusFourNumber;
    }

    public void setDunsPlusFourNumber(String dunsPlusFourNumber) {
        this.dunsPlusFourNumber = dunsPlusFourNumber;
    }

    public String getOwnedByUnit() {
        return this.ownedByUnit;
    }

    public void setOwnedByUnit(String ownedByUnit) {
        this.ownedByUnit = ownedByUnit;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public void setSponsorName(String sponsorName) {
        this.sponsorName = sponsorName;
    }

    public String getSponsorTypeCode() {
        return this.sponsorTypeCode;
    }

    public void setSponsorTypeCode(String sponsorTypeCode) {
        this.sponsorTypeCode = sponsorTypeCode;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public SponsorType getSponsorType() {
        return this.sponsorType;
    }

    public void setSponsorType(SponsorType sponsorType) {
        this.sponsorType = sponsorType;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    @Override
    public void setUpdateUser(String updateUser) {
        super.setUpdateUser(updateUser);
        this.setCreateUser(updateUser);
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDunningCampaignId() {
        return this.dunningCampaignId;
    }

    public void setDunningCampaignId(String dunningCampaignId) {
        this.dunningCampaignId = dunningCampaignId;
    }

    public DunningCampaign getDunningCampaign() {
        return this.dunningCampaign;
    }

    public void setDunningCampaign(DunningCampaign dunningCampaign) {
        this.dunningCampaign = dunningCampaign;
    }

    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getCustomerExists() {
        return this.customerExists;
    }

    public void setCustomerExists(String customerExists) {
        this.customerExists = customerExists;
    }

    public String getCustomerTypeCode() {
        return this.customerTypeCode;
    }

    public void setCustomerTypeCode(String customerTypeCode) {
        this.customerTypeCode = customerTypeCode;
    }

    public void refreshNonUpdateableReferences() {
    }

    public boolean isNih() {
        if (this.nih == null) {
            this.nih = this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.sponsorCode);
        }
        return this.nih;
    }

    public boolean isKcoiPhs() {
        if (this.kcoiPhs == null) {
            this.kcoiPhs = this.getSponsorHierarchyService().isSponsorKcoiPhs(this.sponsorCode);
        }
        return this.kcoiPhs;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        if (this.sponsorHierarchyService == null) {
            this.sponsorHierarchyService = KcServiceLocator.getService(SponsorHierarchyService.class);
        }
        return this.sponsorHierarchyService;
    }
}

