/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.core.rolodex;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.core.rolodex.RolodexToCorePushService;
import org.kuali.coeus.sys.framework.auth.CoreUserPushService;
import org.kuali.coeus.sys.framework.auth.CoreUsersPushStatus;
import org.kuali.coeus.sys.framework.controller.BackLocationAction;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class RolodexToCorePushAction
extends KualiAction
implements BackLocationAction {
    private static final String PUSH_MESSAGE_KEY = "info.user.bulk.push.complete";
    private static final String AUTH_SERVICE_BULK_PUSH = "AuthServiceBulkPush";
    private static final String PERMISSION_PUSH_ADDRESS_BOOK_USERS_TO_CORE_AUTH = "Push Address Book Users to the Core Auth Service";
    private transient CoreUserPushService rolodexToCorePushService;
    private transient GlobalVariableService globalVariableService;
    private transient PermissionService permissionService;

    public ActionForward pushAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String principalId = this.getGlobalVariableService().getUserSession().getPrincipalId();
        boolean isAuthorized = this.getPermissionService().hasPermission(principalId, "KC-IDM", PERMISSION_PUSH_ADDRESS_BOOK_USERS_TO_CORE_AUTH);
        if (!isAuthorized) {
            throw new UnauthorizedAccessException("Unauthorized to push address book users to the core auth service.");
        }
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, AUTH_SERVICE_BULK_PUSH, "Are you sure you want to push all address book users to the auth service", "confirmationQuestion", "cancel", "");
        }
        if (AUTH_SERVICE_BULK_PUSH.equals(question)) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("0".equals(buttonClicked)) {
                CoreUsersPushStatus status = this.getRolodexToCorePushService().pushAllUsers();
                this.getGlobalVariableService().getMessageList().add(PUSH_MESSAGE_KEY, new String[]{Integer.toString(status.getNumberOfUsers()), Integer.toString(status.getNumberAdded()), Integer.toString(status.getNumberUpdated()), Integer.toString(status.getNumberSame()), Integer.toString(status.getNumberRemoved()), Integer.toString(status.getNumberNotFoundLocally()), Integer.toString(status.getNumberInactiveNotAdded()), Integer.toString(status.getErrors().size())});
            } else {
                return this.returnToSender(request, mapping, (KualiForm)form);
            }
        }
        return mapping.findForward("basic");
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public CoreUserPushService getRolodexToCorePushService() {
        if (this.rolodexToCorePushService == null) {
            this.rolodexToCorePushService = KcServiceLocator.getService(RolodexToCorePushService.class);
        }
        return this.rolodexToCorePushService;
    }

    public void setRolodexToCorePushService(CoreUserPushService rolodexToCorePushService) {
        this.rolodexToCorePushService = rolodexToCorePushService;
    }
}

