/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.mail;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.framework.mail.KcEmailService;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component(value="kcEmailService")
public class KcEmailServiceImpl
implements KcEmailService {
    private static final Logger LOG = LogManager.getLogger(KcEmailServiceImpl.class);
    protected static final String EMAIL_NOTIFICATIONS_ENABLED_PARAM = "EMAIL_NOTIFICATIONS_ENABLED";
    protected static final boolean EMAIL_NOTIFICATIONS_ENABLED_DEFAULT = false;
    protected static final String EMAIL_NOTIFICATIONS_TEST_ENABLED_PARAM = "EMAIL_NOTIFICATION_TEST_ENABLED";
    protected static final boolean EMAIL_NOTIFICATIONS_TEST_ENABLED_DEFAULT = false;
    protected static final String EMAIL_NOTIFICATION_TEST_ADDRESS_PARAM = "EMAIL_NOTIFICATION_TEST_ADDRESS";
    protected static final String EMAIL_NOTIFICATIONS_FROM_ADDRESS_PARAM = "EMAIL_NOTIFICATION_FROM_ADDRESS";
    protected static final String EMAIL_NOTIFICATIONS_FROM_ADDRESS_CONFIG_PARAM = "mail.from";
    protected static final String KC_DEFAULT_EMAIL_RECIPIENT_PARAM = "KC_DEFAULT_EMAIL_RECIPIENT";
    @Autowired
    @Qualifier(value="mailSender")
    private JavaMailSenderImpl mailSender;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;

    @Override
    public void sendEmail(String from, Set<String> toAddresses, String subject, Set<String> ccAddresses, Set<String> bccAddresses, String body, boolean htmlMessage) {
        this.sendEmailWithAttachments(from, toAddresses, subject, ccAddresses, bccAddresses, body, htmlMessage, null, false);
    }

    @Override
    public void forceSendEmail(String from, Set<String> toAddresses, String subject, Set<String> ccAddresses, Set<String> bccAddresses, String body, boolean htmlMessage) {
        this.sendEmailWithAttachments(from, toAddresses, subject, ccAddresses, bccAddresses, body, htmlMessage, null, true);
    }

    @Override
    public void sendEmailWithAttachments(String from, Set<String> toAddresses, String subject, Set<String> ccAddresses, Set<String> bccAddresses, String body, boolean htmlMessage, List<EmailAttachment> attachments) {
        this.sendEmailWithAttachments(from, toAddresses, subject, ccAddresses, bccAddresses, body, htmlMessage, attachments, false);
    }

    @Override
    public void forceSendEmailWithAttachments(String from, Set<String> toAddresses, String subject, Set<String> ccAddresses, Set<String> bccAddresses, String body, boolean htmlMessage, List<EmailAttachment> attachments) {
        this.sendEmailWithAttachments(from, toAddresses, subject, ccAddresses, bccAddresses, body, htmlMessage, attachments, true);
    }

    protected void sendEmailWithAttachments(String from, Set<String> toAddresses, String subject, Set<String> ccAddresses, Set<String> bccAddresses, String body, boolean htmlMessage, List<EmailAttachment> attachments, boolean overrideEnabledStatus) {
        if (this.mailSender != null && (this.isEmailEnabled() || overrideEnabledStatus)) {
            this.populateDefaultAddressIfNoRecipients(toAddresses);
            if (CollectionUtils.isEmpty(toAddresses) && CollectionUtils.isEmpty(ccAddresses) && CollectionUtils.isEmpty(bccAddresses)) {
                return;
            }
            String testAddress = this.getEmailNotificationTestAddress();
            MimeMessage message = this.mailSender.createMimeMessage();
            try {
                MimeMessageHelper helper = new MimeMessageHelper(message, true, StandardCharsets.UTF_8.name());
                helper.setFrom(from);
                if (StringUtils.isNotBlank((CharSequence)subject)) {
                    helper.setSubject(subject);
                } else {
                    LOG.warn("Sending message with empty subject.");
                }
                if (this.isProduction()) {
                    helper.setText(body, htmlMessage);
                    if (CollectionUtils.isNotEmpty(toAddresses)) {
                        for (String toAddress : toAddresses) {
                            try {
                                helper.addTo(toAddress);
                            }
                            catch (Exception ex) {
                                LOG.warn("Could not set to address:", (Throwable)ex);
                            }
                        }
                    }
                    if (CollectionUtils.isNotEmpty(ccAddresses)) {
                        for (String ccAddress : ccAddresses) {
                            try {
                                helper.addCc(ccAddress);
                            }
                            catch (Exception ex) {
                                LOG.warn("Could not set to address:", (Throwable)ex);
                            }
                        }
                    }
                    if (CollectionUtils.isNotEmpty(bccAddresses)) {
                        for (String bccAddress : bccAddresses) {
                            try {
                                helper.addBcc(bccAddress);
                            }
                            catch (Exception ex) {
                                LOG.warn("Could not set to address:", (Throwable)ex);
                            }
                        }
                    }
                } else if (this.isEmailTestEnabled() && StringUtils.isNotBlank((CharSequence)testAddress)) {
                    helper.setText(this.getTestMessageBody(body, toAddresses, ccAddresses, bccAddresses), true);
                    helper.addTo(testAddress);
                } else {
                    return;
                }
                if (CollectionUtils.isNotEmpty(attachments)) {
                    for (EmailAttachment attachment : attachments) {
                        try {
                            helper.addAttachment(attachment.getFileName(), (InputStreamSource)new ByteArrayResource(attachment.getContents()), attachment.getMimeType());
                        }
                        catch (Exception ex) {
                            LOG.warn("Could not set to address:", (Throwable)ex);
                        }
                    }
                }
                this.mailSender.send(message);
            }
            catch (MessagingException ex) {
                LOG.error("Failed to create mime message helper.", (Throwable)ex);
            }
        } else {
            LOG.info("Failed to send email due to inability to obtain valid email mailSender, please check your configuration.");
        }
    }

    private void populateDefaultAddressIfNoRecipients(Set<String> recipients) {
        String defaultRecipient;
        if (CollectionUtils.isEmpty(recipients) && StringUtils.isNotBlank((CharSequence)(defaultRecipient = this.getDefaultToAddress()))) {
            recipients.add(defaultRecipient);
        }
    }

    private String getTestMessageBody(String body, Set<String> toAddresses, Set<String> ccAddresses, Set<String> bccAddresses) {
        StringBuilder testEmailBody = new StringBuilder();
        testEmailBody.append("-----------------------------------------------------------<br/>");
        testEmailBody.append("TEST MODE<br/>");
        testEmailBody.append("In Production mode this mail will be sent to the following... <br/>");
        if (CollectionUtils.isNotEmpty(toAddresses)) {
            testEmailBody.append("TO: ");
            testEmailBody.append(toAddresses);
        }
        if (CollectionUtils.isNotEmpty(ccAddresses)) {
            testEmailBody.append("CC: ");
            testEmailBody.append(toAddresses);
        }
        if (CollectionUtils.isNotEmpty(bccAddresses)) {
            testEmailBody.append("BCC: ");
            testEmailBody.append(toAddresses);
        }
        testEmailBody.append("<br/>-----------------------------------------------------------");
        return testEmailBody.toString() + "<br/>" + body;
    }

    protected boolean isProduction() {
        return ConfigContext.getCurrentContextConfig().isProductionEnvironment();
    }

    protected boolean isEmailEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", EMAIL_NOTIFICATIONS_ENABLED_PARAM, Boolean.valueOf(false));
    }

    protected boolean isEmailTestEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", EMAIL_NOTIFICATIONS_TEST_ENABLED_PARAM, Boolean.valueOf(false));
    }

    private String getEmailNotificationTestAddress() {
        return this.parameterService.getParameterValueAsString("KC-GEN", "All", EMAIL_NOTIFICATION_TEST_ADDRESS_PARAM);
    }

    @Override
    public String getDefaultFromAddress() {
        String xmlFromAddress = this.configurationService.getPropertyValueAsString(EMAIL_NOTIFICATIONS_FROM_ADDRESS_CONFIG_PARAM);
        return this.parameterService.getParameterValueAsString("KC-GEN", "All", EMAIL_NOTIFICATIONS_FROM_ADDRESS_PARAM, xmlFromAddress);
    }

    protected String getDefaultToAddress() {
        return this.parameterService.getParameterValueAsString("KC-GEN", "All", KC_DEFAULT_EMAIL_RECIPIENT_PARAM);
    }

    public void setMailSender(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public JavaMailSenderImpl getMailSender() {
        return this.mailSender;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }
}

