/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.pdf;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.pdf.PdfService;
import org.kuali.coeus.common.api.pdf.dto.JobDto;
import org.kuali.coeus.common.api.pdf.dto.MapAndGenerateXmlDto;
import org.kuali.coeus.common.api.pdf.dto.MapAndGenerateXmlResponseDto;
import org.kuali.coeus.common.api.pdf.dto.Status;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Component(value="pdfService")
public class PdfServiceImpl
implements PdfService {
    private static final Logger LOG = LogManager.getLogger(PdfServiceImpl.class);
    private static final String PDF_SERVICE_PATH = "pdf.service.path";
    private static final String PDF_SERVICE_INTERNAL_PATH = "pdf.service.internal.path";
    private static final String PDF_SERVICE_TIMEOUT_SECONDS = "pdf.service.timeout.seconds";
    private static final Set<Status> JOB_COMPLETE_STATUSES = Set.of(Status.SUCCESS, Status.FAIL);
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(5);
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;

    @Override
    public String submitJob(JobDto jobDto) {
        HttpEntity request = new HttpEntity((Object)jobDto, (MultiValueMap)this.getHeaders());
        return (String)this.restOperations.postForObject(this.getFullPath("/jobs"), (Object)request, String.class, new Object[0]);
    }

    @Override
    public JobDto awaitJob(String jobId) {
        try {
            this.pollForCompletedJob(jobId).get();
            return this.getJob(jobId);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PrintingException(e);
        }
    }

    @Override
    public JobDto submitAndAwaitJob(JobDto job) {
        String jobId = this.submitJob(job);
        return this.awaitJob(jobId);
    }

    @Override
    public Status getJobStatus(String jobId) {
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHeaders());
        String url = this.getFullPath("/jobs/" + jobId + "/status");
        return Status.valueOf((String)this.restOperations.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]).getBody());
    }

    @Override
    public JobDto getJob(String jobId) {
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHeaders());
        String url = this.getFullPath("/jobs/" + jobId);
        return (JobDto)this.restOperations.exchange(url, HttpMethod.GET, entity, JobDto.class, new Object[0]).getBody();
    }

    @Override
    public Set<Status> terminalStatuses() {
        return JOB_COMPLETE_STATUSES;
    }

    @Override
    public MapAndGenerateXmlResponseDto mapAndGenerateXml(MapAndGenerateXmlDto mapAndGenerateXmlDto) {
        HttpEntity entity = new HttpEntity((Object)mapAndGenerateXmlDto, (MultiValueMap)this.getHeaders());
        return (MapAndGenerateXmlResponseDto)this.restOperations.postForObject(this.getFullInternalPath("/mapAndGenerateXml"), (Object)entity, MapAndGenerateXmlResponseDto.class, new Object[0]);
    }

    private CompletableFuture<String> pollForCompletedJob(String jobId) {
        CompletableFuture<String> completionFuture = new CompletableFuture<String>();
        ScheduledFuture<?> checkFuture = EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                Status status = this.getJobStatus(jobId);
                if (JOB_COMPLETE_STATUSES.contains((Object)status)) {
                    completionFuture.complete(status.name());
                }
            }
            catch (Exception e) {
                completionFuture.complete(Status.FAIL.name());
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        EXECUTOR.schedule(() -> completionFuture.complete(Status.FAIL.name()), (long)Integer.parseInt(this.configurationService.getPropertyValueAsString(PDF_SERVICE_TIMEOUT_SECONDS)), TimeUnit.SECONDS);
        completionFuture.whenComplete((result, thrown) -> checkFuture.cancel(true));
        return completionFuture;
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headerParams = new HttpHeaders();
        headerParams.setBearerAuth(this.jwtService.createToken());
        return headerParams;
    }

    private String getFullPathByConfig(String endpoint, String configKey) {
        StringBuilder path = new StringBuilder(this.configurationService.getPropertyValueAsString(configKey));
        if (!path.toString().endsWith("/") && !endpoint.startsWith("/")) {
            path.append("/");
        }
        path.append(endpoint);
        return path.toString();
    }

    private String getFullPath(String endpoint) {
        return this.getFullPathByConfig(endpoint, PDF_SERVICE_PATH);
    }

    private String getFullInternalPath(String endpoint) {
        return this.getFullPathByConfig(endpoint, PDF_SERVICE_INTERNAL_PATH);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    @PostConstruct
    public void setupDebugging() {
        if (this.configurationService.getPropertyValueAsBoolean("print.pdf.logging.enable")) {
            RestTemplate restTemplate = (RestTemplate)this.restOperations;
            restTemplate.getInterceptors().add(new PdfClientHttpRequestInterceptor());
        }
    }

    private class PdfClientHttpRequestInterceptor
    implements ClientHttpRequestInterceptor {
        private PdfClientHttpRequestInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            if (request.getURI().toString().startsWith(PdfServiceImpl.this.configurationService.getPropertyValueAsString(PdfServiceImpl.PDF_SERVICE_PATH))) {
                this.logRequest(request, body);
                ClientHttpResponse response = execution.execute(request, body);
                this.logResponse(response);
                return response;
            }
            return execution.execute(request, body);
        }

        private void logRequest(HttpRequest request, byte[] body) {
            LOG.info("URI: " + String.valueOf(request.getURI()));
            LOG.info("HTTP Method: " + String.valueOf(request.getMethod()));
            LOG.info("HTTP Headers: " + this.headersToString(request.getHeaders()));
            LOG.info("Request Body: " + new String(body, StandardCharsets.UTF_8));
        }

        private void logResponse(ClientHttpResponse response) throws IOException {
            LOG.info("HTTP Status Code: " + response.getRawStatusCode());
            LOG.info("Status Text: " + response.getStatusText());
            LOG.info("HTTP Headers: " + this.headersToString(response.getHeaders()));
            LOG.info("Response Body: Unable to display without caching in memory.");
        }

        private String headersToString(HttpHeaders headers) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : headers.entrySet()) {
                builder.append((String)entry.getKey()).append("=[");
                for (String value : (List)entry.getValue()) {
                    builder.append(value).append(",");
                }
                builder.setLength(builder.length() - 1);
                builder.append("],");
            }
            builder.setLength(builder.length() - 1);
            return builder.toString();
        }
    }
}

