/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.citi;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.citi.CitiDataLoadingService;
import org.kuali.coeus.common.framework.person.citi.CitiDataProcessingService;
import org.kuali.coeus.common.framework.person.citi.CitiService;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecord;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecordStatus;
import org.kuali.coeus.common.impl.person.citi.CitiServiceBusyException;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="citiService")
public class CitiServiceImpl
implements CitiService {
    private static final Logger LOG = LogManager.getLogger(CitiServiceImpl.class);
    private static final String KC_SYSTEM_PRINCIPAL_NM = "kc";
    private static final String STATUS_CODE = "statusCode";
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    @Autowired
    @Qualifier(value="citiDataProcessingService")
    private CitiDataProcessingService citiDataProcessingService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="citiDataLoadingService")
    private CitiDataLoadingService citiDataLoadingService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    @Override
    public void loadAndProcess(LocalDateTime startDate, LocalDateTime endDate) {
        if (this.isRunning.compareAndSet(false, true)) {
            try {
                LOG.info("Starting CITI job");
                this.getGlobalVariableService().doInNewGlobalVariables(new UserSession(KC_SYSTEM_PRINCIPAL_NM), () -> {
                    this.getCitiDataLoadingService().loadRecords(startDate, endDate);
                    this.getCitiDataProcessingService().processRecords();
                    return null;
                });
                LOG.info("Finished CITI job");
            }
            finally {
                this.isRunning.set(false);
            }
        } else {
            throw new CitiServiceBusyException();
        }
    }

    @Override
    public String status() {
        if (this.isRunning()) {
            int errors = this.getBusinessObjectService().countMatching(PersonTrainingCitiRecord.class, Map.of(STATUS_CODE, PersonTrainingCitiRecordStatus.ERRORED.getCode()));
            int processed = this.getBusinessObjectService().countMatching(PersonTrainingCitiRecord.class, Map.of(STATUS_CODE, PersonTrainingCitiRecordStatus.PROCESSED.getCode()));
            int staged = this.getBusinessObjectService().countMatching(PersonTrainingCitiRecord.class, Map.of(STATUS_CODE, PersonTrainingCitiRecordStatus.STAGED.getCode()));
            int total = errors + processed + staged;
            int percentComplete = Math.round((1.0f - (float)staged / (float)total) * 100.0f);
            return String.format("Current job is %d%% complete.  Errors: %d  Success: %d  Total: %d", percentComplete, errors, processed, total);
        }
        return "There are no citi jobs running";
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    public CitiDataProcessingService getCitiDataProcessingService() {
        return this.citiDataProcessingService;
    }

    public void setCitiDataProcessingService(CitiDataProcessingService citiDataProcessingService) {
        this.citiDataProcessingService = citiDataProcessingService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public CitiDataLoadingService getCitiDataLoadingService() {
        return this.citiDataLoadingService;
    }

    public void setCitiDataLoadingService(CitiDataLoadingService citiDataLoadingService) {
        this.citiDataLoadingService = citiDataLoadingService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

