/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.version.history;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.framework.version.sequence.owner.SequenceOwner;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="versionHistoryService")
public class VersionHistoryServiceImpl
implements VersionHistoryService {
    public static final String VERSION_STATUS_FIELD = "statusForOjb";
    public static final String SEQUENCE_OWNER_CLASS_NAME_FIELD = "sequenceOwnerClassName";
    public static final String SEQUENCE_OWNER_REFERENCE_VERSION_NAME = "sequenceOwnerVersionNameValue";
    public static final String SEQUENCE_OWNER_REFERENCE_SEQ_NUMBER = "sequenceOwnerSequenceNumber";
    public static final String SEQUENCE_OWNER_SEQUENCE_NUMBER_FIELD = "sequenceOwnerSequenceNumber";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService bos;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="pessimisticLockService")
    private PessimisticLockService pessimisticLockService;

    protected VersionHistory createVersionHistory(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner, VersionStatus versionStatus, String userId) {
        VersionHistory versionHistory = new VersionHistory(sequenceOwner, versionStatus, userId, new Date(new java.util.Date().getTime()));
        ArrayList<VersionHistory> list = new ArrayList<VersionHistory>();
        list.add(versionHistory);
        this.bos.save(list);
        return versionHistory;
    }

    @Override
    public VersionHistory findPendingVersion(Award award) {
        List<VersionHistory> histories = this.loadVersionHistory(Award.class, award.getAwardNumber());
        VersionHistory foundPending = null;
        for (VersionHistory history : histories) {
            if (history.getStatus() != VersionStatus.PENDING || award.getSequenceNumber() >= history.getSequenceOwnerSequenceNumber()) continue;
            foundPending = history;
            break;
        }
        return foundPending;
    }

    @Override
    public VersionHistory updateVersionHistory(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner, VersionStatus versionStatus, String userId) {
        VersionHistory currentVersion = this.getVersionHistory(sequenceOwner.getClass(), this.getVersionName(sequenceOwner), sequenceOwner.getSequenceNumber());
        if (currentVersion == null) {
            currentVersion = this.createVersionHistory(sequenceOwner, versionStatus, userId);
        }
        currentVersion.setStatus(versionStatus);
        if (versionStatus == VersionStatus.ACTIVE) {
            this.archiveActiveVersions(sequenceOwner.getClass(), this.getVersionName(sequenceOwner), currentVersion);
        }
        this.bos.save((PersistableBusinessObject)currentVersion);
        return currentVersion;
    }

    protected void archiveActiveVersions(Class klass, String versionName, VersionHistory currentVersion) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put(VERSION_STATUS_FIELD, VersionStatus.ACTIVE.toString());
        for (VersionHistory version : this.bos.findMatching(VersionHistory.class, fieldValues)) {
            if (version.equals(currentVersion)) continue;
            version.setStatus(VersionStatus.ARCHIVED);
            this.bos.save((PersistableBusinessObject)version);
        }
    }

    protected VersionHistory getVersionHistory(Class klass, String versionName, Integer sequenceNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put("sequenceOwnerSequenceNumber", sequenceNumber);
        List history = this.getBusinessObjectService().findMatching(VersionHistory.class, fieldValues);
        if (history != null && !history.isEmpty()) {
            return (VersionHistory)history.get(0);
        }
        return null;
    }

    @Override
    public boolean isVersionLockOn() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "Document", "Enable_Lock_On_Document_Version");
    }

    @Override
    public boolean isAnotherUserEditingDocument(String documentNumber) {
        return this.isVersionLockOn() ? this.pessimisticLockService.getPessimisticLocksForDocument(documentNumber).stream().anyMatch(lock -> lock.getLockDescriptor().contains("VersionLock")) : false;
    }

    @Override
    public String getVersionLockDescriptor(String documentTypeCode, String documentNumber) {
        return documentTypeCode + "VersionLock-" + documentNumber + "-" + this.globalVariableService.getUserSession().getPrincipalId();
    }

    @Override
    public VersionHistory findActiveVersion(Class<? extends SequenceOwner> klass, String versionName) {
        ArrayList<VersionHistory> histories = new ArrayList<VersionHistory>(this.bos.findMatching(VersionHistory.class, this.buildFieldValueMapForActiveVersionHistory(klass, versionName)));
        VersionHistory activeVersionHistory = this.findActiveVersionHistory(histories);
        return activeVersionHistory;
    }

    @Override
    public List<VersionHistory> loadVersionHistory(Class<? extends SequenceOwner> klass, String versionName) {
        List<VersionHistory> histories = this.findVersionHistory(klass, versionName);
        if (histories.size() > 0) {
            String versionFieldName = histories.get(0).getSequenceOwnerVersionNameField();
            Map<Integer, SequenceOwner<SequenceOwner<?>>> map = this.findSequenceOwners(klass, versionFieldName, versionName);
            for (VersionHistory vh : histories) {
                SequenceOwner<? extends SequenceOwner<?>> owner = map.get(vh.getSequenceOwnerSequenceNumber());
                if (owner == null) continue;
                vh.setSequenceOwner(owner);
            }
        }
        return histories;
    }

    public void setBusinessObjectService(BusinessObjectService bos) {
        this.bos = bos;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.bos;
    }

    @Override
    public VersionHistory findPendingVersion(Class<? extends SequenceOwner> klass, String versionName, String sequenceNumber) {
        VersionHistory pendingVersionHistory = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put("sequenceOwnerSequenceNumber", sequenceNumber);
        fieldValues.put(VERSION_STATUS_FIELD, VersionStatus.PENDING.name());
        ArrayList histories = new ArrayList(this.bos.findMatching(VersionHistory.class, fieldValues));
        if (CollectionUtils.isNotEmpty(histories)) {
            pendingVersionHistory = (VersionHistory)histories.get(0);
        }
        return pendingVersionHistory;
    }

    @Override
    public VersionHistory findPendingVersion(Class<? extends SequenceOwner> klass, String versionName) {
        VersionHistory pendingVersionHistory = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put(VERSION_STATUS_FIELD, VersionStatus.PENDING.name());
        ArrayList histories = new ArrayList(this.bos.findMatching(VersionHistory.class, fieldValues));
        if (CollectionUtils.isNotEmpty(histories)) {
            pendingVersionHistory = (VersionHistory)histories.get(0);
        }
        return pendingVersionHistory;
    }

    protected Map<String, Object> buildFieldValueMapForActiveVersionHistory(Class<? extends SequenceOwner> klass, String versionName) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put(VERSION_STATUS_FIELD, VersionStatus.ACTIVE.name());
        return fieldValues;
    }

    protected VersionHistory findActiveVersionHistory(List<VersionHistory> histories) {
        VersionHistory activeVersionHistory = null;
        for (VersionHistory vh : histories) {
            if (vh.getStatus() != VersionStatus.ACTIVE) continue;
            activeVersionHistory = vh;
            break;
        }
        return activeVersionHistory;
    }

    @Deprecated
    protected Map<Integer, SequenceOwner<? extends SequenceOwner<?>>> findSequenceOwners(Class klass, String versionField, String versionName) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(versionField, versionName);
        List c = this.bos.findMatching(klass, fieldValues);
        TreeMap map = new TreeMap();
        for (SequenceOwner owner : c) {
            map.put(owner.getSequenceNumber(), owner);
        }
        return map;
    }

    protected String getVersionName(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner) {
        return ObjectUtils.getPropertyValue(sequenceOwner, (String)sequenceOwner.getVersionNameField()).toString();
    }

    @Override
    public List<VersionHistory> findVersionHistory(Class<? extends SequenceOwner> klass, String versionName) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        return new ArrayList<VersionHistory>(this.bos.findMatching(VersionHistory.class, fieldValues));
    }

    public void loadSequenceOwner(Class klass, VersionHistory versionHistory) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(versionHistory.getSequenceOwnerVersionNameField(), versionHistory.getSequenceOwnerVersionNameValue());
        fieldValues.put("sequenceNumber", versionHistory.getSequenceOwnerSequenceNumber());
        List c = this.bos.findMatching(klass, fieldValues);
        for (SequenceOwner sequenceOwner : c) {
            versionHistory.setSequenceOwner(sequenceOwner);
        }
    }

    @Override
    public VersionHistory getActiveOrNewestVersion(Class<? extends SequenceOwner> klass, String versionName) {
        List<VersionHistory> versions = this.findVersionHistory(klass, versionName);
        VersionHistory history = null;
        for (VersionHistory version : versions) {
            if (history == null) {
                history = version;
                continue;
            }
            if (version.isActiveVersion()) {
                history = version;
                continue;
            }
            if (history.isActiveVersion() || version.getSequenceOwnerSequenceNumber() <= history.getSequenceOwnerSequenceNumber() || version.getStatus() == VersionStatus.CANCELED) continue;
            history = version;
        }
        return history;
    }
}

