/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireQuestion;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireUsage;
import org.kuali.coeus.common.questionnaire.impl.QuestionnaireDao;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="questionnaireService")
@Transactional
public class QuestionnaireServiceImpl
implements QuestionnaireService {
    private static final String PARAM_NAME = "associateModuleQuestionnairePermission";
    public static final String MODULE_ITEM_CODE = "moduleItemCode";
    public static final String MODULE_SUB_ITEM_CODE = "moduleSubItemCode";
    public static final String NAME = "name";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="unitAuthorizationService")
    private UnitAuthorizationService unitAuthorizationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="questionnaireDao")
    private QuestionnaireDao questionnaireDao;
    private Map<String, String> permissionModuleMap = new HashMap<String, String>();

    public QuestionnaireServiceImpl() {
        this.permissionModuleMap.put(AwardPermissionConstants.MODIFY_AWARD.getAwardPermission() + ":KC-AB", "1");
        this.permissionModuleMap.put("Edit Institutional Proposal:KC-IP", "2");
        this.permissionModuleMap.put("Maintain Questionnaire Usage:KC-PD", "3");
    }

    @Override
    public boolean isQuestionnaireNameExist(String questionnaireId, String name) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(NAME, name);
        boolean isExist = false;
        List questionnaires = this.businessObjectService.findMatching(Questionnaire.class, fieldValues);
        for (Questionnaire questionnaire : questionnaires) {
            if (questionnaireId != null && questionnaire.getQuestionnaireSeqId().equals(questionnaireId)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    @Override
    public void copyQuestionnaire(Questionnaire src, Questionnaire dest) {
        this.copyQuestionnaireLists(src, dest);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected void copyQuestionnaireLists(Questionnaire src, Questionnaire dest) {
        dest.setQuestionnaireQuestions(src.getQuestionnaireQuestions());
        dest.setQuestionnaireUsages(src.getQuestionnaireUsages());
        dest.setQuestionnaireSeqId(null);
        for (QuestionnaireQuestion question : dest.getQuestionnaireQuestions()) {
            question.setQuestionnaireId(null);
            question.setId(null);
            question.setVersionNumber(1L);
        }
        for (QuestionnaireUsage usage : dest.getQuestionnaireUsages()) {
            usage.setQuestionnaireId(null);
            usage.setId(null);
            usage.setVersionNumber(1L);
        }
    }

    @Override
    public List<String> getAssociateModules() {
        HashSet<String> modules = new HashSet<String>();
        Collection parameters = this.parameterService.getParameterValuesAsString("KC-QUESTIONNAIRE", "P", PARAM_NAME);
        for (String permission : parameters) {
            String module;
            String[] params = permission.split(":");
            boolean unitAuthCheck = this.unitAuthorizationService.hasPermission(this.globalVariableService.getUserSession().getPerson().getPrincipalId(), params[1], params[0]);
            if (!unitAuthCheck || modules.contains(this.permissionModuleMap.get(permission)) || !StringUtils.isNotBlank((CharSequence)(module = this.permissionModuleMap.get(permission)))) continue;
            modules.add(module);
        }
        return new ArrayList<String>(modules);
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public boolean isUniqueUsage(Questionnaire questionnaire, QuestionnaireUsage usage) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, usage.getCoeusModule().getModuleCode());
        fieldValues.put(MODULE_SUB_ITEM_CODE, usage.getCoeusSubModule().getSubModuleCode());
        List usages = this.businessObjectService.findMatching(QuestionnaireUsage.class, fieldValues);
        for (QuestionnaireUsage curUsage : usages) {
            if (StringUtils.equals((CharSequence)questionnaire.getQuestionnaireSeqId(), (CharSequence)curUsage.getQuestionnaire().getQuestionnaireSeqId()) || !curUsage.getQuestionnaire().isActive() || !this.isCurrentQuestionnaire(curUsage.getQuestionnaire())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCurrentQuestionnaire(Questionnaire questionnaire) {
        return questionnaire.getSequenceNumber().equals(this.getQuestionnaireDao().getCurrentQuestionnaireSequenceNumber(questionnaire.getQuestionnaireSeqId()));
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        return this.unitAuthorizationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public void setQuestionnaireDao(QuestionnaireDao questionnaireDao) {
        this.questionnaireDao = questionnaireDao;
    }

    public QuestionnaireDao getQuestionnaireDao() {
        return this.questionnaireDao;
    }
}

