/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment.institute;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.propdev.impl.attachment.NarrativeType;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="instituteAttachmentTypeValuesFinder")
public class InstituteAttachmentTypeValuesFinder
extends UifKeyValuesFinderBase {
    private static final String SYSTEM_GENERATED = "systemGenerated";
    private static final String NARRATIVE_TYPE_GROUP = "narrativeTypeGroup";
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public List<KeyValue> getKeyValues() {
        List<NarrativeType> narrativeTypes = this.getInstituteNarrativeTypes();
        if (this.shouldAttachmentListBeAlphabetized().booleanValue()) {
            narrativeTypes.sort(Comparator.comparing(NarrativeType::getDescription, Comparator.nullsFirst(Comparator.naturalOrder())));
        }
        return narrativeTypes.stream().map(narrativeType -> new ConcreteKeyValue(narrativeType.getCode(), narrativeType.getDescription())).collect(Collectors.toList());
    }

    protected String getInstituteNarrativeTypeGroup() {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "instituteNarrativeTypeGroup");
    }

    protected Boolean shouldAttachmentListBeAlphabetized() {
        return this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "alphabetizeAttachmentTypes");
    }

    protected List<NarrativeType> getInstituteNarrativeTypes() {
        return this.getDataObjectService().findMatching(NarrativeType.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)NARRATIVE_TYPE_GROUP, (Object)this.getInstituteNarrativeTypeGroup()), PredicateFactory.equal((String)SYSTEM_GENERATED, (Object)false)})).getResults();
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

