/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person.attachment;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.person.attachment.AddPersonnelAttachmentEvent;
import org.kuali.coeus.propdev.impl.person.attachment.AddPersonnelAttachmentRule;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiographyService;
import org.kuali.coeus.propdev.impl.person.attachment.ReplacePersonnelAttachmentEvent;
import org.kuali.coeus.propdev.impl.person.attachment.ReplacePersonnelAttachmentRule;
import org.kuali.coeus.propdev.impl.person.attachment.SavePersonnelAttachmentEvent;
import org.kuali.coeus.propdev.impl.person.attachment.SavePersonnelAttachmentRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentPersonnelAttachmentRule
extends KcTransactionalDocumentRuleBase
implements AddPersonnelAttachmentRule,
SavePersonnelAttachmentRule,
ReplacePersonnelAttachmentRule {
    public static final String OTHER_DOCUMENT_TYPE_DESCRIPTION = "Other";
    private static final String DOC_TYPE_DESCRIPTION = "description";
    private static final String DOCUMENT_TYPE_CODE = "documentTypeCode";
    private static final String PERSONNEL_ATTACHMENT_FILE = "multipartFile";
    private static final String PROPOSAL_PERSON_NUMBER = "proposalPersonNumberString";
    private transient KcAttachmentService kcAttachmentService;
    private transient ParameterService parameterService;
    private transient ProposalPersonBiographyService proposalPersonBiographyService;

    @Override
    public boolean processAddPersonnelAttachmentBusinessRules(AddPersonnelAttachmentEvent addPersonnelAttachmentEvent) {
        String attachmentFileName;
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)addPersonnelAttachmentEvent.getDocument();
        ProposalPersonBiography proposalPersonBiography = addPersonnelAttachmentEvent.getProposalPersonBiography();
        boolean rulePassed = true;
        if (StringUtils.isBlank((CharSequence)proposalPersonBiography.getDocumentTypeCode())) {
            rulePassed = false;
            this.reportError(DOCUMENT_TYPE_CODE, "error.proposalAttachment.narrativeType.notSelected", new String[0]);
        }
        if (this.getProposalPersonBiographyService().findPropPerDocTypeForOther().getCode().equalsIgnoreCase(proposalPersonBiography.getDocumentTypeCode()) && StringUtils.isBlank((CharSequence)proposalPersonBiography.getDescription())) {
            this.reportError(DOC_TYPE_DESCRIPTION, "error.personnelAttachment.description.required", new String[0]);
            rulePassed = false;
        }
        if (StringUtils.isBlank((CharSequence)(attachmentFileName = proposalPersonBiography.getName()))) {
            rulePassed = false;
            this.reportError(PERSONNEL_ATTACHMENT_FILE, "error.required.for.fileName", new String[0]);
        } else {
            String invalidCharacters = this.getKcAttachmentService().getInvalidCharacters(attachmentFileName);
            if (!this.checkForInvalidCharacters(invalidCharacters)) {
                String parameter = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "INVALID_FILE_NAME_CHECK");
                if ("2".equals(parameter)) {
                    rulePassed = false;
                    this.reportError(PERSONNEL_ATTACHMENT_FILE, "error.institutionalProposal.notesAndAttachments.fileName.invalid", attachmentFileName, invalidCharacters);
                } else {
                    rulePassed &= true;
                    this.reportWarning(PERSONNEL_ATTACHMENT_FILE, "error.institutionalProposal.notesAndAttachments.fileName.invalid", attachmentFileName, invalidCharacters);
                }
            }
        }
        boolean isS2S = document.getDevelopmentProposal().hasS2sOpportunity();
        if (isS2S && document.getDevelopmentProposal().isNIHSponsor()) {
            rulePassed &= this.getKcAttachmentService().validPDFFile(proposalPersonBiography, this.getErrorReporter(), PERSONNEL_ATTACHMENT_FILE);
        }
        if (!this.validDescription(proposalPersonBiography, document.getDevelopmentProposal())) {
            rulePassed = false;
            this.reportError(DOC_TYPE_DESCRIPTION, "error.proposalAttachment.description.illegalCharacters", new String[0]);
        }
        if (!this.checkForProposalPerson(proposalPersonBiography)) {
            rulePassed = false;
            this.reportError(PROPOSAL_PERSON_NUMBER, "error.personnelAttachment.person.required", new String[0]);
        }
        if (!this.checkForDuplicates(proposalPersonBiography, document.getDevelopmentProposal().getPropPersonBios())) {
            rulePassed = false;
            this.reportError(DOCUMENT_TYPE_CODE, "error.personnelAttachment.person.duplicate", new String[0]);
        }
        return rulePassed;
    }

    protected boolean validDescription(ProposalPersonBiography proposalPersonBiography, DevelopmentProposal developmentProposal) {
        return !StringUtils.contains((CharSequence)proposalPersonBiography.getDescription(), (int)38) || !developmentProposal.hasS2sOpportunity();
    }

    @Override
    public boolean processReplacePersonnelAttachmentBusinessRules(ReplacePersonnelAttachmentEvent event) {
        boolean retVal = this.checkForInvalidCharacters(this.getKcAttachmentService().getInvalidCharacters(event.getProposalPersonBiography().getName()));
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)event.getDocument();
        boolean isS2S = document.getDevelopmentProposal().hasS2sOpportunity();
        if (isS2S && document.getDevelopmentProposal().isNIHSponsor()) {
            retVal &= this.getKcAttachmentService().validPDFFile(event.getProposalPersonBiography(), this.getErrorReporter(), PERSONNEL_ATTACHMENT_FILE);
        }
        return retVal;
    }

    @Override
    public boolean processSavePersonnelAttachmentBusinessRules(SavePersonnelAttachmentEvent savePersonnelAttachmentEvent) {
        boolean retVal = true;
        ProposalPersonBiography biography = savePersonnelAttachmentEvent.getProposalPersonBiography();
        List<ProposalPersonBiography> biographies = ((ProposalDevelopmentDocument)savePersonnelAttachmentEvent.getDocument()).getDevelopmentProposal().getPropPersonBios();
        int index = Integer.parseInt(savePersonnelAttachmentEvent.getErrorPathPrefix());
        DevelopmentProposal proposal = ((ProposalDevelopmentDocument)savePersonnelAttachmentEvent.getDocument()).getDevelopmentProposal();
        if (!this.checkForDescription(biography)) {
            retVal = false;
            this.getAuditErrors("Personnel Attachments", "Error").add(new AuditError("document.developmentProposal.propPersonBios", "error.personnelAttachment.description.required", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-PersonnelSection"));
        }
        if (!this.checkForInvalidCharacters(this.getKcAttachmentService().getInvalidCharacters(biography.getName()))) {
            retVal = false;
            String parameter = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "INVALID_FILE_NAME_CHECK");
            if ("2".equals(parameter)) {
                this.getAuditErrors("Personnel Attachments", "Error").add(new AuditError("document.developmentProposal.propPersonBios", "error.institutionalProposal.notesAndAttachments.fileName.invalid", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-PersonnelSection"));
            } else {
                this.getAuditErrors("Personnel Attachments", "Warnings").add(new AuditError("document.developmentProposal.propPersonBios", "error.institutionalProposal.notesAndAttachments.fileName.invalid", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-PersonnelSection"));
            }
        }
        if (proposal.hasS2sOpportunity() && proposal.isNIHSponsor()) {
            retVal &= this.getKcAttachmentService().validPDFFile(biography, this.getErrorReporter(), PERSONNEL_ATTACHMENT_FILE);
        }
        if (!this.validDescription(biography, proposal)) {
            retVal = false;
            this.getAuditErrors("Personnel Attachments", "Error").add(new AuditError("document.developmentProposal.propPersonBios", "error.proposalAttachment.description.illegalCharacters", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-PersonnelSection"));
        }
        if (!this.checkForDuplicates(biography, biographies)) {
            retVal = false;
            this.getAuditErrors("Personnel Attachments", "Error").add(new AuditError(String.format("document.developmentProposal.propPersonBios[%d].documentTypeCode", index), "error.personnelAttachment.person.duplicate", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-PersonnelSection"));
        }
        if (!this.checkForProposalPerson(biography)) {
            retVal = false;
            this.getAuditErrors("Personnel Attachments", "Error").add(new AuditError(String.format("document.developmentProposal.propPersonBios[%d].proposalPersonNumberString", index), "error.personnelAttachment.person.required", "PropDev-AttachmentsPage.PropDev-AttachmentsPage-PersonnelSection"));
        }
        return retVal;
    }

    private boolean checkForDescription(ProposalPersonBiography biography) {
        boolean valid = true;
        String otherCode = this.getProposalPersonBiographyService().findPropPerDocTypeForOther().getCode();
        if (StringUtils.equalsIgnoreCase((CharSequence)otherCode, (CharSequence)biography.getDocumentTypeCode()) && StringUtils.isBlank((CharSequence)biography.getDescription())) {
            valid = false;
        }
        return valid;
    }

    private boolean checkForDuplicates(ProposalPersonBiography biography, List<ProposalPersonBiography> existingBiographies) {
        boolean rulePassed = true;
        if (CollectionUtils.isNotEmpty(existingBiographies) && biography.getProposalPersonNumber() != null) {
            for (ProposalPersonBiography personBiography : existingBiographies) {
                if (personBiography.getProposalPersonNumber() == null || personBiography.getDocumentTypeCode() == null || StringUtils.equalsIgnoreCase((CharSequence)this.getProposalPersonBiographyService().findPropPerDocTypeForOther().getCode(), (CharSequence)personBiography.getDocumentTypeCode()) || !personBiography.getProposalPersonNumber().equals(biography.getProposalPersonNumber()) || !personBiography.getDocumentTypeCode().equals(biography.getDocumentTypeCode()) || personBiography.getBiographyNumber().equals(biography.getBiographyNumber())) continue;
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    protected boolean checkForInvalidCharacters(String invalidCharacters) {
        boolean rulePassed = true;
        if (StringUtils.isNotEmpty((CharSequence)invalidCharacters)) {
            rulePassed = false;
        }
        return rulePassed;
    }

    private boolean checkForProposalPerson(ProposalPersonBiography proposalPersonBiography) {
        boolean rulePassed = true;
        if (proposalPersonBiography.getProposalPersonNumber() == null || StringUtils.isBlank((CharSequence)proposalPersonBiography.getProposalPersonNumber().toString())) {
            rulePassed = false;
        }
        return rulePassed;
    }

    private List<AuditError> getAuditErrors(String sectionName, String severity) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String clusterKey = "Attachments." + sectionName;
        if (!GlobalVariables.getAuditErrorMap().containsKey(clusterKey + severity)) {
            GlobalVariables.getAuditErrorMap().put(clusterKey + severity, new AuditCluster(clusterKey, auditErrors, severity));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(clusterKey + severity)).getAuditErrorList();
        }
        return auditErrors;
    }

    protected KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = KcServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public ProposalPersonBiographyService getProposalPersonBiographyService() {
        if (this.proposalPersonBiographyService == null) {
            this.proposalPersonBiographyService = KcServiceLocator.getService(ProposalPersonBiographyService.class);
        }
        return this.proposalPersonBiographyService;
    }
}

