/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.preproposal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormsValueConverter;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.kualibuild.KualiBuildApiService;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildGadgetDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildGroupDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildIdLabelDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildRoleDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildUserDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="preproposalFormsValueConverter")
public class PreproposalFormsValueConverterImpl
implements PreproposalFormsValueConverter {
    @Autowired
    private KualiBuildApiService kualiBuildApiService;
    private static final Logger LOG = LogManager.getLogger();
    public static final String OPTION_GADGET_VALUE_KEY = "label";
    private static final BigDecimal CENTS_PER_DOLLAR = new BigDecimal("100");

    @Override
    public Optional<?> convertValueFromBuild(@NotNull KualiBuildGadgetDto gadget, Object buildValue) {
        if (buildValue == null) {
            return Optional.empty();
        }
        Object value = switch (gadget.getType()) {
            case "Checkboxes" -> this.checkboxValueOf(buildValue);
            case "Currency" -> this.convertCurrencyFromBuild(buildValue);
            case "Date" -> new Date((Long)buildValue);
            case "Dropdown", "Radios" -> ((Map)buildValue).get(OPTION_GADGET_VALUE_KEY);
            case "Table", "UserTypeahead", "GroupTypeahead" -> null;
            default -> buildValue;
        };
        return Optional.ofNullable(value);
    }

    private ScaleTwoDecimal convertCurrencyFromBuild(Object buildValue) {
        BigDecimal cents = new BigDecimal(String.valueOf(buildValue));
        return new ScaleTwoDecimal(cents.divide(CENTS_PER_DOLLAR, 2, RoundingMode.UNNECESSARY));
    }

    private String checkboxValueOf(Object raw) {
        List values = (List)raw;
        return values.stream().map(r -> r.get(OPTION_GADGET_VALUE_KEY)).map(String::valueOf).collect(Collectors.joining(", "));
    }

    @Override
    public Object convertValueForBuild(KualiBuildGadgetDto gadget, Object value) {
        if (value == null) {
            return null;
        }
        return switch (gadget.getType()) {
            case "Currency" -> this.convertCurrencyForBuild(value);
            case "Date" -> this.convertDateForBuild(value);
            case "Table" -> {
                if (value instanceof Collection && !((Collection)value).isEmpty()) {
                    yield value;
                }
                yield null;
            }
            case "GroupTypeahead" -> this.convertGroupNameForBuild(value);
            case "UserTypeahead" -> this.convertRoleLookupForBuild(value);
            default -> value;
        };
    }

    private BigInteger convertCurrencyForBuild(@NotNull Object value) {
        if (value instanceof Number) {
            Number num = (Number)value;
            value = num.toString();
        }
        if (value instanceof String) {
            String str = (String)value;
            return new BigDecimal(str).multiply(CENTS_PER_DOLLAR).toBigInteger();
        }
        return null;
    }

    private Date convertDateForBuild(@NotNull Object value) {
        if (value instanceof Date) {
            Date sqlDate = (Date)value;
            return sqlDate;
        }
        if (value instanceof java.util.Date) {
            java.util.Date utilDate = (java.util.Date)value;
            return new Date(utilDate.getTime());
        }
        if (value instanceof String) {
            String strValue = (String)value;
            try {
                SimpleDateFormat parser = new SimpleDateFormat("MM/dd/yyyy");
                return new Date(parser.parse(strValue).getTime());
            }
            catch (ParseException e) {
                LOG.warn("Cannot parse \"{}\" as date for Build: {}", (Object)strValue, (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    private KualiBuildIdLabelDto convertGroupNameForBuild(@NotNull Object value) {
        if (!(value instanceof String)) {
            return null;
        }
        List<KualiBuildGroupDto> groupDtos = this.kualiBuildApiService.groupForName((String)value);
        Optional maybeGroup = groupDtos.stream().findFirst();
        if (maybeGroup.isEmpty()) {
            LOG.warn(String.format("Unable to find group with name %s", value));
            return null;
        }
        KualiBuildGroupDto groupDto = (KualiBuildGroupDto)maybeGroup.get();
        KualiBuildIdLabelDto groupGadgetDto = new KualiBuildIdLabelDto();
        groupGadgetDto.setId(groupDto.getId());
        groupGadgetDto.setLabel(groupDto.getName());
        return groupGadgetDto;
    }

    private KualiBuildIdLabelDto convertRoleLookupForBuild(@NotNull Object value) {
        if (!(value instanceof Pair)) {
            return null;
        }
        Object groupName = ((Pair)value).getLeft();
        Object roleSlug = ((Pair)value).getRight();
        if (!(groupName instanceof String) || !(roleSlug instanceof String)) {
            return null;
        }
        List<KualiBuildGroupDto> groupDtos = this.kualiBuildApiService.groupForName((String)groupName);
        if (groupDtos.size() != 1) {
            LOG.warn(String.format("Unable to find group with name %s", groupName));
            return null;
        }
        String roleName = ((String)roleSlug).replaceAll("_", " ");
        List<KualiBuildRoleDto> kualiBuildRoleDtos = this.kualiBuildApiService.getUnitRoles((String)groupName);
        Optional<KualiBuildRoleDto> kualiBuildRoleDto = kualiBuildRoleDtos.stream().filter(role -> role.getName().equalsIgnoreCase(roleName)).findFirst();
        if (kualiBuildRoleDto.isEmpty()) {
            LOG.warn(String.format("No role %s found for group %s", roleName, groupName));
            return null;
        }
        Optional kualiBuildUserDto = kualiBuildRoleDto.get().getMembers().stream().findFirst();
        if (kualiBuildUserDto.isEmpty()) {
            LOG.warn(String.format("No user found in role %s in group %s", roleName, groupName));
            return null;
        }
        KualiBuildIdLabelDto idLabelDto = new KualiBuildIdLabelDto();
        idLabelDto.setId(((KualiBuildUserDto)kualiBuildUserDto.get()).getId());
        idLabelDto.setLabel(((KualiBuildUserDto)kualiBuildUserDto.get()).getDisplayName());
        return idLabelDto;
    }

    @Override
    public boolean valuesMatch(@NotNull KualiBuildGadgetDto gadget, @NotNull Optional<?> buildValue, @NotNull Optional<?> pdValue) {
        Optional<String> buildValueStr = buildValue.map(this::valueToString);
        Optional<String> pdValueStr = pdValue.map(val -> this.convertValueForComparisonToBuild(gadget, val)).map(this::valueToString);
        return pdValueStr.equals(buildValueStr);
    }

    private String valueToString(Object value) {
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            return values.stream().map(this::valueToString).collect(Collectors.joining(", "));
        }
        return String.valueOf(value);
    }

    private Object convertValueForComparisonToBuild(@NotNull KualiBuildGadgetDto gadget, Object value) {
        if (value == null) {
            return null;
        }
        return switch (gadget.getType()) {
            case "Currency" -> this.convertCurrencyToNumber(value);
            case "Date" -> this.convertDateForBuild(value);
            default -> value;
        };
    }

    private ScaleTwoDecimal convertCurrencyToNumber(Object value) {
        if (value instanceof Number) {
            Number num = (Number)value;
            return new ScaleTwoDecimal(num.doubleValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            return new ScaleTwoDecimal(new BigDecimal(str));
        }
        return null;
    }
}

