/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class CustomSqlDateDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ArrayList<SimpleDateFormat> knownFormats = new ArrayList<SimpleDateFormat>();
        knownFormats.add(new SimpleDateFormat("MM/dd/yyyy"));
        knownFormats.add(new SimpleDateFormat("yyyy-MM-dd"));
        knownFormats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        String dateText = jp.getText();
        for (SimpleDateFormat format : knownFormats) {
            try {
                return new Date(format.parse(dateText).getTime());
            }
            catch (ParseException parseException) {
            }
        }
        try {
            return new Date(Long.parseLong(dateText));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Cannot convert date " + dateText, e);
        }
    }
}

