/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class KrmsAuditRuleBase
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private KrmsRulesExecutionService krmsRulesExecutionService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        List<Map<String, String>> krmsErrors = this.getKrmsRulesExecutionService().processUnitKcValidations(this.getUnitNumbers(document), this.getKrmsRulesContext(document));
        for (Map<String, String> error : krmsErrors) {
            valid = false;
            this.getAuditCluster(error).getAuditErrorList().add(this.createAuditError(error));
        }
        return valid;
    }

    protected AuditCluster getAuditCluster(Map<String, String> error) {
        AuditCluster cluster;
        String actionUIPanel = error.get("actionUIPanel");
        String clusterKey = this.getKeyMapping(actionUIPanel).get(2);
        String clusterName = actionUIPanel;
        String clusterCategory = "Unit Business Rules Errors";
        if (error.get("actionTypeCode").equals("W")) {
            clusterKey = clusterKey.replace("Errors", "Warnings");
            clusterCategory = "Unit Business Rules Warnings";
        }
        if ((cluster = (AuditCluster)GlobalVariables.getAuditErrorMap().get(clusterKey)) == null || cluster.getAuditErrorList() == null || !StringUtils.equals((CharSequence)cluster.getCategory(), (CharSequence)clusterCategory)) {
            cluster = new AuditCluster(clusterName, new ArrayList(), clusterCategory);
            GlobalVariables.getAuditErrorMap().put(clusterKey, cluster);
        }
        return cluster;
    }

    protected AuditError createAuditError(Map<String, String> error) {
        String errorParam = error.get("actionMessage");
        String actionUIPanel = error.get("actionUIPanel");
        String auditKey = this.getKeyMapping(actionUIPanel).get(0);
        String tab = this.getKeyMapping(actionUIPanel).get(1);
        String link = tab + "." + actionUIPanel.replaceAll("\\W", "");
        return new AuditError(auditKey, "error.krms", link, new String[]{errorParam});
    }

    protected abstract String getUnitNumbers(Document var1);

    protected abstract KrmsRulesContext getKrmsRulesContext(Document var1);

    protected abstract List<String> getKeyMapping(String var1);

    public KrmsRulesExecutionService getKrmsRulesExecutionService() {
        if (this.krmsRulesExecutionService == null) {
            this.krmsRulesExecutionService = KcServiceLocator.getService(KrmsRulesExecutionService.class);
        }
        return this.krmsRulesExecutionService;
    }

    public void setKrmsRulesExecutionService(KrmsRulesExecutionService krmsRulesExecutionService) {
        this.krmsRulesExecutionService = krmsRulesExecutionService;
    }
}

