/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.session.ser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class SerializableUtils {
    private SerializableUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static SerInfo getSerializationInfo(Object obj) {
        if (obj == null) {
            return SerInfo.pass(0);
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                DebuggingObjectOutputStream oos = new DebuggingObjectOutputStream(bos);
                try {
                    try {
                        oos.writeObject(obj);
                    }
                    catch (IOException e) {
                        SerInfo serInfo = SerInfo.fail(oos.getStack().stream().map(o -> o.getClass().getName()).collect(Collectors.joining("->")));
                        oos.close();
                        bos.close();
                        return serInfo;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        oos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                bos.flush();
                SerInfo serInfo = SerInfo.pass(bos.size());
                oos.close();
                return serInfo;
            }
            finally {
                try {
                    bos.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable3;
                    throwable3.addSuppressed(throwable);
                }
            }
        }
        catch (IOException e) {
            return SerInfo.fail(obj.getClass().getName());
        }
    }

    static class SerInfo {
        private final boolean serializable;
        private final int size;
        private final String failurePath;

        private SerInfo(boolean serializable, int size, String failurePath) {
            this.serializable = serializable;
            this.size = size;
            this.failurePath = failurePath;
        }

        static SerInfo pass(int size) {
            return new SerInfo(true, size, "");
        }

        static SerInfo fail(String failurePath) {
            return new SerInfo(false, -1, failurePath);
        }

        public boolean isSerializable() {
            return this.serializable;
        }

        public int getSize() {
            return this.size;
        }

        public String getFailurePath() {
            return this.failurePath;
        }

        public String toString() {
            return "SerInfo{serializable=" + this.serializable + ", size=" + this.size + ", failurePath='" + this.failurePath + "'}";
        }
    }

    public static class DebuggingObjectOutputStream
    extends ObjectOutputStream {
        private static final Field DEPTH_FIELD;
        private final List<Object> stack = new ArrayList<Object>();
        boolean broken = false;

        public DebuggingObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object o) {
            int currentDepth = this.currentDepth();
            if (o instanceof IOException && currentDepth == 0) {
                this.broken = true;
            }
            if (!this.broken) {
                this.truncate(currentDepth);
                this.stack.add(o);
            }
            return o;
        }

        private void truncate(int depth) {
            while (this.stack.size() > depth) {
                this.pop();
            }
        }

        private Object pop() {
            return this.stack.remove(this.stack.size() - 1);
        }

        private int currentDepth() {
            try {
                Integer oneBased = (Integer)DEPTH_FIELD.get(this);
                return oneBased - 1;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        public List<Object> getStack() {
            return this.stack;
        }

        static {
            try {
                DEPTH_FIELD = ObjectOutputStream.class.getDeclaredField("depth");
                DEPTH_FIELD.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

