/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow;

import org.kuali.coeus.sys.impl.workflow.action.KcRecallAction;
import org.kuali.coeus.sys.impl.workflow.action.KcReturnToPreviousNodeAction;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.impl.WorkflowDocumentServiceImpl;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.krad.util.GlobalVariables;

public class KcWorkflowDocumentServiceImpl
extends WorkflowDocumentServiceImpl {
    public DocumentRouteHeaderValue returnDocumentToPreviousNode(String principalId, DocumentRouteHeaderValue routeHeader, String destinationNodeName, String annotation) throws InvalidActionTakenException {
        if (this.isProposalDevelopmentDocument(routeHeader)) {
            Principal principal = this.loadPrincipal(principalId);
            KcReturnToPreviousNodeAction action = new KcReturnToPreviousNodeAction(routeHeader, principal, annotation, destinationNodeName, true);
            action.performAction();
            return this.finish(routeHeader);
        }
        return super.returnDocumentToPreviousNode(principalId, routeHeader, destinationNodeName, annotation);
    }

    public DocumentRouteHeaderValue recallDocument(String principalId, DocumentRouteHeaderValue routeHeader, String annotation, boolean cancel) throws InvalidActionTakenException {
        if (this.isProposalDevelopmentDocument(routeHeader)) {
            if (!routeHeader.isFinal() && !routeHeader.isProcessed()) {
                Principal principal = this.loadPrincipal(principalId);
                KcRecallAction action = new KcRecallAction(routeHeader, (PrincipalContract)principal, annotation, cancel);
                action.performAction();
                this.indexForSearchAfterActionIfNecessary(routeHeader);
            } else {
                GlobalVariables.getMessageMap().putError("document", "message.recall.not.supported", new String[0]);
            }
            return this.finish(routeHeader);
        }
        return super.recallDocument(principalId, routeHeader, annotation, cancel);
    }

    protected boolean isProposalDevelopmentDocument(DocumentRouteHeaderValue routeHeader) {
        return routeHeader.getDocumentType() != null && routeHeader.getDocumentType().getName().equalsIgnoreCase("ProposalDevelopmentDocument");
    }
}

